/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs;

import openmods.codecs.IProxy;
import openmods.codecs.Log;
import openmods.codecs.NotEnoughCodecs;
import openmods.codecs.adapters.CodecFLAC;
import openmods.codecs.adapters.CodecMP3;
import paulscode.sound.ICodec;
import paulscode.sound.SoundSystemConfig;

public class ClientProxy
implements IProxy {
    private static void registerCodec(Class<? extends ICodec> cls, String ext, String ... mimeTypes) {
        try {
            SoundSystemConfig.setCodec((String)ext, cls);
            for (String type : mimeTypes) {
                NotEnoughCodecs.KNOWN_MIME_TYPES.put(type, ext);
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Can't register codec %s for extension %s", cls.getName(), ext);
        }
    }

    private static void registerCodec(String clsName, String ext, String ... mimeTypes) {
        try {
            Class<?> cls = Class.forName(clsName);
            Class<ICodec> castedCls = cls.asSubclass(ICodec.class);
            ClientProxy.registerCodec(castedCls, ext, mimeTypes);
        }
        catch (Throwable t) {
            Log.warn(t, "Can't register codec %s for extension %s", clsName, ext);
        }
    }

    @Override
    public void registerCodecs() {
        ClientProxy.registerCodec(CodecMP3.class, "MP3", "audio/mpeg", "audio/x-mpeg", "audio/mpeg3", "audio/x-mpeg3");
        ClientProxy.registerCodec(CodecFLAC.class, "FLAC", "audio/flac");
        ClientProxy.registerCodec("paulscode.sound.codecs.CodecIBXM", "XM", "audio/xm", "audio/x-xm");
        ClientProxy.registerCodec("paulscode.sound.codecs.CodecIBXM", "S3M", "audio/s3m", "audio/x-s3m");
        ClientProxy.registerCodec("paulscode.sound.codecs.CodecIBXM", "MOD", "audio/mod", "audio/x-mod");
        ClientProxy.registerCodec("paulscode.sound.codecs.CodecWav", "WAV", "audio/wav", "audio/x-wav", "audio/wave");
    }
}

