/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import gnu.trove.map.hash.TIntFloatHashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.item.ItemMetaDynamic;

public class ItemEdible
extends ItemFood {
    private ItemMetaDynamic dynamic;
    protected TIntIntHashMap foodLevels;
    protected TIntFloatHashMap saturations;
    protected TIntObjectHashMap<PotionEffect[]> potionEffects;
    protected BitSet field_77852_bZ;
    public boolean displayEffectsTooltip;

    public ItemEdible() {
        super(0, 0.0f, false);
        this.func_77627_a(true);
        this.dynamic = new ItemMetaDynamic();
        this.foodLevels = new TIntIntHashMap();
        this.saturations = new TIntFloatHashMap();
        this.potionEffects = new TIntObjectHashMap();
        this.field_77852_bZ = new BitSet();
        this.displayEffectsTooltip = true;
    }

    public ItemStack addFood(int meta, int food, float saturation, String name, PotionEffect ... effects) {
        return this.addFood(meta, food, saturation, name, effects.length > 0, effects);
    }

    public ItemStack addFood(int meta, int food, float saturation, String name, boolean alwaysEdible, PotionEffect ... effects) {
        this.dynamic.addMeta(meta, name);
        this.foodLevels.put(meta, food);
        this.saturations.put(meta, saturation);
        this.potionEffects.put(meta, (Object)effects);
        this.field_77852_bZ.set(meta, alwaysEdible);
        return new ItemStack((Item)this, 1, meta);
    }

    public float func_150906_h(ItemStack stack) {
        return this.saturations.get(stack.func_77960_j());
    }

    public int func_150905_g(ItemStack stack) {
        return this.foodLevels.get(stack.func_77960_j());
    }

    protected void func_77849_c(ItemStack stack, World worldIn, @Nonnull EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            for (PotionEffect potion : (PotionEffect[])this.potionEffects.get(stack.func_77960_j())) {
                player.func_70690_d(new PotionEffect(potion.func_188419_a(), potion.func_76459_b(), potion.func_76458_c(), potion.func_82720_e(), potion.func_188418_e()));
            }
        }
    }

    @Nonnull
    public Item func_77655_b(@Nonnull String unlocalizedName) {
        this.dynamic.func_77655_b(unlocalizedName);
        return super.func_77655_b(unlocalizedName);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.dynamic.func_77667_c(stack);
    }

    public int getMetadata(ItemStack stack) {
        return this.dynamic.getMetadata(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.dynamic.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.displayEffectsTooltip) {
            for (PotionEffect potionEffect : (PotionEffect[])this.potionEffects.get(stack.func_77960_j())) {
                tooltip.add(I18n.func_74838_a((String)potionEffect.func_76453_d()).trim());
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i <= this.dynamic.availabilityMask.length; ++i) {
                if (!this.dynamic.isValid(i)) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        this.dynamic.registerItemModels((Item)this);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        int meta = itemStackIn.func_77960_j();
        if (this.dynamic.isValid(meta) && playerIn.func_71043_e(this.field_77852_bZ.get(itemStackIn.func_77960_j()))) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }
}

