/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellRuntimeException;

public final class SpellContext {
    public static final double MAX_DISTANCE = 32.0;
    public EntityPlayer caster;
    public Entity focalPoint;
    public CompiledSpell cspell;
    public int loopcastIndex = 0;
    public ItemStack tool = ItemStack.field_190927_a;
    public RayTraceResult positionBroken;
    public EntityLivingBase attackedEntity;
    public EntityLivingBase attackingEntity;
    public double damageTaken;
    public int targetSlot = 1;
    public boolean shiftTargetSlot = true;
    public Map<String, Object> customData = new HashMap<String, Object>();
    public Object[][] evaluatedObjects = new Object[9][9];
    public Stack<CompiledSpell.Action> actions = null;
    public boolean stopped = false;
    public int delay = 0;

    public SpellContext setPlayer(EntityPlayer player) {
        this.caster = player;
        return this.setFocalPoint((Entity)player);
    }

    public SpellContext setFocalPoint(Entity e) {
        this.focalPoint = e;
        return this;
    }

    public SpellContext setCompiledSpell(CompiledSpell spell) {
        this.cspell = spell;
        return this;
    }

    public SpellContext setSpell(Spell spell) {
        this.setCompiledSpell(PsiAPI.internalHandler.getSpellCache().getCompiledSpell(spell));
        return this;
    }

    public SpellContext setLoopcastIndex(int i) {
        this.loopcastIndex = i;
        return this;
    }

    public boolean isValid() {
        return this.cspell != null;
    }

    public boolean shouldSuppressErrors() {
        return this.isValid() && this.cspell.metadata.errorsSuppressed;
    }

    public boolean isInRadius(Vector3 vec) {
        return this.isInRadius(vec.x, vec.y, vec.z);
    }

    public boolean isInRadius(Entity e) {
        if (e == null) {
            return false;
        }
        if (e == this.focalPoint || e == this.caster) {
            return true;
        }
        return this.isInRadius(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public boolean isInRadius(double x, double y, double z) {
        return MathHelper.pointDistanceSpace(x, y, z, this.focalPoint.field_70165_t, this.focalPoint.field_70163_u, this.focalPoint.field_70161_v) <= 32.0;
    }

    public void verifyEntity(Entity e) throws SpellRuntimeException {
        if (e == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        if (ISpellImmune.isImmune(e)) {
            throw new SpellRuntimeException("psi.spellerror.immunetarget");
        }
    }

    public int getTargetSlot() throws SpellRuntimeException {
        int slot = 0;
        if (this.shiftTargetSlot) {
            int cadSlot = PsiAPI.getPlayerCADSlot(this.caster);
            if (cadSlot == -1) {
                throw new SpellRuntimeException("psi.spellerror.nocad");
            }
            slot = (cadSlot + this.targetSlot) % 9;
        } else {
            slot = (this.targetSlot - 1) % 9;
        }
        if (slot < 0) {
            slot = 10 + slot;
        }
        return slot;
    }
}

