/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.neutral;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import nex.init.NetherExLootTables;
import nex.init.NetherExSoundEvents;

public class EntitySalamander
extends EntityMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntitySalamander.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySalamander(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(0.95f, 0.45f);
        this.setRandomType();
    }

    protected SoundEvent func_184639_G() {
        return NetherExSoundEvents.SALAMANDER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.SALAMANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.SALAMANDER_DEATH;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getType() == 1 && entity instanceof EntityLivingBase) {
            entity.func_70015_d(8);
        }
        return super.func_70652_k(entity);
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String entityName = EntityList.func_75621_b((Entity)this);
        String type = this.getType() == 0 ? "orange" : "black";
        return I18n.func_74838_a((String)("entity." + entityName + "." + type + ".name"));
    }

    protected ResourceLocation func_184647_J() {
        return this.getType() == 0 ? NetherExLootTables.ORANGE_SALAMANDER : NetherExLootTables.BLACK_SALAMANDER;
    }

    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    private void setRandomType() {
        WeightedRandom.Item orange = new WeightedRandom.Item(10);
        WeightedRandom.Item black = new WeightedRandom.Item(1);
        WeightedRandom.Item item = WeightedRandom.func_76271_a((Random)this.field_70146_Z, (List)Lists.newArrayList((Object[])new WeightedRandom.Item[]{orange, black}));
        this.setType(item == orange ? 0 : 1);
    }

    public void setType(int id) {
        if (id < 0) {
            id = 0;
        } else if (id > 1) {
            id = 1;
        }
        this.field_70180_af.func_187227_b(TYPE, (Object)id);
    }
}

