/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import java.util.ListIterator;
import java.util.Random;
import lex.util.ArmorHelper;
import lex.util.CollectionHelper;
import lex.util.EntityHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nex.entity.item.EntityObsidianBoat;
import nex.entity.monster.EntityGhastling;
import nex.entity.monster.EntitySpore;
import nex.entity.passive.EntityPigtificate;
import nex.handler.ConfigHandler;
import nex.init.NetherExBiomes;
import nex.init.NetherExEffects;
import nex.init.NetherExItems;
import nex.init.NetherExMaterials;

@Mod.EventBusSubscriber(modid="nex")
public class LivingHandler {
    @SubscribeEvent
    public static void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        World world = event.getWorld();
        BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
        EntityLivingBase entity = event.getEntityLiving();
        if (world.func_180494_b(pos) == NetherExBiomes.ARCTIC_ABYSS && LivingHandler.canFreeze(entity)) {
            entity.func_70690_d(new PotionEffect((Potion)NetherExEffects.FREEZE, 300, 0));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPigZombie zombiePigman;
        NBTTagCompound entityData;
        boolean canEntityFreeze;
        World world = event.getEntityLiving().func_130014_f_();
        BlockPos pos = new BlockPos((Entity)event.getEntityLiving());
        EntityLivingBase entity = event.getEntityLiving();
        Random rand = world.field_73012_v;
        boolean bl = canEntityFreeze = entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_() && ConfigHandler.biomeConfig.arcticAbyss.canPlayersFreeze || LivingHandler.canFreeze(entity);
        if (canEntityFreeze) {
            boolean entityFrozen = LivingHandler.isFrozen(entity);
            if (!entityFrozen && world.field_73012_v.nextInt(ConfigHandler.biomeConfig.arcticAbyss.mobFreezeRarity) == 0 && world.func_180494_b(pos) == NetherExBiomes.ARCTIC_ABYSS) {
                entity.func_70690_d(new PotionEffect((Potion)NetherExEffects.FREEZE, 300, 0));
            }
            if (entityFrozen) {
                if (entity instanceof EntityPlayer) {
                    entity.func_70107_b(entity.field_70169_q, entity.field_70163_u, entity.field_70166_s);
                }
                if (world.field_73012_v.nextInt(ConfigHandler.potionEffectConfig.freeze.thawRarity) == 0) {
                    entity.func_184589_d((Potion)NetherExEffects.FREEZE);
                }
            }
        }
        if (LivingHandler.isSporeInfested(entity) && LivingHandler.canSpreadSpores(entity) && world.field_73012_v.nextInt(ConfigHandler.potionEffectConfig.spore.sporeSpawnRarity) == 0 && world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72321_a(1.0, 1.0, 1.0)).size() < 3) {
            BlockPos newPos = pos.func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(world.field_73012_v));
            if (!world.field_72995_K && world.func_175623_d(newPos) && world.func_180495_p(newPos.func_177977_b()).isSideSolid((IBlockAccess)world, newPos.func_177977_b(), EnumFacing.UP)) {
                EntitySpore spore = new EntitySpore(world, 0);
                spore.func_70107_b(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                world.func_72838_d((Entity)spore);
            }
        }
        if (LivingHandler.isLostAfflicted(entity) && LivingHandler.canSpawnGhastling(entity) && world.field_73012_v.nextInt(ConfigHandler.potionEffectConfig.lost.ghastlingSpawnRarity) == 0) {
            BlockPos newPos = pos.func_177982_a(0, 5, 0).func_177967_a(entity.func_174811_aO().func_176734_d(), 5);
            if (!world.field_72995_K && world.func_175623_d(newPos)) {
                EntityGhastling ghastling = new EntityGhastling(world);
                ghastling.func_70107_b(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                ghastling.func_70624_b(entity);
                world.func_72838_d((Entity)ghastling);
            }
        }
        if (entity instanceof EntityPigZombie && (entityData = (zombiePigman = (EntityPigZombie)entity).getEntityData()).func_74764_b("ConversionTime")) {
            int conversionTime = entityData.func_74762_e("ConversionTime");
            int conversionProgress = 1;
            if (rand.nextFloat() < 0.01f) {
                int conversionBoosters = 0;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = (int)zombiePigman.field_70165_t - 4; x < (int)zombiePigman.field_70165_t + 4 && conversionBoosters < 14; ++x) {
                    for (int y = (int)zombiePigman.field_70163_u - 4; y < (int)zombiePigman.field_70163_u + 4 && conversionBoosters < 14; ++y) {
                        for (int z = (int)zombiePigman.field_70161_v - 4; z < (int)zombiePigman.field_70161_v + 4 && conversionBoosters < 14; ++z) {
                            Block block = world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(x, y, z)).func_177230_c();
                            if (block != Blocks.field_150411_aY) continue;
                            if (rand.nextFloat() < 0.3f) {
                                ++conversionProgress;
                            }
                            ++conversionBoosters;
                        }
                    }
                }
            }
            if ((conversionTime -= conversionProgress) <= 0) {
                EntityPigtificate pigtificate = new EntityPigtificate(world);
                pigtificate.func_82149_j((Entity)zombiePigman);
                pigtificate.setLookingForHome();
                if (zombiePigman.func_70631_g_()) {
                    pigtificate.func_70873_a(-24000);
                }
                world.func_72900_e((Entity)zombiePigman);
                pigtificate.func_94061_f(zombiePigman.func_175446_cd());
                if (zombiePigman.func_145818_k_()) {
                    pigtificate.func_96094_a(zombiePigman.func_95999_t());
                    pigtificate.func_174805_g(zombiePigman.func_174833_aM());
                }
                world.func_72838_d((Entity)pigtificate);
                pigtificate.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                world.func_180498_a(null, 1027, new BlockPos((int)zombiePigman.field_70165_t, (int)zombiePigman.field_70163_u, (int)zombiePigman.field_70161_v), 0);
            } else {
                entityData.func_74768_a("ConversionTime", conversionTime);
            }
        }
    }

    @SubscribeEvent
    public static void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase attacker = (EntityLivingBase)event.getEntity();
        EntityLivingBase attackee = event.getTarget();
        if (attackee instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attackee;
            if (attacker instanceof AbstractSkeleton && ArmorHelper.isWearingFullArmorSet((EntityPlayer)player, (ItemArmor.ArmorMaterial)NetherExMaterials.WITHER_BONE)) {
                ((AbstractSkeleton)attacker).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        DamageSource source = event.getSource();
        if (source.func_76347_k() && !entity.func_70045_F() && entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityObsidianBoat) {
            event.setCanceled(true);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (source.func_76347_k() && ArmorHelper.isWearingFullArmorSet((EntityPlayer)player, (ItemArmor.ArmorMaterial)NetherExMaterials.SALAMANDER_HIDE)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_70644_a(MobEffects.field_76428_l) && !player.func_70644_a(MobEffects.field_76444_x) && player.func_70644_a((Potion)NetherExEffects.FROSTBITE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Random rand = new Random();
        BlockPos deathPoint = event.getEntity().func_180425_c();
        if (event.getEntity() instanceof EntityGhast) {
            if (ConfigHandler.entityConfig.ghast.meatDropRarity > 0 && rand.nextInt(ConfigHandler.entityConfig.ghast.meatDropRarity) == 0) {
                event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), (double)deathPoint.func_177958_n(), (double)deathPoint.func_177956_o(), (double)deathPoint.func_177952_p(), new ItemStack((Item)NetherExItems.GHAST_MEAT_RAW, rand.nextInt(3) + 1, 0)));
            }
        } else if (event.getEntity() instanceof EntityWitherSkeleton && ConfigHandler.entityConfig.witherSkeleton.boneDropRarity > 0 && rand.nextInt(ConfigHandler.entityConfig.witherSkeleton.boneDropRarity) == 0) {
            ListIterator iter = event.getDrops().listIterator();
            while (iter.hasNext()) {
                EntityItem entityItem = (EntityItem)iter.next();
                ItemStack stack = entityItem.func_92059_d();
                if (stack.func_77973_b() != Items.field_151103_aS && stack.func_77973_b() != Items.field_151044_h) continue;
                iter.remove();
            }
            event.getDrops().add(new EntityItem(event.getEntity().field_70170_p, (double)deathPoint.func_177958_n(), (double)deathPoint.func_177956_o(), (double)deathPoint.func_177952_p(), new ItemStack((Item)NetherExItems.WITHER_BONE, rand.nextInt(3), 0)));
        }
    }

    public static boolean canFreeze(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        String entityRegistryName = EntityHelper.getEntityLocation((EntityLivingBase)entity);
        return entityRegistryName != null && !CollectionHelper.contains((String[])ConfigHandler.potionEffectConfig.freeze.mobBlacklist, (String)entityRegistryName);
    }

    public static boolean canSpreadSpores(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        String entityRegistryName = EntityHelper.getEntityLocation((EntityLivingBase)entity);
        return entityRegistryName != null && !CollectionHelper.contains((String[])ConfigHandler.potionEffectConfig.spore.mobBlacklist, (String)entityRegistryName);
    }

    public static boolean canSpawnGhastling(EntityLivingBase entity) {
        return entity instanceof EntityPlayer && entity.func_130014_f_().field_73011_w.func_186058_p() == DimensionType.NETHER;
    }

    public static boolean isFrozen(EntityLivingBase entity) {
        return entity.func_70644_a((Potion)NetherExEffects.FREEZE);
    }

    public static boolean isSporeInfested(EntityLivingBase entity) {
        return entity.func_70644_a((Potion)NetherExEffects.SPORE);
    }

    public static boolean isLostAfflicted(EntityLivingBase entity) {
        return entity.func_70644_a((Potion)NetherExEffects.LOST);
    }
}

