/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nex.NetherEx;

@Mod.EventBusSubscriber(modid="nex")
public class RemapHandler {
    private static final Map<String, String> MAPPINGS_TO_REPLACE = ImmutableMap.builder().put((Object)"nex:block_basalt", (Object)"nex:basalt").put((Object)"nex:block_netherrack", (Object)"nex:netherrack").put((Object)"nex:block_brick_nether", (Object)"nex:nether_brick").put((Object)"nex:block_netherrack_path", (Object)"nex:netherrack_path").put((Object)"nex:block_hyphae", (Object)"nex:hyphae").put((Object)"nex:block_sand_soul_tilled", (Object)"nex:tilled_soul_sand").put((Object)"nex:block_glass_soul", (Object)"nex:soul_glass").put((Object)"nex:block_glass_pane_soul", (Object)"nex:soul_glass_pane").put((Object)"nex:block_amethyst", (Object)"nex:amethyst_block").put((Object)"nex:block_rime", (Object)"nex:rime_block").put((Object)"nex:block_ice_frostburn", (Object)"nex:frostburn_ice").put((Object)"nex:block_bone_sliver", (Object)"nex:bone_sliver").put((Object)"nex:block_bone_chunk", (Object)"nex:bone_chunk").put((Object)"nex:block_iron_worn", (Object)"nex:worn_iron").put((Object)"nex:block_fire_blue", (Object)"nex:blue_fire").put((Object)"nex:block_portal_nether", (Object)"nex:nether_portal").put((Object)"nex:tile_urn_sorrow", (Object)"nex:urn_of_sorrow").put((Object)"nex:ore_quartz", (Object)"nex:quartz_ore").put((Object)"nex:ore_amethyst", (Object)"nex:amethyst_ore").put((Object)"nex:ore_rime", (Object)"nex:rime_ore").put((Object)"nex:plant_thornstalk", (Object)"nex:thornstalk").put((Object)"nex:plant_mushroom_elder", (Object)"nex:elder_mushroom").put((Object)"nex:plant_mushroom_elder_cap", (Object)"nex:elder_mushroom_cap").put((Object)"nex:plant_mushroom_elder_stem", (Object)"nex:elder_mushroom_stem").put((Object)"nex:plant_mushroom_enoki_stem", (Object)"nex:enoki_mushroom_stem").put((Object)"nex:plant_mushroom_enoki_cap", (Object)"nex:enoki_mushroom_cap").put((Object)"nex:fluid_ichor", (Object)"nex:ichor").put((Object)"nex:slab_vanilla", (Object)"nex:vanilla_slab").put((Object)"nex:slab_basalt", (Object)"nex:basalt_slab").put((Object)"nex:slab_brick_nether", (Object)"nex:nether_brick_slab").put((Object)"nex:slab_vanilla_double", (Object)"nex:vanilla_slab_double").put((Object)"nex:slab_basalt_double", (Object)"nex:basalt_slab_double").put((Object)"nex:slab_brick_nether_double", (Object)"nex:nether_brick_slab_double").put((Object)"nex:stairs_brick_nether_red", (Object)"nex:red_nether_brick_stairs").put((Object)"nex:stairs_basalt_normal", (Object)"nex:basalt_stairs").put((Object)"nex:stairs_basalt_smooth", (Object)"nex:basalt_smooth_stairs").put((Object)"nex:stairs_basalt_brick", (Object)"nex:basalt_brick_stairs").put((Object)"nex:stairs_basalt_pillar", (Object)"nex:basalt_pillar_stairs").put((Object)"nex:stairs_brick_nether_fiery", (Object)"nex:fiery_nether_brick_stairs").put((Object)"nex:stairs_brick_nether_icy", (Object)"nex:icy_nether_brick_stairs").put((Object)"nex:stairs_brick_nether_lively", (Object)"nex:lively_nether_brick_stairs").put((Object)"nex:stairs_brick_nether_gloomy", (Object)"nex:gloomy_nether_brick_stairs").put((Object)"nex:wall_vanilla", (Object)"nex:vanilla_wall").put((Object)"nex:wall_basalt", (Object)"nex:basalt_wall").put((Object)"nex:wall_brick_nether", (Object)"nex:nether_brick_wall").put((Object)"nex:fence_vanilla", (Object)"nex:vanilla_fence").put((Object)"nex:fence_basalt", (Object)"nex:basalt_fence").put((Object)"nex:fence_brick_nether", (Object)"nex:nether_brick_fence").put((Object)"nex:fence_gate_quartz", (Object)"nex:quartz_fence_gate").put((Object)"nex:fence_gate_brick_nether", (Object)"nex:nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_red", (Object)"nex:red_nether_brick_fence_gate").put((Object)"nex:fence_gate_basalt_normal", (Object)"nex:basalt_fence_gate").put((Object)"nex:fence_gate_basalt_smooth", (Object)"nex:basalt_smooth_fence_gate").put((Object)"nex:fence_gate_basalt_brick", (Object)"nex:basalt_brick_fence_gate").put((Object)"nex:fence_gate_basalt_pillar", (Object)"nex:basalt_pillar_fence_gate").put((Object)"nex:fence_gate_brick_nether_fiery", (Object)"nex:fiery_nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_icy", (Object)"nex:icy_nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_lively", (Object)"nex:lively_nether_brick_fence_gate").put((Object)"nex:fence_gate_brick_nether_gloomy", (Object)"nex:gloomy_nether_brick_fence_gate").put((Object)"nex:item_brick_nether", (Object)"nex:netherbrick").put((Object)"nex:item_bone_wither", (Object)"nex:wither_bone").put((Object)"nex:item_dust_wither", (Object)"nex:wither_dust").put((Object)"nex:item_hide_salamander", (Object)"nex:salamander_hide").put((Object)"nex:item_crystal_amethyst", (Object)"nex:amethyst_crystal").put((Object)"nex:item_crystal_rime", (Object)"nex:rime_crystal").put((Object)"nex:item_crystal_rime_steel", (Object)"nex:rime_and_steel").put((Object)"nex:item_spore", (Object)"nex:spore").put((Object)"nex:item_fang_spider_bone", (Object)"nex:bone_spider_fang").put((Object)"nex:item_tear_ghast_queen", (Object)"nex:ghast_queen_tear").put((Object)"nex:item_boat_obsidian", (Object)"nex:obsidian_boat").put((Object)"nex:food_meat_ghast_raw", (Object)"nex:ghast_meat_raw").put((Object)"nex:food_meat_ghast_cooked", (Object)"nex:ghast_meat_cooked").put((Object)"nex:food_congealed_magma_cream", (Object)"nex:congealed_magma_cream").put((Object)"nex:food_mushroom_enoki", (Object)"nex:enoki_mushroom").put((Object)"nex:tool_sword_bone", (Object)"nex:golden_wither_bone_sword").put((Object)"nex:tool_pickaxe_bone", (Object)"nex:golden_wither_bone_pickaxe").put((Object)"nex:tool_shovel_bone", (Object)"nex:golden_wither_bone_shovel").put((Object)"nex:tool_axe_bone", (Object)"nex:golden_wither_bone_axe").put((Object)"nex:tool_hoe_bone", (Object)"nex:golden_wither_bone_hoe").put((Object)"nex:tool_hammer_bone", (Object)"nex:golden_wither_bone_hammer").put((Object)"nex:armor_helmet_bone", (Object)"nex:wither_bone_helmet").put((Object)"nex:armor_chestplate_bone", (Object)"nex:wither_bone_chestplate").put((Object)"nex:armor_leggings_bone", (Object)"nex:wither_bone_leggings").put((Object)"nex:armor_boots_bone", (Object)"nex:wither_bone_boots").put((Object)"nex:armor_helmet_hide_salamander", (Object)"nex:salamander_hide_helmet").put((Object)"nex:armor_chestplate_hide_salamander", (Object)"nex:salamander_hide_chestplate").put((Object)"nex:armor_leggings_hide_salamander", (Object)"nex:salamander_hide_leggings").put((Object)"nex:armor_boots_hide_salamander", (Object)"nex:salamander_hide_boots").put((Object)"nex:hell", (Object)"minecraft:hell").put((Object)"nex:projectile_ghast_queen_fireball", (Object)"nex:ghast_queen_fireball").put((Object)"nex:projectile_ghastling_fireball", (Object)"nex:ghastling_fireball").put((Object)"nex:passive_pigtificate_leader", (Object)"nex:pigtificate_leader").put((Object)"nex:passive_pigtificate", (Object)"nex:pigtificate").put((Object)"nex:neutral_gold_golem", (Object)"nex:gold_golem").put((Object)"nex:neutral_mogus", (Object)"nex:mogus").put((Object)"nex:neutral_salamander", (Object)"nex:salamander").put((Object)"nex:monster_wight", (Object)"nex:wight").put((Object)"nex:monster_ember", (Object)"nex:ember").put((Object)"nex:monster_nethermite", (Object)"nex:nethermite").put((Object)"nex:monster_spinout", (Object)"nex:spinout").put((Object)"nex:monster_spore_creeper", (Object)"nex:spore_creeper").put((Object)"nex:monster_spore", (Object)"nex:spore").put((Object)"nex:monster_ghastling", (Object)"nex:ghastling").put((Object)"nex:monster_bone_spider", (Object)"nex:bone_spider").put((Object)"nex:monster_brute", (Object)"nex:brute").put((Object)"nex:boss_ghast_queen", (Object)"nex:ghast_queen").put((Object)"nex:ambient_pigtificate", (Object)"nex:pigtificate_ambient").put((Object)"nex:hurt_pigtificate", (Object)"nex:pigtificate_hurt").put((Object)"nex:death_pigtificate", (Object)"nex:pigtificate_death").put((Object)"nex:ambient_mogus", (Object)"nex:mogus_ambient").put((Object)"nex:hurt_mogus", (Object)"nex:mogus_hurt").put((Object)"nex:death_mogus", (Object)"nex:mogus_death").put((Object)"nex:ambient_salamander", (Object)"nex:salamander_ambient").put((Object)"nex:hurt_salamander", (Object)"nex:salamander_hurt").put((Object)"nex:death_salamander", (Object)"nex:salamander_death").put((Object)"nex:ambient_wight", (Object)"nex:wight_ambient").put((Object)"nex:hurt_wight", (Object)"nex:wight_hurt").put((Object)"nex:death_wight", (Object)"nex:wight_death").put((Object)"nex:hurt_ember", (Object)"nex:ember_hurt").put((Object)"nex:death_ember", (Object)"nex:ember_death").put((Object)"nex:ambient_nethermite", (Object)"nex:nethermite_ambient").put((Object)"nex:hurt_nethermite", (Object)"nex:nethermite_hurt").put((Object)"nex:death_nethermite", (Object)"nex:nethermite_death").put((Object)"nex:ambient_spinout", (Object)"nex:spinout_ambient").put((Object)"nex:hurt_spinout", (Object)"nex:spinout_hurt").put((Object)"nex:death_spinout", (Object)"nex:spinout_death").put((Object)"nex:hurt_spore", (Object)"nex:spore_hurt").put((Object)"nex:death_spore", (Object)"nex:spore_death").put((Object)"nex:warn_spore", (Object)"nex:spore_warn").put((Object)"nex:explode_spore", (Object)"nex:spore_explode").put((Object)"nex:ambient_ghastling", (Object)"nex:ghastling_ambient").put((Object)"nex:hurt_ghastling", (Object)"nex:ghastling_hurt").put((Object)"nex:death_ghastling", (Object)"nex:ghastling_death").put((Object)"nex:warn_ghastling", (Object)"nex:ghastling_warn").put((Object)"nex:shoot_ghastling", (Object)"nex:ghastling_shoot").put((Object)"nex:ambient_ghast_queen", (Object)"nex:ghast_queen_ambient").put((Object)"nex:hurt_ghast_queen", (Object)"nex:ghast_queen_hurt").put((Object)"nex:death_ghast_queen", (Object)"nex:ghast_queen_death").put((Object)"nex:shoot_ghast_queen", (Object)"nex:ghast_queen_shoot").put((Object)"nex:summon_ghast_queen", (Object)"nex:ghast_queen_summon").build();

    private static void remapEntries(RegistryEvent.MissingMappings.Mapping missingMapping, IForgeRegistry registry) {
        String oldMapping = missingMapping.key.toString();
        if (MAPPINGS_TO_REPLACE.containsKey(oldMapping)) {
            String newMapping = MAPPINGS_TO_REPLACE.get(oldMapping);
            ResourceLocation replacementMapping = new ResourceLocation(newMapping);
            IForgeRegistryEntry entry = registry.getValue(replacementMapping);
            if (registry.containsKey(replacementMapping) && entry != null) {
                missingMapping.remap(entry);
                NetherEx.LOGGER.info("Remapped {} {} to {}.", (Object)registry.getRegistrySuperType().getSimpleName(), (Object)missingMapping.key, (Object)replacementMapping);
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.BLOCKS);
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.ITEMS);
        }
    }

    @SubscribeEvent
    public static void onMissingBiomeMappings(RegistryEvent.MissingMappings<Biome> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.BIOMES);
        }
    }

    @SubscribeEvent
    public static void onMissingEntityMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.ENTITIES);
        }
    }

    @SubscribeEvent
    public static void onMissingSoundEventMappings(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            RemapHandler.remapEntries(mapping, ForgeRegistries.SOUND_EVENTS);
        }
    }
}

