/*
 * Decompiled with CFR 0.152.
 */
package nex.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import nex.block.BlockNetherPortal;
import nex.init.NetherExBlocks;

public class TeleporterNetherEx
extends Teleporter {
    public TeleporterNetherEx(WorldServer world) {
        super(world);
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        if (this.field_85192_a.field_73011_w.func_186058_p().func_186068_a() != DimensionType.THE_END.func_186068_a()) {
            if (!this.func_180620_b(entity, rotationYaw)) {
                this.func_85188_a(entity);
                this.func_180620_b(entity, rotationYaw);
            }
        } else {
            int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t);
            int entityPosY = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
            int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v);
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y < 3; ++y) {
                        int posX = entityPosX + x;
                        int posY = entityPosY + y;
                        int posZ = entityPosZ - z;
                        boolean beneathWorld = y < 0;
                        this.field_85192_a.func_175656_a(new BlockPos(posX, posY, posZ), beneathWorld ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            entity.func_70012_b((double)entityPosX, (double)entityPosY, (double)entityPosZ, entity.field_70177_z, 0.0f);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        double portalDistance = -1.0;
        int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        boolean newPortal = true;
        BlockPos portalPos = BlockPos.field_177992_a;
        long portalChunkPos = ChunkPos.func_77272_a((int)entityPosX, (int)entityPosZ);
        if (this.field_85191_c.containsKey(portalChunkPos)) {
            Teleporter.PortalPosition portalPosition = (Teleporter.PortalPosition)this.field_85191_c.get(portalChunkPos);
            portalDistance = 0.0;
            portalPos = portalPosition;
            portalPosition.field_85087_d = this.field_85192_a.func_82737_E();
            newPortal = false;
        } else {
            BlockPos entityPos = new BlockPos(entity);
            for (int x = -128; x <= 128; ++x) {
                for (int z = -128; z <= 128; ++z) {
                    BlockPos checkPos = entityPos.func_177982_a(x, this.field_85192_a.func_72940_L() - 1 - entityPos.func_177956_o(), z);
                    while (checkPos.func_177956_o() >= 0) {
                        BlockPos newPos = checkPos.func_177977_b();
                        if (this.field_85192_a.func_180495_p(checkPos).func_177230_c() == NetherExBlocks.NETHER_PORTAL) {
                            newPos = checkPos.func_177977_b();
                            while (this.field_85192_a.func_180495_p(newPos).func_177230_c() == NetherExBlocks.NETHER_PORTAL) {
                                checkPos = newPos;
                                newPos = newPos.func_177977_b();
                            }
                            double distanceSqBetweenPosAndEntity = checkPos.func_177951_i((Vec3i)entityPos);
                            if (portalDistance < 0.0 || distanceSqBetweenPosAndEntity < portalDistance) {
                                portalDistance = distanceSqBetweenPosAndEntity;
                                portalPos = checkPos;
                            }
                        }
                        checkPos = newPos;
                    }
                }
            }
        }
        if (portalDistance >= 0.0) {
            if (newPortal) {
                this.field_85191_c.put(portalChunkPos, (Object)new Teleporter.PortalPosition((Teleporter)this, portalPos, this.field_85192_a.func_82737_E()));
            }
            double adjustedPosX = (double)portalPos.func_177958_n() + 0.5;
            double adjustedPosZ = (double)portalPos.func_177952_p() + 0.5;
            BlockPattern.PatternHelper patternHelper = Blocks.field_150427_aO.func_181089_f((World)this.field_85192_a, portalPos);
            boolean facingNegative = patternHelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
            double offset = patternHelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)patternHelper.func_181117_a().func_177952_p() : (double)patternHelper.func_181117_a().func_177958_n();
            double adjustedPosY = (double)(patternHelper.func_181117_a().func_177956_o() + 1) - entity.func_181014_aG().field_72448_b * (double)patternHelper.func_181119_e();
            if (facingNegative) {
                offset += 1.0;
            }
            if (patternHelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
                adjustedPosZ = offset + (1.0 - entity.func_181014_aG().field_72450_a) * (double)patternHelper.func_181118_d() * (double)patternHelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            } else {
                adjustedPosX = offset + (1.0 - entity.func_181014_aG().field_72450_a) * (double)patternHelper.func_181118_d() * (double)patternHelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            }
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (patternHelper.func_177669_b().func_176734_d() == entity.func_181012_aH()) {
                f = 1.0f;
                f1 = 1.0f;
            } else if (patternHelper.func_177669_b().func_176734_d() == entity.func_181012_aH().func_176734_d()) {
                f = -1.0f;
                f1 = -1.0f;
            } else if (patternHelper.func_177669_b().func_176734_d() == entity.func_181012_aH().func_176746_e()) {
                f2 = 1.0f;
                f3 = -1.0f;
            } else {
                f2 = -1.0f;
                f3 = 1.0f;
            }
            double motionX = entity.field_70159_w;
            double motionZ = entity.field_70179_y;
            entity.field_70159_w = motionX * (double)f + motionZ * (double)f3;
            entity.field_70179_y = motionX * (double)f2 + motionZ * (double)f1;
            entity.field_70177_z = rotationYaw - (float)(entity.func_181012_aH().func_176734_d().func_176736_b() * 90) + (float)(patternHelper.func_177669_b().func_176736_b() * 90);
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(adjustedPosX, adjustedPosY, adjustedPosZ, entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70012_b(adjustedPosX, adjustedPosY, adjustedPosZ, entity.field_70177_z, entity.field_70125_A);
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int x;
        int y;
        double adjustedPosZ;
        int z;
        double adjustedPosX;
        int x2;
        double portalDistance = -1.0;
        int entityPosX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityPosY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int entityPosZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int adjustedEntityPosX = entityPosX;
        int adjustedEntityPosY = entityPosY;
        int adjustedEntityPosZ = entityPosZ;
        int offset = 0;
        int randomOffset = this.field_77187_a.nextInt(4);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (x2 = entityPosX - 16; x2 <= entityPosX + 16; ++x2) {
            adjustedPosX = (double)x2 + 0.5 - entity.field_70165_t;
            for (z = entityPosZ - 16; z <= entityPosZ + 16; ++z) {
                adjustedPosZ = (double)z + 0.5 - entity.field_70161_v;
                block2: for (y = this.field_85192_a.func_72940_L() - 1; y >= 0; --y) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y, z))) continue;
                    while (y > 0 && this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y - 1, z))) {
                        --y;
                    }
                    for (int k3 = randomOffset; k3 < randomOffset + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int offsetZ = 0; offsetZ < 3; ++offsetZ) {
                            for (int offsetX = 0; offsetX < 4; ++offsetX) {
                                for (int offsetY = -1; offsetY < 4; ++offsetY) {
                                    int posX = x2 + (offsetX - 1) * l3 + offsetZ * i4;
                                    int posY = y + offsetY;
                                    int posZ = z + (offsetX - 1) * i4 - offsetZ * l3;
                                    mutableBlockPos.func_181079_c(posX, posY, posZ);
                                    if (offsetY < 0 && !this.field_85192_a.func_180495_p((BlockPos)mutableBlockPos).func_185904_a().func_76220_a() || offsetY >= 0 && !this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos)) continue block2;
                                }
                            }
                        }
                        double adjustedPosY = (double)y + 0.5 - entity.field_70163_u;
                        double adjustedPos = adjustedPosX * adjustedPosX + adjustedPosY * adjustedPosY + adjustedPosZ * adjustedPosZ;
                        if (!(portalDistance < 0.0) && !(adjustedPos < portalDistance)) continue;
                        portalDistance = adjustedPos;
                        adjustedEntityPosX = x2;
                        adjustedEntityPosY = y;
                        adjustedEntityPosZ = z;
                        offset = k3 % 4;
                    }
                }
            }
        }
        if (portalDistance < 0.0) {
            for (x2 = entityPosX - 16; x2 <= entityPosX + 16; ++x2) {
                adjustedPosX = (double)x2 + 0.5 - entity.field_70165_t;
                for (z = entityPosZ - 16; z <= entityPosZ + 16; ++z) {
                    adjustedPosZ = (double)z + 0.5 - entity.field_70161_v;
                    block10: for (y = this.field_85192_a.func_72940_L() - 1; y >= 0; --y) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y, z))) continue;
                        while (y > 0 && this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos.func_181079_c(x2, y - 1, z))) {
                            --y;
                        }
                        for (int offsetZ = randomOffset; offsetZ < randomOffset + 2; ++offsetZ) {
                            int j8 = offsetZ % 2;
                            int j9 = 1 - j8;
                            for (int offsetX = 0; offsetX < 4; ++offsetX) {
                                for (int offsetY = -1; offsetY < 4; ++offsetY) {
                                    int posX = x2 + (offsetX - 1) * j8;
                                    int posY = y + offsetY;
                                    int posZ = z + (offsetX - 1) * j9;
                                    mutableBlockPos.func_181079_c(posX, posY, posZ);
                                    if (offsetY < 0 && !this.field_85192_a.func_180495_p((BlockPos)mutableBlockPos).func_185904_a().func_76220_a() || offsetY >= 0 && !this.field_85192_a.func_175623_d((BlockPos)mutableBlockPos)) continue block10;
                                }
                            }
                            double adjustedPosY = (double)y + 0.5 - entity.field_70163_u;
                            double adjustedPos = adjustedPosX * adjustedPosX + adjustedPosY * adjustedPosY + adjustedPosZ * adjustedPosZ;
                            if (!(portalDistance < 0.0) && !(adjustedPos < portalDistance)) continue;
                            portalDistance = adjustedPos;
                            adjustedEntityPosX = x2;
                            adjustedEntityPosY = y;
                            adjustedEntityPosZ = z;
                            offset = offsetZ % 2;
                        }
                    }
                }
            }
        }
        int i6 = adjustedEntityPosX;
        int k2 = adjustedEntityPosY;
        int k6 = adjustedEntityPosZ;
        int l6 = offset % 2;
        int i3 = 1 - l6;
        if (offset % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (portalDistance < 0.0) {
            k2 = adjustedEntityPosY = MathHelper.func_76125_a((int)adjustedEntityPosY, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
            for (int z2 = -1; z2 <= 1; ++z2) {
                for (x = 1; x < 3; ++x) {
                    for (int y2 = -1; y2 < 3; ++y2) {
                        int posX = i6 + (x - 1) * l6 + z2 * i3;
                        int posY = k2 + y2;
                        int posZ = k6 + (x - 1) * i3 - z2 * l6;
                        boolean beneathWorld = y2 < 0;
                        this.field_85192_a.func_175656_a(new BlockPos(posX, posY, posZ), beneathWorld ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        IBlockState iblockstate = NetherExBlocks.NETHER_PORTAL.func_176223_P().func_177226_a(BlockNetherPortal.AXIS, (Comparable)(l6 == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
        for (x = 0; x < 4; ++x) {
            int posZ;
            int posY;
            int posX;
            int y3;
            for (int z3 = 0; z3 < 4; ++z3) {
                for (y3 = -1; y3 < 4; ++y3) {
                    posX = i6 + (z3 - 1) * l6;
                    posY = k2 + y3;
                    posZ = k6 + (z3 - 1) * i3;
                    boolean beneathWorld = z3 == 0 || z3 == 3 || y3 == -1 || y3 == 3;
                    this.field_85192_a.func_180501_a(new BlockPos(posX, posY, posZ), beneathWorld ? Blocks.field_150343_Z.func_176223_P() : iblockstate, 2);
                }
            }
            for (int zx = 0; zx < 4; ++zx) {
                for (y3 = -1; y3 < 4; ++y3) {
                    posX = i6 + (zx - 1) * l6;
                    posY = k2 + y3;
                    posZ = k6 + (zx - 1) * i3;
                    BlockPos blockpos = new BlockPos(posX, posY, posZ);
                    this.field_85192_a.func_175685_c(blockpos, this.field_85192_a.func_180495_p(blockpos).func_177230_c(), false);
                }
            }
        }
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            this.field_85191_c.values().removeIf(portalPosition -> portalPosition == null || portalPosition.field_85087_d < worldTime - 300L);
        }
    }

    public static TeleporterNetherEx getTeleporterForWorld(MinecraftServer minecraftServer, int dimension) {
        WorldServer worldServer = minecraftServer.func_71218_a(dimension);
        for (Teleporter teleporter : worldServer.customTeleporters) {
            if (!(teleporter instanceof TeleporterNetherEx)) continue;
            return (TeleporterNetherEx)teleporter;
        }
        TeleporterNetherEx teleporterNetherEx = new TeleporterNetherEx(worldServer);
        worldServer.customTeleporters.add(teleporterNetherEx);
        return teleporterNetherEx;
    }
}

