/*
 * Decompiled with CFR 0.152.
 */
package nex.world.biome;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lex.LibEx;
import lex.config.Config;
import lex.util.FileHelper;
import lex.world.biome.BiomeWrapper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.Loader;
import nex.NetherEx;
import nex.handler.ConfigHandler;
import nex.world.biome.BiomeWrapperNetherEx;

public class NetherExBiomeManager {
    private static final List<BiomeManager.BiomeEntry> BIOMES = new ArrayList<BiomeManager.BiomeEntry>();
    private static final Map<Biome, BiomeWrapper> BIOME_WRAPPERS = new HashMap<Biome, BiomeWrapper>();
    private static final Map<Biome, Config> BIOME_CONFIGS = new HashMap<Biome, Config>();

    public static void preInit() {
        FileHelper.copyDirectoryToDirectory((URL)NetherEx.class.getResource("/assets/nex/biome_configs"), (File)new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Biomes"));
    }

    public static void setupDefaultBiomes() {
        NetherEx.LOGGER.info("Setting up default biomes.");
        NetherExBiomeManager.parseBiomeConfigs(new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Biomes/minecraft"));
        NetherExBiomeManager.parseBiomeConfigs(new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Biomes/nex"));
    }

    public static void setupCompatibleBiomes(MinecraftServer server) {
        WorldType worldType;
        World world = server.func_130014_f_();
        if (Loader.isModLoaded((String)"biomesoplenty") && ConfigHandler.compatibilityConfig.biomesOPlenty.enableCompat && ((worldType = world.func_175624_G()).func_77127_a().equalsIgnoreCase("BIOMESOP") || worldType.func_77127_a().equalsIgnoreCase("lostcities_bop"))) {
            NetherEx.LOGGER.info("Setting up Biomes O' Plenty biomes.");
            NetherExBiomeManager.parseBiomeConfigs(new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Biomes/biomesoplenty"));
        }
    }

    public static void setupCustomBiomes() {
        NetherEx.LOGGER.info("Setting up custom biomes.");
        NetherExBiomeManager.parseBiomeConfigs(new File(LibEx.CONFIG_DIRECTORY, "NetherEx/Biomes/custom"));
    }

    private static void parseBiomeConfigs(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try {
            Iterator pathIter = Files.walk(directory.toPath(), new FileVisitOption[0]).iterator();
            while (pathIter.hasNext()) {
                Path configPath = (Path)pathIter.next();
                File configFile = configPath.toFile();
                if (FileHelper.getFileExtension((File)configFile).equals("json")) {
                    NetherExBiomeManager.wrapBiome(new Config(configFile, true), configFile);
                    continue;
                }
                if (configFile.isDirectory()) continue;
                NetherEx.LOGGER.warn("Skipping file located at, {}, as it is not a json file.", (Object)configPath.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void wrapBiome(Config config, File configFile) {
        BiomeWrapperNetherEx wrapper = new BiomeWrapperNetherEx(config);
        Biome biome = wrapper.getBiome();
        if (biome != null && wrapper.isEnabled()) {
            BIOMES.add(new BiomeManager.BiomeEntry(biome, config.getInt("weight", 10)));
            BIOME_WRAPPERS.put(biome, wrapper);
            BIOME_CONFIGS.put(biome, config);
            config.save(configFile);
        }
    }

    public static void resetBiomes() {
        BIOMES.clear();
        BIOME_WRAPPERS.clear();
        BIOME_CONFIGS.clear();
    }

    public static List<BiomeManager.BiomeEntry> getBiomes() {
        return ImmutableList.copyOf(BIOMES);
    }

    public static BiomeWrapper getBiomeWrapper(Biome key) {
        return BIOME_WRAPPERS.get(key);
    }

    public static Config getBiomeConfig(Biome key) {
        return BIOME_CONFIGS.get(key);
    }
}

