/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntity;
import mcjty.rftools.items.builder.GuiShapeCard;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiBuilder
extends GenericGuiContainer<BuilderTileEntity> {
    private EnergyBar energyBar;
    private Button currentLevel;
    private ImageChoiceLabel[] anchor = new ImageChoiceLabel[4];

    public GuiBuilder(BuilderTileEntity builderTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)builderTileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "builder");
        BuilderTileEntity.setCurrentRF((long)builderTileEntity.getStoredPower());
    }

    public void func_73866_w_() {
        this.window = new Window((GuiScreen)this, this.tileEntity, RFToolsMessages.INSTANCE, new ResourceLocation("rftools", "gui/builder.gui"));
        super.func_73866_w_();
        this.initializeFields();
        this.setupEvents();
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer("rftools");
        ((BuilderTileEntity)this.tileEntity).requestCurrentLevel();
    }

    private void setupEvents() {
        this.window.event("cardgui", (source, params) -> this.openCardGui());
        this.window.event("anchor", (source, params) -> this.selectAnchor(source.getName()));
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.currentLevel = (Button)this.window.findChild("level");
        this.anchor[0] = (ImageChoiceLabel)this.window.findChild("anchor0");
        this.anchor[1] = (ImageChoiceLabel)this.window.findChild("anchor1");
        this.anchor[2] = (ImageChoiceLabel)this.window.findChild("anchor2");
        this.anchor[3] = (ImageChoiceLabel)this.window.findChild("anchor3");
        this.energyBar.setMaxValue(((BuilderTileEntity)this.tileEntity).getCapacity());
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        ((ChoiceLabel)this.window.findChild("mode")).setChoice(BuilderTileEntity.MODES[((BuilderTileEntity)this.tileEntity).getMode()]);
        ChoiceLabel rotateButton = (ChoiceLabel)this.window.findChild("rotate");
        rotateButton.setChoice(String.valueOf(((BuilderTileEntity)this.tileEntity).getRotate() * 90));
        if (!this.isShapeCard()) {
            this.anchor[((BuilderTileEntity)this.tileEntity).getAnchor()].setCurrentChoice(1);
        }
    }

    private void openCardGui() {
        ItemStack cardStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (!cardStack.func_190926_b()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            GuiShapeCard.fromTEPos = ((BuilderTileEntity)this.tileEntity).func_174877_v();
            GuiShapeCard.fromTEStackSlot = 0;
            GuiShapeCard.returnGui = this;
            player.openGui((Object)RFTools.instance, RFTools.GUI_SHAPECARD_COMPOSER, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    private void selectAnchor(String name) {
        int index = name.charAt(name.length() - 1) - 48;
        this.updateAnchorSettings(index);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "builder.setAnchor", TypedMap.builder().put(BuilderTileEntity.PARAM_ANCHOR_INDEX, (Object)index).build());
    }

    private void updateAnchorSettings(int index) {
        for (int i = 0; i < this.anchor.length; ++i) {
            if (this.isShapeCard()) {
                this.anchor[i].setCurrentChoice(0);
                continue;
            }
            this.anchor[i].setCurrentChoice(i == index ? 1 : 0);
        }
    }

    private boolean isShapeCard() {
        ItemStack card = ((BuilderTileEntity)this.tileEntity).func_70301_a(0);
        return !card.func_190926_b() && card.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int cury = BuilderTileEntity.getCurrentLevelClientSide();
        this.currentLevel.setText("Y: " + (cury == -1 ? "stop" : Integer.valueOf(cury)));
        ItemStack card = ((BuilderTileEntity)this.tileEntity).func_70301_a(0);
        if (card.func_190926_b()) {
            this.window.setFlag("!validcard");
        } else if (card.func_77973_b() == BuilderSetup.shapeCardItem) {
            this.window.setFlag("!validcard");
        } else {
            this.window.setFlag("validcard");
        }
        this.updateAnchorSettings(((BuilderTileEntity)this.tileEntity).getAnchor());
        this.drawWindow();
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer("rftools");
        ((BuilderTileEntity)this.tileEntity).requestCurrentLevel();
    }
}

