/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.relay;

import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.Arrays;
import java.util.List;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.blocks.relay.RelayEnergyStorage;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")
public class RelayTileEntity
extends GenericEnergyStorageTileEntity
implements ITickable,
MachineInformation,
IEnergyReceiver {
    public static final int MAXENERGY = 50000;
    public static final int RECEIVEPERTICK = 50000;
    public static final String CMD_SETTINGS = "relay.settings";
    public static final Key<Boolean> PARAM_INPUTON_D = new Key("inputOnD", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTON_U = new Key("inputOnU", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTON_N = new Key("inputOnN", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTON_S = new Key("inputOnS", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTON_W = new Key("inputOnW", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTON_E = new Key("inputOnE", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTON_I = new Key("inputOnI", Type.BOOLEAN);
    public static final List<Key<Boolean>> PARAM_INPUTON = Arrays.asList(PARAM_INPUTON_D, PARAM_INPUTON_U, PARAM_INPUTON_N, PARAM_INPUTON_S, PARAM_INPUTON_W, PARAM_INPUTON_E, PARAM_INPUTON_I);
    public static final Key<Boolean> PARAM_INPUTOFF_D = new Key("inputOffD", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTOFF_U = new Key("inputOffU", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTOFF_N = new Key("inputOffN", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTOFF_S = new Key("inputOffS", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTOFF_W = new Key("inputOffW", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTOFF_E = new Key("inputOffE", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_INPUTOFF_I = new Key("inputOffI", Type.BOOLEAN);
    public static final List<Key<Boolean>> PARAM_INPUTOFF = Arrays.asList(PARAM_INPUTOFF_D, PARAM_INPUTOFF_U, PARAM_INPUTOFF_N, PARAM_INPUTOFF_S, PARAM_INPUTOFF_W, PARAM_INPUTOFF_E, PARAM_INPUTOFF_I);
    public static final Key<Integer> PARAM_RFON_D = new Key("rfOnD", Type.INTEGER);
    public static final Key<Integer> PARAM_RFON_U = new Key("rfOnU", Type.INTEGER);
    public static final Key<Integer> PARAM_RFON_N = new Key("rfOnN", Type.INTEGER);
    public static final Key<Integer> PARAM_RFON_S = new Key("rfOnS", Type.INTEGER);
    public static final Key<Integer> PARAM_RFON_W = new Key("rfOnW", Type.INTEGER);
    public static final Key<Integer> PARAM_RFON_E = new Key("rfOnE", Type.INTEGER);
    public static final Key<Integer> PARAM_RFON_I = new Key("rfOnI", Type.INTEGER);
    public static final List<Key<Integer>> PARAM_RFON = Arrays.asList(PARAM_RFON_D, PARAM_RFON_U, PARAM_RFON_N, PARAM_RFON_S, PARAM_RFON_W, PARAM_RFON_E, PARAM_RFON_I);
    public static final Key<Integer> PARAM_RFOFF_D = new Key("rfOffD", Type.INTEGER);
    public static final Key<Integer> PARAM_RFOFF_U = new Key("rfOffU", Type.INTEGER);
    public static final Key<Integer> PARAM_RFOFF_N = new Key("rfOffN", Type.INTEGER);
    public static final Key<Integer> PARAM_RFOFF_S = new Key("rfOffS", Type.INTEGER);
    public static final Key<Integer> PARAM_RFOFF_W = new Key("rfOffW", Type.INTEGER);
    public static final Key<Integer> PARAM_RFOFF_E = new Key("rfOffE", Type.INTEGER);
    public static final Key<Integer> PARAM_RFOFF_I = new Key("rfOffI", Type.INTEGER);
    public static final List<Key<Integer>> PARAM_RFOFF = Arrays.asList(PARAM_RFOFF_D, PARAM_RFOFF_U, PARAM_RFOFF_N, PARAM_RFOFF_S, PARAM_RFOFF_W, PARAM_RFOFF_E, PARAM_RFOFF_I);
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    private static final String[] TAGS = new String[]{"rfpertick_out", "rfpertick_in"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The current RF/t output given by this block (last 2 seconds)", "The current RF/t input received by this block (last 2 seconds)"};
    private boolean[] inputModeOn = new boolean[]{false, false, false, false, false, false, false};
    private boolean[] inputModeOff = new boolean[]{false, false, false, false, false, false, false};
    private int[] rfOn = new int[]{1000, 1000, 1000, 1000, 1000, 1000, 1000};
    private int[] rfOff = new int[]{0, 0, 0, 0, 0, 0, 0};
    public static final String DUNSWEI = "DUBFLRI";
    private int lastRfPerTickIn = 0;
    private int lastRfPerTickOut = 0;
    private int powerIn = 0;
    private int powerOut = 0;
    private long lastTime = 0L;
    private RelayEnergyStorage[] facingStorage = new RelayEnergyStorage[7];

    public RelayTileEntity() {
        super(50000L, 50000L);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    public int getLastRfPerTickIn() {
        return this.lastRfPerTickIn;
    }

    public int getLastRfPerTickOut() {
        return this.lastRfPerTickOut;
    }

    public int getTagCount() {
        return TAGS.length;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return this.lastRfPerTickOut + "RF/t";
            }
            case 1: {
                return this.lastRfPerTickIn + "RF/t";
            }
        }
        return null;
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    private void checkStateServer() {
        long time = System.currentTimeMillis();
        if (this.lastTime == 0L) {
            this.lastTime = time;
        } else if (time > this.lastTime + 2000L) {
            this.lastRfPerTickIn = (int)((long)(50 * this.powerIn) / (time - this.lastTime));
            this.lastRfPerTickOut = (int)((long)(50 * this.powerOut) / (time - this.lastTime));
            this.lastTime = time;
            this.powerIn = 0;
            this.powerOut = 0;
        }
        boolean redstoneSignal = this.powerLevel > 0;
        int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        long energyStored = this.getStoredPower();
        if (energyStored <= 0L) {
            return;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            EnumFacing opposite;
            TileEntity te;
            int side = OrientationTools.reorient((EnumFacing)facing, (IBlockState)state).ordinal();
            if (rf[side] <= 0 || inputMode[side] || !EnergyTools.isEnergyTE((TileEntity)(te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing))), (EnumFacing)(opposite = facing.func_176734_d()))) continue;
            int rfToGive = (int)Math.min((long)rf[side], energyStored);
            int received = (int)EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (long)rfToGive);
            this.powerOut += received;
            if ((energyStored -= this.storage.extractEnergy((long)received, false)) > 0L) continue;
            return;
        }
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int side;
        boolean redstoneSignal = this.powerLevel > 0;
        boolean[] inputMode = redstoneSignal ? this.inputModeOn : this.inputModeOff;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        int n = side = from == null ? 6 : OrientationTools.reorient((EnumFacing)from, (IBlockState)state).ordinal();
        if (inputMode[side]) {
            int[] rf = redstoneSignal ? this.rfOn : this.rfOff;
            int actual = (int)this.storage.receiveEnergy((long)Math.min(maxReceive, rf[side]), simulate);
            if (!simulate) {
                this.powerIn += actual;
            }
            return actual;
        }
        return 0;
    }

    public boolean isInputModeOn(int side) {
        return this.inputModeOn[side];
    }

    public boolean isInputModeOff(int side) {
        return this.inputModeOff[side];
    }

    public int getRfOn(int side) {
        return this.rfOn[side];
    }

    public int getRfOff(int side) {
        return this.rfOff[side];
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        if (tagCompound.func_74764_b("rfOn")) {
            int on = tagCompound.func_74762_e("rfOn");
            int off = tagCompound.func_74762_e("rfOff");
            for (int i = 0; i < 7; ++i) {
                this.rfOn[i] = on;
                this.rfOff[i] = off;
                this.inputModeOn[i] = false;
                this.inputModeOff[i] = false;
            }
        } else {
            int i;
            int[] on = tagCompound.func_74759_k("on");
            int[] off = tagCompound.func_74759_k("off");
            System.arraycopy(on, 0, this.rfOn, 0, Math.min(7, on.length));
            System.arraycopy(off, 0, this.rfOff, 0, Math.min(7, off.length));
            byte[] inOn = tagCompound.func_74770_j("inputOn");
            byte[] inOff = tagCompound.func_74770_j("inputOff");
            for (i = 0; i < Math.min(7, inOn.length); ++i) {
                this.inputModeOn[i] = inOn[i] > 0;
            }
            for (i = 0; i < Math.min(7, inOff.length); ++i) {
                this.inputModeOff[i] = inOff[i] > 0;
            }
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74783_a("on", this.rfOn);
        tagCompound.func_74783_a("off", this.rfOff);
        byte[] inOn = new byte[7];
        byte[] inOff = new byte[7];
        for (int i = 0; i < 7; ++i) {
            inOn[i] = (byte)(this.inputModeOn[i] ? 1 : 0);
            inOff[i] = (byte)(this.inputModeOff[i] ? 1 : 0);
        }
        tagCompound.func_74773_a("inputOn", inOn);
        tagCompound.func_74773_a("inputOff", inOff);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            for (int i = 0; i < 7; ++i) {
                char prefix = DUNSWEI.charAt(i);
                this.inputModeOn[i] = (Boolean)params.get(PARAM_INPUTON.get(i));
                this.inputModeOff[i] = (Boolean)params.get(PARAM_INPUTOFF.get(i));
                this.rfOn[i] = (Integer)params.get(PARAM_RFON.get(i));
                this.rfOff[i] = (Integer)params.get(PARAM_RFOFF.get(i));
            }
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EnergyTools.TESLA_CONSUMER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == EnergyTools.TESLA_CONSUMER) {
            int facingOrdinal;
            int n = facingOrdinal = facing == null ? 6 : facing.ordinal();
            if (this.facingStorage[facingOrdinal] == null) {
                this.facingStorage[facingOrdinal] = new RelayEnergyStorage(this, facing);
            }
            return (T)this.facingStorage[facingOrdinal];
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        if (mode == ProbeMode.EXTENDED) {
            int rfPerTickIn = this.getLastRfPerTickIn();
            int rfPerTickOut = this.getLastRfPerTickOut();
            probeInfo.text(TextFormatting.GREEN + "In:  " + rfPerTickIn + "RF/t");
            probeInfo.text(TextFormatting.GREEN + "Out: " + rfPerTickOut + "RF/t");
        }
    }

    public IBlockState getActualState(IBlockState state) {
        boolean enabled = this.isPowered();
        return state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(enabled));
    }
}

