/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.EnergyPlusBarScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.EnergyPlusBarClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyPlusModuleItem
extends GenericRFToolsItem
implements IModuleProvider {
    public EnergyPlusModuleItem() {
        super("energyplus_module");
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public Class<EnergyPlusBarScreenModule> getServerScreenModule() {
        return EnergyPlusBarScreenModule.class;
    }

    public Class<EnergyPlusBarClientScreenModule> getClientScreenModule() {
        return EnergyPlusBarClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "RF";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.ENERGYPLUS_RFPERTICK + " RF/tick");
        boolean hasTarget = false;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text"));
            if (tagCompound.func_74764_b("monitorx")) {
                int dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                int monitorx = tagCompound.func_74762_e("monitorx");
                int monitory = tagCompound.func_74762_e("monitory");
                int monitorz = tagCompound.func_74762_e("monitorz");
                String monitorname = tagCompound.func_74779_i("monitorname");
                list.add(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")");
                list.add(TextFormatting.YELLOW + "Dimension: " + dim);
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add(TextFormatting.YELLOW + "Sneak right-click on a machine to set the");
            list.add(TextFormatting.YELLOW + "target for this energy module");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)facing)) {
            tagCompound.func_74768_a("monitordim", world.field_73011_w.getDimension());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            IBlockState state = player.func_130014_f_().func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockAccess)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Energy module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)"Energy module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return EnumActionResult.SUCCESS;
    }
}

