/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketListFromServer;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlayersReady
extends PacketListFromServer<PacketPlayersReady, String> {
    public PacketPlayersReady() {
    }

    public PacketPlayersReady(BlockPos pos, String command, List<String> list) {
        super(pos, command, list);
    }

    protected String createItem(ByteBuf buf) {
        return NetworkTools.readString((ByteBuf)buf);
    }

    protected void writeItemToBuf(ByteBuf buf, String item) {
        NetworkTools.writeString((ByteBuf)buf, (String)item);
    }

    public static class Handler
    implements IMessageHandler<PacketPlayersReady, IMessage> {
        public IMessage onMessage(PacketPlayersReady message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketPlayersReady message, MessageContext ctx) {
            TileEntity te = RFTools.proxy.getClientWorld().func_175625_s(message.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(message.command, message.list, Type.STRING)) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

