/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import openblocks.ApiSetup;
import openblocks.Config;
import openblocks.IOpenBlocksProxy;
import openblocks.OpenBlocksGuiHandler;
import openblocks.advancements.Criterions;
import openblocks.common.CanvasReplaceBlacklist;
import openblocks.common.CommandInventory;
import openblocks.common.DonationUrlManager;
import openblocks.common.ElevatorActionHandler;
import openblocks.common.ElevatorBlockRules;
import openblocks.common.EntityEventHandler;
import openblocks.common.GameRuleManager;
import openblocks.common.GuideActionHandler;
import openblocks.common.LootHandler;
import openblocks.common.LuggageDropHandler;
import openblocks.common.MagnetWhitelists;
import openblocks.common.MapDataManager;
import openblocks.common.PedometerHandler;
import openblocks.common.PlayerDeathHandler;
import openblocks.common.PlayerInventoryStore;
import openblocks.common.RadioVillagerTrades;
import openblocks.common.ServerTickHandler;
import openblocks.common.block.BlockAutoAnvil;
import openblocks.common.block.BlockAutoEnchantmentTable;
import openblocks.common.block.BlockBearTrap;
import openblocks.common.block.BlockBigButton;
import openblocks.common.block.BlockBigButtonWood;
import openblocks.common.block.BlockBlockBreaker;
import openblocks.common.block.BlockBlockPlacer;
import openblocks.common.block.BlockBuilderGuide;
import openblocks.common.block.BlockCannon;
import openblocks.common.block.BlockCanvas;
import openblocks.common.block.BlockCanvasGlass;
import openblocks.common.block.BlockDonationStation;
import openblocks.common.block.BlockDrawingTable;
import openblocks.common.block.BlockElevator;
import openblocks.common.block.BlockElevatorRotating;
import openblocks.common.block.BlockFan;
import openblocks.common.block.BlockFlag;
import openblocks.common.block.BlockGoldenEgg;
import openblocks.common.block.BlockGrave;
import openblocks.common.block.BlockGuide;
import openblocks.common.block.BlockHeal;
import openblocks.common.block.BlockImaginary;
import openblocks.common.block.BlockItemDropper;
import openblocks.common.block.BlockLadder;
import openblocks.common.block.BlockPaintCan;
import openblocks.common.block.BlockPaintMixer;
import openblocks.common.block.BlockPath;
import openblocks.common.block.BlockProjector;
import openblocks.common.block.BlockRopeLadder;
import openblocks.common.block.BlockScaffolding;
import openblocks.common.block.BlockSky;
import openblocks.common.block.BlockSponge;
import openblocks.common.block.BlockSprinkler;
import openblocks.common.block.BlockTank;
import openblocks.common.block.BlockTarget;
import openblocks.common.block.BlockTrophy;
import openblocks.common.block.BlockVacuumHopper;
import openblocks.common.block.BlockVillageHighlighter;
import openblocks.common.block.BlockXPBottler;
import openblocks.common.block.BlockXPDrain;
import openblocks.common.block.BlockXPShower;
import openblocks.common.entity.EntityCartographer;
import openblocks.common.entity.EntityGoldenEye;
import openblocks.common.entity.EntityHangGlider;
import openblocks.common.entity.EntityItemProjectile;
import openblocks.common.entity.EntityLuggage;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.entity.EntityMiniMe;
import openblocks.common.entity.EntityMountedBlock;
import openblocks.common.entity.EntityXPOrbNoFly;
import openblocks.common.item.ItemCartographer;
import openblocks.common.item.ItemCraneBackpack;
import openblocks.common.item.ItemCraneControl;
import openblocks.common.item.ItemCursor;
import openblocks.common.item.ItemDevNull;
import openblocks.common.item.ItemElevator;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemEpicEraser;
import openblocks.common.item.ItemFlagBlock;
import openblocks.common.item.ItemGoldenEye;
import openblocks.common.item.ItemGuide;
import openblocks.common.item.ItemHangGlider;
import openblocks.common.item.ItemHeightMap;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemImaginationGlasses;
import openblocks.common.item.ItemInfoBook;
import openblocks.common.item.ItemLuggage;
import openblocks.common.item.ItemOBGeneric;
import openblocks.common.item.ItemOBGenericUnstackable;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemPaintCan;
import openblocks.common.item.ItemPedometer;
import openblocks.common.item.ItemSkyBlock;
import openblocks.common.item.ItemSleepingBag;
import openblocks.common.item.ItemSlimalyzer;
import openblocks.common.item.ItemSonicGlasses;
import openblocks.common.item.ItemSpongeOnAStick;
import openblocks.common.item.ItemSqueegee;
import openblocks.common.item.ItemStencil;
import openblocks.common.item.ItemTankBlock;
import openblocks.common.item.ItemTastyClay;
import openblocks.common.item.ItemTrophyBlock;
import openblocks.common.item.ItemWrench;
import openblocks.common.item.ItemXpBucket;
import openblocks.common.sync.SyncableBlockLayers;
import openblocks.common.tileentity.TileEntityAutoAnvil;
import openblocks.common.tileentity.TileEntityAutoEnchantmentTable;
import openblocks.common.tileentity.TileEntityBearTrap;
import openblocks.common.tileentity.TileEntityBigButton;
import openblocks.common.tileentity.TileEntityBigButtonWood;
import openblocks.common.tileentity.TileEntityBlockBreaker;
import openblocks.common.tileentity.TileEntityBlockPlacer;
import openblocks.common.tileentity.TileEntityBuilderGuide;
import openblocks.common.tileentity.TileEntityCannon;
import openblocks.common.tileentity.TileEntityCanvas;
import openblocks.common.tileentity.TileEntityCanvasGlass;
import openblocks.common.tileentity.TileEntityDonationStation;
import openblocks.common.tileentity.TileEntityDrawingTable;
import openblocks.common.tileentity.TileEntityElevatorRotating;
import openblocks.common.tileentity.TileEntityFan;
import openblocks.common.tileentity.TileEntityFlag;
import openblocks.common.tileentity.TileEntityGoldenEgg;
import openblocks.common.tileentity.TileEntityGrave;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.common.tileentity.TileEntityHealBlock;
import openblocks.common.tileentity.TileEntityImaginary;
import openblocks.common.tileentity.TileEntityItemDropper;
import openblocks.common.tileentity.TileEntityPaintCan;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openblocks.common.tileentity.TileEntityProjector;
import openblocks.common.tileentity.TileEntitySky;
import openblocks.common.tileentity.TileEntitySprinkler;
import openblocks.common.tileentity.TileEntityTank;
import openblocks.common.tileentity.TileEntityTarget;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.common.tileentity.TileEntityVacuumHopper;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openblocks.common.tileentity.TileEntityXPBottler;
import openblocks.common.tileentity.TileEntityXPDrain;
import openblocks.common.tileentity.TileEntityXPShower;
import openblocks.enchantments.flimflams.BaneFlimFlam;
import openblocks.enchantments.flimflams.DummyCreepersFlimFlam;
import openblocks.enchantments.flimflams.EffectFlimFlam;
import openblocks.enchantments.flimflams.EncaseFlimFlam;
import openblocks.enchantments.flimflams.FlimFlamRegistry;
import openblocks.enchantments.flimflams.InventoryShuffleFlimFlam;
import openblocks.enchantments.flimflams.InvisibleMobsFlimFlam;
import openblocks.enchantments.flimflams.ItemDropFlimFlam;
import openblocks.enchantments.flimflams.LoreFlimFlam;
import openblocks.enchantments.flimflams.MountFlimFlam;
import openblocks.enchantments.flimflams.RenameFlimFlam;
import openblocks.enchantments.flimflams.SheepDyeFlimFlam;
import openblocks.enchantments.flimflams.SkyblockFlimFlam;
import openblocks.enchantments.flimflams.SnowballsFlimFlam;
import openblocks.enchantments.flimflams.SoundFlimFlam;
import openblocks.enchantments.flimflams.SquidFilmFlam;
import openblocks.enchantments.flimflams.TeleportFlimFlam;
import openblocks.enchantments.flimflams.UselessToolFlimFlam;
import openblocks.events.ElevatorActionEvent;
import openblocks.events.GuideActionEvent;
import openblocks.events.PlayerActionEvent;
import openblocks.rpc.IColorChanger;
import openblocks.rpc.IGuideAnimationTrigger;
import openblocks.rpc.IItemDropper;
import openblocks.rpc.ILevelChanger;
import openblocks.rpc.IRotatable;
import openblocks.rpc.IStencilCrafter;
import openblocks.rpc.ITriggerable;
import openblocks.rubbish.BrickManager;
import openblocks.rubbish.CommandFlimFlam;
import openblocks.rubbish.CommandLuck;
import openmods.Log;
import openmods.OpenMods;
import openmods.block.OpenBlock;
import openmods.config.BlockInstances;
import openmods.config.ItemInstances;
import openmods.config.game.FactoryRegistry;
import openmods.config.game.GameRegistryObjectsProvider;
import openmods.config.game.ModStartupHelper;
import openmods.config.game.RegisterBlock;
import openmods.config.game.RegisterItem;
import openmods.config.properties.ConfigProcessing;
import openmods.entity.EntityBlock;
import openmods.item.ItemGeneric;
import openmods.liquids.SingleFluidBucketFillHandler;
import openmods.network.event.NetworkEventEntry;
import openmods.network.event.NetworkEventManager;
import openmods.network.rpc.MethodEntry;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.sync.SyncableObjectType;
import openmods.sync.SyncableObjectTypeRegistry;
import openmods.utils.EnchantmentUtils;

@Mod(modid="openblocks", name="OpenBlocks", version="1.7.6", dependencies="required-after:openmods@[0.11.5,0.12)", guiFactory="openblocks.client.ModGuiFactory", updateJSON="http://openmods.info/versions/openblocks.json", certificateFingerprint="d2a9a8e8440196e26a268d1f3ddc01b2e9c572a5", acceptedMinecraftVersions="[1.12.2]")
public class OpenBlocks {
    public static final String MODID = "openblocks";
    public static final String NAME = "OpenBlocks";
    public static final String VERSION = "1.7.6";
    public static final String PROXY_SERVER = "openblocks.common.ServerProxy";
    public static final String PROXY_CLIENT = "openblocks.client.ClientProxy";
    public static final String DEPENDENCIES = "required-after:openmods@[0.11.5,0.12)";
    public static final String GUI_FACTORY = "openblocks.client.ModGuiFactory";
    public static final String UPDATE_JSON = "http://openmods.info/versions/openblocks.json";
    private static final int ENTITY_HANGGLIDER_ID = 701;
    private static final int ENTITY_LUGGAGE_ID = 702;
    private static final int ENTITY_MAGNET_ID = 703;
    private static final int ENTITY_BLOCK_ID = 704;
    private static final int ENTITY_CARTOGRAPHER_ID = 705;
    private static final int ENTITY_CANON_ITEM_ID = 706;
    private static final int ENTITY_GOLDEN_EYE_ID = 707;
    private static final int ENTITY_MAGNET_PLAYER_ID = 708;
    private static final int ENTITY_XP_ID = 709;
    private static final int ENTITY_MINIME_ID = 710;
    @Mod.Instance(value="openblocks")
    public static OpenBlocks instance;
    @SidedProxy(clientSide="openblocks.client.ClientProxy", serverSide="openblocks.common.ServerProxy")
    public static IOpenBlocksProxy proxy;
    private final ApiSetup apiSetup = new ApiSetup();
    public static final StatBase brickStat;
    private final ModStartupHelper startupHelper = new ModStartupHelper("openblocks"){

        protected void populateConfig(Configuration config) {
            ConfigProcessing.processAnnotations((String)OpenBlocks.MODID, (Configuration)config, Config.class);
        }

        protected void setupConfigPre(GameRegistryObjectsProvider gameConfig) {
            gameConfig.setCreativeTab(() -> OpenBlocks.createTabOpenBlocks());
            gameConfig.addModIdToRemap(OpenBlocks.NAME);
        }

        protected void setupItemFactory(FactoryRegistry<Item> itemFactory) {
            itemFactory.registerFactory("pencil_glasses", () -> new ItemImaginationGlasses(ItemImaginationGlasses.Type.PENCIL));
            itemFactory.registerFactory("technicolor_glasses", () -> new ItemImaginationGlasses(ItemImaginationGlasses.Type.TECHNICOLOR));
            itemFactory.registerFactory("serious_glasses", () -> new ItemImaginationGlasses(ItemImaginationGlasses.Type.BASTARD));
        }
    };
    private final List<ItemStack> filledBuckets = Lists.newArrayList();

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    private static CreativeTabs createTabOpenBlocks() {
        return new CreativeTabs("tabOpenBlocks"){

            public ItemStack func_78016_d() {
                if (Blocks.flag != null) {
                    return new ItemStack(Blocks.flag, 1, BlockFlag.DEFAULT_COLOR.vanillaBlockId);
                }
                return new ItemStack(net.minecraft.init.Blocks.field_150360_v);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> result) {
                super.func_78018_a(result);
                if (Enchantments.explosive != null) {
                    EnchantmentUtils.addAllBooks((Enchantment)Enchantments.explosive, result);
                }
                if (Enchantments.lastStand != null) {
                    EnchantmentUtils.addAllBooks((Enchantment)Enchantments.lastStand, result);
                }
                if (Enchantments.flimFlam != null) {
                    EnchantmentUtils.addAllBooks((Enchantment)Enchantments.flimFlam, result);
                }
            }
        };
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent evt) {
        this.apiSetup.injectProvider();
    }

    private static final String decorateEntityName(String name) {
        return "openblocks." + name;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        FluidRegistry.registerFluid((Fluid)Fluids.xpJuice);
        if (Config.registerUniversalXpBucket) {
            FluidRegistry.addBucketForFluid((Fluid)Fluids.xpJuice);
        }
        Criterions.init();
        this.startupHelper.registerBlocksHolder(Blocks.class);
        this.startupHelper.registerItemsHolder(Items.class);
        this.startupHelper.preInit(evt.getSuggestedConfigurationFile());
        Config.register();
        this.apiSetup.setupApis();
        this.apiSetup.installHolderAccess(evt.getAsmData());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, OpenMods.proxy.wrapHandler((IGuiHandler)new OpenBlocksGuiHandler()));
        MinecraftForge.EVENT_BUS.register((Object)new PlayerDeathHandler());
        if (Items.cursor != null) {
            // empty if block
        }
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("luggage"), EntityLuggage.class, (String)OpenBlocks.decorateEntityName("luggage"), (int)702, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("xp_orb_no_fly"), EntityXPOrbNoFly.class, (String)OpenBlocks.decorateEntityName("xp_orb_no_fly"), (int)709, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("hang_glider"), EntityHangGlider.class, (String)OpenBlocks.decorateEntityName("hang_glider"), (int)701, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("magnet"), EntityMagnet.class, (String)OpenBlocks.decorateEntityName("magnet"), (int)703, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("mounted_block"), EntityMountedBlock.class, (String)OpenBlocks.decorateEntityName("mounted_block"), (int)704, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("player_magnet"), EntityMagnet.PlayerBound.class, (String)OpenBlocks.decorateEntityName("player_magnet"), (int)708, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("cartographer"), EntityCartographer.class, (String)OpenBlocks.decorateEntityName("cartographer"), (int)705, (Object)instance, (int)64, (int)8, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("item_projectile"), EntityItemProjectile.class, (String)OpenBlocks.decorateEntityName("item_projectile"), (int)706, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("golden_eye"), EntityGoldenEye.class, (String)OpenBlocks.decorateEntityName("golden_eye"), (int)707, (Object)instance, (int)64, (int)8, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)OpenBlocks.location("mini_me"), EntityMiniMe.class, (String)OpenBlocks.decorateEntityName("mini_me"), (int)710, (Object)instance, (int)64, (int)1, (boolean)true);
        CompoundDataFixer dataFixer = FMLCommonHandler.instance().getDataFixer();
        EntityLiving.func_189752_a((DataFixer)dataFixer, EntityMiniMe.class);
        EntityLuggage.registerFixes((DataFixer)dataFixer);
        ItemLuggage.registerFixes((DataFixer)dataFixer);
        EntityBlock.registerFixes((DataFixer)dataFixer, EntityMountedBlock.class);
        EntityCartographer.registerFixes((DataFixer)dataFixer);
        ItemCartographer.registerFixes((DataFixer)dataFixer);
        EntityItemProjectile.registerFixes((DataFixer)dataFixer);
        EntityGoldenEye.registerFixes((DataFixer)dataFixer);
        ItemDevNull.registerFixes((DataFixer)dataFixer);
        MagnetWhitelists.instance.initTesters();
        MinecraftForge.EVENT_BUS.register((Object)MapDataManager.instance);
        if (!Config.soSerious) {
            BrickManager.registerCapability();
            MinecraftForge.EVENT_BUS.register((Object)new BrickManager());
        }
        if (Blocks.elevator != null || Blocks.elevatorRotating != null) {
            MinecraftForge.EVENT_BUS.register((Object)ElevatorBlockRules.instance);
            MinecraftForge.EVENT_BUS.register((Object)new ElevatorActionHandler());
        }
        if (Config.radioVillagerEnabled) {
            RadioVillagerTrades.registerUselessVillager();
        }
        if (Items.luggage != null) {
            MinecraftForge.EVENT_BUS.register((Object)new LuggageDropHandler());
        }
        if (Blocks.guide != null || Blocks.builderGuide != null) {
            MinecraftForge.EVENT_BUS.register((Object)new GuideActionHandler());
        }
        if (Items.xpBucket != null && Config.xpBucketDirectFill) {
            MinecraftForge.EVENT_BUS.register((Object)new SingleFluidBucketFillHandler(new ItemStack(Items.xpBucket)));
        }
        if (Items.pedometer != null) {
            PedometerHandler.registerCapability();
        }
        if (Items.sleepingBag != null) {
            MinecraftForge.EVENT_BUS.register((Object)new ItemSleepingBag.IsSleepingHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)CanvasReplaceBlacklist.instance);
        MinecraftForge.EVENT_BUS.register((Object)PlayerInventoryStore.instance);
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GameRuleManager());
        LootHandler.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerTickHandler());
        proxy.init();
        proxy.registerRenderInformation();
        OpenBlocks.registerOreDictionary();
        this.startupHelper.init();
        if (Blocks.imaginary != null) {
            Blocks.imaginary.setSoundType();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        proxy.postInit();
        if (Enchantments.flimFlam != null) {
            FlimFlamRegistry.instance.registerFlimFlam("inventory-shuffle", -50, 100, new InventoryShuffleFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("useless-tool", -125, 50, new UselessToolFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("bane", -125, 100, new BaneFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("epic-lore", -10, 100, new LoreFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("living-rename", -10, 100, new RenameFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("squid", -75, 50, new SquidFilmFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("sheep-dye", -5, 50, new SheepDyeFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("invisible-mobs", -25, 10, new InvisibleMobsFlimFlam()).markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("sound", -5, 150, new SoundFlimFlam()).markSilent().markSafe();
            FlimFlamRegistry.instance.registerFlimFlam("snowballs", -50, 50, new SnowballsFlimFlam());
            FlimFlamRegistry.instance.registerFlimFlam("teleport", -100, 30, new TeleportFlimFlam());
            FlimFlamRegistry.instance.registerFlimFlam("mount", -150, 25, new MountFlimFlam());
            FlimFlamRegistry.instance.registerFlimFlam("encase", -50, 50, new EncaseFlimFlam()).setRange(Integer.MIN_VALUE, -300);
            FlimFlamRegistry.instance.registerFlimFlam("creepers", -60, 50, new DummyCreepersFlimFlam());
            FlimFlamRegistry.instance.registerFlimFlam("disarm", -50, 50, new ItemDropFlimFlam());
            FlimFlamRegistry.instance.registerFlimFlam("effect", -75, 75, new EffectFlimFlam());
            FlimFlamRegistry.instance.registerFlimFlam("skyblock", -100, 150, new SkyblockFlimFlam()).setRange(Integer.MIN_VALUE, -400);
            FlimFlamRegistry.BLACKLIST.init();
        }
        if (Blocks.tank != null && Config.allowBucketDrain) {
            TileEntityTank.BucketFillHandler tankFillHandler = new TileEntityTank.BucketFillHandler();
            for (ItemStack bucket : this.filledBuckets) {
                tankFillHandler.addFilledBucket(bucket);
            }
            this.filledBuckets.clear();
            for (String bucketId : Config.bucketItems) {
                ResourceLocation bucketLocation = new ResourceLocation(bucketId);
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)bucketLocation);
                if (item == null) {
                    Log.warn((String)"Failed to find bucket item %s", (Object[])new Object[]{item});
                    continue;
                }
                tankFillHandler.addFilledBucket(new ItemStack(item));
            }
            MinecraftForge.EVENT_BUS.register((Object)tankFillHandler);
        }
    }

    @Mod.EventHandler
    public void processMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.isStringMessage() && "donateUrl".equalsIgnoreCase(m.key)) {
                DonationUrlManager.instance().addUrl(m.getSender(), m.getStringValue());
            }
            if (!m.isItemStackMessage() || !"bucket".equalsIgnoreCase(m.key)) continue;
            this.filledBuckets.add(m.getItemStackValue());
        }
    }

    @Mod.EventHandler
    public void severStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandFlimFlam());
        evt.registerServerCommand((ICommand)new CommandLuck());
        evt.registerServerCommand((ICommand)new CommandInventory());
    }

    public static String getModId() {
        return OpenBlocks.class.getAnnotation(Mod.class).modid();
    }

    private static void registerOreDictionary() {
        OreDictionary.registerOre((String)"craftingTableWood", (ItemStack)new ItemStack(net.minecraft.init.Blocks.field_150462_ai));
        OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack((Block)net.minecraft.init.Blocks.field_150486_ae));
    }

    static {
        brickStat = new StatBasic("openblocks.dropped", (ITextComponent)new TextComponentTranslation("stat.openblocks.bricksDropped", new Object[0]), StatBase.field_75980_h).func_75971_g();
    }

    @Mod.EventBusSubscriber
    public static class RegistryEntries {
        @SubscribeEvent
        public static void registerSyncTypes(RegistryEvent.Register<SyncableObjectType> type) {
            SyncableObjectTypeRegistry.startRegistration((IForgeRegistry)type.getRegistry()).register(EntityCartographer.MapJobs.class).register(SyncableBlockLayers.class);
        }

        @SubscribeEvent
        public static void registerMethodTypes(RegistryEvent.Register<MethodEntry> evt) {
            RpcCallDispatcher.startMethodRegistration((IForgeRegistry)evt.getRegistry()).registerInterface(IRotatable.class).registerInterface(IStencilCrafter.class).registerInterface(IColorChanger.class).registerInterface(ILevelChanger.class).registerInterface(ITriggerable.class).registerInterface(IGuideAnimationTrigger.class).registerInterface(IItemDropper.class);
        }

        @SubscribeEvent
        public static void registerNetworkEvents(RegistryEvent.Register<NetworkEventEntry> evt) {
            NetworkEventManager.startRegistration((IForgeRegistry)evt.getRegistry()).register(MapDataManager.MapDataRequestEvent.class).register(MapDataManager.MapDataResponseEvent.class).register(MapDataManager.MapUpdatesEvent.class).register(ElevatorActionEvent.class).register(PlayerActionEvent.class).register(GuideActionEvent.class).register(EntityMiniMe.OwnerChangeEvent.class);
        }
    }

    @GameRegistry.ObjectHolder(value="openblocks")
    public static class Enchantments {
        @GameRegistry.ObjectHolder(value="explosive")
        public static final Enchantment explosive = null;
        @GameRegistry.ObjectHolder(value="last_stand")
        public static final Enchantment lastStand = null;
        @GameRegistry.ObjectHolder(value="flim_flam")
        public static final Enchantment flimFlam = null;
    }

    @GameRegistry.ObjectHolder(value="openblocks")
    @Mod.EventBusSubscriber
    public static class Sounds {
        @GameRegistry.ObjectHolder(value="elevator.activate")
        public static final SoundEvent BLOCK_ELEVATOR_ACTIVATE = null;
        @GameRegistry.ObjectHolder(value="grave.rob")
        public static final SoundEvent BLOCK_GRAVE_ROB = null;
        @GameRegistry.ObjectHolder(value="beartrap.open")
        public static final SoundEvent BLOCK_BEARTRAP_OPEN = null;
        @GameRegistry.ObjectHolder(value="beartrap.close")
        public static final SoundEvent BLOCK_BEARTRAP_CLOSE = null;
        @GameRegistry.ObjectHolder(value="cannon.activate")
        public static final SoundEvent BLOCK_CANNON_ACTIVATE = null;
        @GameRegistry.ObjectHolder(value="target.open")
        public static final SoundEvent BLOCK_TARGET_OPEN = null;
        @GameRegistry.ObjectHolder(value="target.close")
        public static final SoundEvent BLOCK_TARGET_CLOSE = null;
        @GameRegistry.ObjectHolder(value="bottler.signal")
        public static final SoundEvent BLOCK_XPBOTTLER_DONE = null;
        @GameRegistry.ObjectHolder(value="crayon.place")
        public static final SoundEvent ITEM_CRAYON_PLACE = null;
        @GameRegistry.ObjectHolder(value="luggage.walk")
        public static final SoundEvent ENTITY_LUGGAGE_WALK = null;
        @GameRegistry.ObjectHolder(value="luggage.eat.food")
        public static final SoundEvent ENTITY_LUGGAGE_EAT_FOOD = null;
        @GameRegistry.ObjectHolder(value="luggage.eat.item")
        public static final SoundEvent ENTITY_LUGGAGE_EAT_ITEM = null;
        @GameRegistry.ObjectHolder(value="pedometer.use")
        public static final SoundEvent ITEM_PEDOMETER_USE = null;
        @GameRegistry.ObjectHolder(value="slimalyzer.signal")
        public static final SoundEvent ITEM_SLIMALYZER_PING = null;
        @GameRegistry.ObjectHolder(value="squeegee.use")
        public static final SoundEvent ITEM_SQUEEGEE_ACTION = null;
        @GameRegistry.ObjectHolder(value="best.feature.ever.fart")
        public static final SoundEvent PLAYER_WHOOPS = null;
        @GameRegistry.ObjectHolder(value="annoying.mosquito")
        public static final SoundEvent MISC_MOSQUITO = null;
        @GameRegistry.ObjectHolder(value="annoying.alarmclock")
        public static final SoundEvent MISC_ALARM_CLOCK = null;
        @GameRegistry.ObjectHolder(value="annoying.vibrate")
        public static final SoundEvent MISC_VIBRATE = null;

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> evt) {
            IForgeRegistry registry = evt.getRegistry();
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "elevator.activate");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "grave.rob");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "crayon.place");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "luggage.walk");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "luggage.eat.food");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "luggage.eat.item");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "pedometer.use");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "slimalyzer.signal");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "squeegee.use");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "best.feature.ever.fart");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "annoying.mosquito");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "annoying.alarmclock");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "annoying.vibrate");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "beartrap.open");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "beartrap.close");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "cannon.activate");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "target.open");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "target.close");
            Sounds.registerSound((IForgeRegistry<SoundEvent>)registry, "bottler.signal");
        }

        private static void registerSound(IForgeRegistry<SoundEvent> registry, String id) {
            ResourceLocation resourceLocation = OpenBlocks.location(id);
            registry.register(new SoundEvent(resourceLocation).setRegistryName(resourceLocation));
        }
    }

    public static class Fluids {
        public static final Fluid xpJuice = new Fluid("xpjuice", OpenBlocks.location("blocks/xp_juice_still"), OpenBlocks.location("blocks/xp_juice_flowing")).setLuminosity(10).setDensity(800).setViscosity(1500).setUnlocalizedName("openblocks.xp_juice").setEmptySound(SoundEvents.field_187802_ec).setFillSound(SoundEvents.field_187604_bf);
    }

    public static class Items
    implements ItemInstances {
        @RegisterItem(type=ItemHangGlider.class, id="hang_glider", legacyIds={"hangglider"})
        public static Item hangGlider;
        @RegisterItem(type=ItemOBGeneric.class, id="generic", registerDefaultModel=false)
        public static ItemGeneric generic;
        @RegisterItem(type=ItemLuggage.class, id="luggage")
        public static Item luggage;
        @RegisterItem(type=ItemSonicGlasses.class, id="sonic_glasses", legacyIds={"sonicglasses"})
        public static Item sonicGlasses;
        @RegisterItem(type=ItemImaginationGlasses.class, id="pencil_glasses", unlocalizedName="glasses.pencil", legacyIds={"pencilGlasses"})
        public static Item pencilGlasses;
        @RegisterItem(type=ItemImaginationGlasses.ItemCrayonGlasses.class, id="crayon_glasses", unlocalizedName="glasses.crayon", legacyIds={"crayonGlasses"})
        public static Item crayonGlasses;
        @RegisterItem(type=ItemImaginationGlasses.class, id="technicolor_glasses", unlocalizedName="glasses.technicolor", legacyIds={"technicolorGlasses"})
        public static Item technicolorGlasses;
        @RegisterItem(type=ItemImaginationGlasses.class, id="serious_glasses", unlocalizedName="glasses.admin", legacyIds={"seriousGlasses"})
        public static Item seriousGlasses;
        @RegisterItem(type=ItemCraneControl.class, id="crane_control", legacyIds={"craneControl"})
        public static Item craneControl;
        @RegisterItem(type=ItemCraneBackpack.class, id="crane_backpack", legacyIds={"craneBackpack"})
        public static Item craneBackpack;
        @RegisterItem(type=ItemSlimalyzer.class, id="slimalyzer")
        public static Item slimalyzer;
        @RegisterItem(type=ItemXpBucket.class, id="xp_bucket", legacyIds={"filledbucket"})
        public static Item xpBucket;
        @RegisterItem(type=ItemSleepingBag.class, id="sleeping_bag", legacyIds={"sleepingBag"})
        public static Item sleepingBag;
        @RegisterItem(type=ItemPaintBrush.class, id="paintbrush", legacyIds={"paintBrush"})
        public static Item paintBrush;
        @RegisterItem(type=ItemStencil.class, id="stencil", registerDefaultModel=false)
        public static Item stencil;
        @RegisterItem(type=ItemSqueegee.class, id="squeegee")
        public static Item squeegee;
        @RegisterItem(type=ItemHeightMap.class, id="height_map", legacyIds={"heightMap"})
        public static Item heightMap;
        @RegisterItem(type=ItemEmptyMap.class, id="empty_map", legacyIds={"emptyMap"})
        public static Item emptyMap;
        @RegisterItem(type=ItemCartographer.class, id="cartographer")
        public static Item cartographer;
        @RegisterItem(type=ItemTastyClay.class, id="tasty_clay", legacyIds={"tastyClay"})
        public static Item tastyClay;
        @RegisterItem(type=ItemGoldenEye.class, id="golden_eye", legacyIds={"goldenEye"})
        public static Item goldenEye;
        @RegisterItem(type=ItemOBGenericUnstackable.class, id="generic_unstackable", registerDefaultModel=false, legacyIds={"genericUnstackable"})
        public static ItemGeneric genericUnstackable;
        @RegisterItem(type=ItemCursor.class, id="cursor")
        public static Item cursor;
        @RegisterItem(type=ItemInfoBook.class, id="info_book", legacyIds={"infoBook"})
        public static Item infoBook;
        @RegisterItem(type=ItemDevNull.class, id="dev_null", legacyIds={"devnull"})
        public static Item devNull;
        @RegisterItem(type=ItemSpongeOnAStick.class, id="sponge_on_a_stick", legacyIds={"spongeonastick"})
        public static Item spongeonastick;
        @RegisterItem(type=ItemPedometer.class, id="pedometer")
        public static Item pedometer;
        @RegisterItem(type=ItemEpicEraser.class, id="epic_eraser", legacyIds={"epicEraser"})
        public static Item epicEraser;
        @RegisterItem(type=ItemWrench.class, id="wrench")
        public static Item wrench;
    }

    public static class Blocks
    implements BlockInstances {
        @RegisterBlock(type=BlockLadder.class, id="ladder")
        public static Block ladder;
        @RegisterBlock(type=BlockGuide.class, id="guide", tileEntity=TileEntityGuide.class, itemBlock=ItemGuide.class)
        public static Block guide;
        @RegisterBlock(type=BlockBuilderGuide.class, id="builder_guide", tileEntity=TileEntityBuilderGuide.class, itemBlock=ItemGuide.class)
        public static Block builderGuide;
        @RegisterBlock(type=BlockElevator.class, id="elevator", itemBlock=ItemElevator.class, registerDefaultItemModel=false)
        public static Block elevator;
        @RegisterBlock(type=BlockElevatorRotating.class, id="elevator_rotating", tileEntity=TileEntityElevatorRotating.class, itemBlock=ItemElevator.class, registerDefaultItemModel=false)
        public static Block elevatorRotating;
        @RegisterBlock(type=BlockHeal.class, id="heal", tileEntity=TileEntityHealBlock.class)
        public static Block heal;
        @RegisterBlock(type=BlockTarget.class, id="target", tileEntity=TileEntityTarget.class)
        public static Block target;
        @RegisterBlock(type=BlockGrave.class, id="grave", tileEntity=TileEntityGrave.class)
        public static Block grave;
        @RegisterBlock(type=BlockFlag.class, id="flag", tileEntity=TileEntityFlag.class, itemBlock=ItemFlagBlock.class)
        public static Block flag;
        @RegisterBlock(type=BlockTank.class, id="tank", tileEntity=TileEntityTank.class, itemBlock=ItemTankBlock.class)
        public static Block tank;
        @RegisterBlock(type=BlockTrophy.class, id="trophy", tileEntity=TileEntityTrophy.class, itemBlock=ItemTrophyBlock.class)
        public static Block trophy;
        @RegisterBlock(type=BlockBearTrap.class, id="beartrap", tileEntity=TileEntityBearTrap.class)
        public static Block bearTrap;
        @RegisterBlock(type=BlockSprinkler.class, id="sprinkler", tileEntity=TileEntitySprinkler.class)
        public static Block sprinkler;
        @RegisterBlock(type=BlockCannon.class, id="cannon", tileEntity=TileEntityCannon.class)
        public static OpenBlock cannon;
        @RegisterBlock(type=BlockVacuumHopper.class, id="vacuum_hopper", tileEntity=TileEntityVacuumHopper.class, legacyIds={"vacuumhopper"})
        public static Block vacuumHopper;
        @RegisterBlock(type=BlockSponge.class, id="sponge")
        public static Block sponge;
        @RegisterBlock(type=BlockBigButton.class, id="big_button", tileEntity=TileEntityBigButton.class, legacyIds={"bigbutton"})
        public static Block bigButton;
        @RegisterBlock(type=BlockBigButtonWood.class, id="big_button_wood", tileEntity=TileEntityBigButtonWood.class)
        public static Block bigButtonWood;
        @RegisterBlock(id="imaginary", tileEntity=TileEntityImaginary.class, itemBlock=ItemImaginary.class, customItemModels=ItemImaginary.ModelProvider.class, registerDefaultItemModel=false)
        public static BlockImaginary imaginary;
        @RegisterBlock(type=BlockFan.class, id="fan", tileEntity=TileEntityFan.class)
        public static Block fan;
        @RegisterBlock(type=BlockXPBottler.class, id="xp_bottler", tileEntity=TileEntityXPBottler.class, legacyIds={"xpbottler"})
        public static Block xpBottler;
        @RegisterBlock(type=BlockVillageHighlighter.class, id="village_highlighter", tileEntity=TileEntityVillageHighlighter.class)
        public static Block villageHighlighter;
        @RegisterBlock(type=BlockPath.class, id="path")
        public static Block path;
        @RegisterBlock(type=BlockAutoAnvil.class, id="auto_anvil", tileEntity=TileEntityAutoAnvil.class, legacyIds={"autoanvil"})
        public static Block autoAnvil;
        @RegisterBlock(type=BlockAutoEnchantmentTable.class, id="auto_enchantment_table", tileEntity=TileEntityAutoEnchantmentTable.class, legacyIds={"autoenchantmenttable"})
        public static Block autoEnchantmentTable;
        @RegisterBlock(type=BlockXPDrain.class, id="xp_drain", tileEntity=TileEntityXPDrain.class, legacyIds={"xpdrain"})
        public static Block xpDrain;
        @RegisterBlock(type=BlockBlockBreaker.class, id="block_breaker", tileEntity=TileEntityBlockBreaker.class, legacyIds={"blockbreaker"})
        public static Block blockBreaker;
        @RegisterBlock(type=BlockBlockPlacer.class, id="block_placer", tileEntity=TileEntityBlockPlacer.class, legacyIds={"blockPlacer"})
        public static Block blockPlacer;
        @RegisterBlock(type=BlockItemDropper.class, id="item_dropper", tileEntity=TileEntityItemDropper.class, legacyIds={"itemDropper"})
        public static Block itemDropper;
        @RegisterBlock(type=BlockRopeLadder.class, id="rope_ladder", legacyIds={"ropeladder"})
        public static Block ropeLadder;
        @RegisterBlock(type=BlockDonationStation.class, id="donation_station", tileEntity=TileEntityDonationStation.class, legacyIds={"donationStation"})
        public static Block donationStation;
        @RegisterBlock(type=BlockPaintMixer.class, id="paint_mixer", tileEntity=TileEntityPaintMixer.class, legacyIds={"paintmixer"})
        public static Block paintMixer;
        @RegisterBlock(type=BlockCanvas.class, id="canvas", tileEntity=TileEntityCanvas.class)
        public static Block canvas;
        @RegisterBlock(type=BlockPaintCan.class, id="paint_can", tileEntity=TileEntityPaintCan.class, itemBlock=ItemPaintCan.class, legacyIds={"paintcan"})
        public static Block paintCan;
        @RegisterBlock(type=BlockCanvasGlass.class, id="canvas_glass", tileEntity=TileEntityCanvasGlass.class, legacyIds={"canvasglass"})
        public static Block canvasGlass;
        @RegisterBlock(type=BlockProjector.class, id="projector", tileEntity=TileEntityProjector.class)
        public static Block projector;
        @RegisterBlock(type=BlockDrawingTable.class, id="drawing_table", tileEntity=TileEntityDrawingTable.class, legacyIds={"drawingtable"})
        public static Block drawingTable;
        @RegisterBlock(type=BlockSky.class, id="sky", tileEntity=TileEntitySky.class, itemBlock=ItemSkyBlock.class, unlocalizedName="sky.normal")
        public static Block sky;
        @RegisterBlock(type=BlockXPShower.class, id="xp_shower", tileEntity=TileEntityXPShower.class, legacyIds={"xpshower"})
        public static Block xpShower;
        @RegisterBlock(type=BlockGoldenEgg.class, id="golden_egg", tileEntity=TileEntityGoldenEgg.class, legacyIds={"goldenegg"})
        public static Block goldenEgg;
        @RegisterBlock(type=BlockScaffolding.class, id="scaffolding", itemBlock=BlockScaffolding.Item.class)
        public static Block scaffolding;
    }
}

