/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import openblocks.client.gui.StandardPalette;
import openblocks.common.LiquidXpUtils;
import openblocks.common.container.ContainerAutoEnchantmentTable;
import openblocks.common.tileentity.TileEntityAutoEnchantmentTable;
import openblocks.rpc.ILevelChanger;
import openmods.api.IValueReceiver;
import openmods.container.ContainerBase;
import openmods.gui.GuiConfigurableSlots;
import openmods.gui.Icon;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentPanel;
import openmods.gui.component.GuiComponentSlider;
import openmods.gui.component.GuiComponentTab;
import openmods.gui.component.GuiComponentTankLevel;
import openmods.gui.component.GuiComponentToggleButton;
import openmods.gui.logic.IValueUpdateAction;
import openmods.gui.logic.ValueCopyAction;
import openmods.utils.MiscUtils;
import openmods.utils.TranslationUtils;
import openmods.utils.VanillaEnchantLogic;

public class GuiAutoEnchantmentTable
extends GuiConfigurableSlots<TileEntityAutoEnchantmentTable, ContainerAutoEnchantmentTable, TileEntityAutoEnchantmentTable.AutoSlots> {
    private static final ResourceLocation VANILLA_TEXTURE = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private static final Map<VanillaEnchantLogic.Level, Icon> icons = ImmutableMap.of((Object)VanillaEnchantLogic.Level.L1, (Object)Icon.createSheetIcon((ResourceLocation)VANILLA_TEXTURE, (int)0, (int)223, (int)16, (int)16), (Object)VanillaEnchantLogic.Level.L2, (Object)Icon.createSheetIcon((ResourceLocation)VANILLA_TEXTURE, (int)16, (int)223, (int)16, (int)16), (Object)VanillaEnchantLogic.Level.L3, (Object)Icon.createSheetIcon((ResourceLocation)VANILLA_TEXTURE, (int)32, (int)223, (int)16, (int)16));
    private static final Icon LAPIS_SLOT = Icon.createSheetIcon((ResourceLocation)VANILLA_TEXTURE, (int)34, (int)46, (int)18, (int)18);

    public GuiAutoEnchantmentTable(ContainerAutoEnchantmentTable container) {
        super((ContainerBase)container, 176, 175, "openblocks.gui.autoenchantmenttable");
    }

    protected Iterable<TileEntityAutoEnchantmentTable.AutoSlots> getSlots() {
        return ImmutableList.of((Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.toolInput), (Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.lapisInput), (Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.xp), (Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.output));
    }

    protected void addCustomizations(BaseComposite root) {
        TileEntityAutoEnchantmentTable te = (TileEntityAutoEnchantmentTable)((ContainerAutoEnchantmentTable)this.getContainer()).getOwner();
        ILevelChanger rpc = (ILevelChanger)te.createClientRpcProxy(ILevelChanger.class, new Class[0]);
        ((GuiComponentPanel)root).setSlotRenderer(1, GuiComponentPanel.customIconSlot((Icon)LAPIS_SLOT, (int)-1, (int)-1));
        GuiComponentSlider slider = new GuiComponentSlider(44, 39, 45, 1, 30, 1, true, TranslationUtils.translateToLocal((String)"openblocks.gui.limit"));
        slider.setListener(value -> rpc.changePowerLimit(value.intValue()));
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getLevelProvider(), (IValueReceiver)slider, Integer::doubleValue));
        root.addComponent((BaseComponent)slider);
        GuiComponentLabel maxPower = new GuiComponentLabel(40, 25, "0");
        maxPower.setMaxWidth(100);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getAvailablePowerProvider(), value -> maxPower.setText(TranslationUtils.translateToLocalFormatted((String)"openblocks.gui.available_power", (Object[])new Object[]{value}))));
        root.addComponent((BaseComponent)maxPower);
        GuiComponentTankLevel tankLevel = new GuiComponentTankLevel(140, 30, 17, 37, 30);
        tankLevel.setDisplayFluidNameInTooltip(false);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getFluidProvider(), (IValueReceiver)tankLevel.fluidReceiver(), LiquidXpUtils.FLUID_TO_LEVELS));
        root.addComponent((BaseComponent)tankLevel);
        GuiComponentToggleButton levelSelect = new GuiComponentToggleButton(16, 60, 0xFFFFFF, icons);
        levelSelect.setListener((component, x, y, button) -> {
            VanillaEnchantLogic.Level currentValue = (VanillaEnchantLogic.Level)te.getSelectedLevelProvider().getValue();
            VanillaEnchantLogic.Level[] values = VanillaEnchantLogic.Level.values();
            VanillaEnchantLogic.Level nextValue = values[(currentValue.ordinal() + 1) % values.length];
            rpc.changeLevel(nextValue);
        });
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getSelectedLevelProvider(), (IValueReceiver)levelSelect));
        root.addComponent((BaseComponent)levelSelect);
    }

    protected GuiComponentTab createTab(TileEntityAutoEnchantmentTable.AutoSlots slot) {
        switch (slot) {
            case toolInput: {
                return new GuiComponentTab(StandardPalette.blue.getColor(), new ItemStack(Items.field_151046_w, 1), 100, 100);
            }
            case lapisInput: {
                return new GuiComponentTab(StandardPalette.blue.getColor(), new ItemStack(Items.field_151100_aR, 1, 4), 100, 100);
            }
            case output: {
                ItemStack enchantedAxe = new ItemStack(Items.field_151046_w, 1);
                enchantedAxe.func_77966_a(Enchantments.field_185308_t, 1);
                return new GuiComponentTab(StandardPalette.lightblue.getColor(), enchantedAxe, 100, 100);
            }
            case xp: {
                return new GuiComponentTab(StandardPalette.green.getColor(), new ItemStack(Items.field_151133_ar, 1), 100, 100);
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    protected GuiComponentLabel createLabel(TileEntityAutoEnchantmentTable.AutoSlots slot) {
        switch (slot) {
            case toolInput: 
            case lapisInput: {
                return new GuiComponentLabel(22, 82, TranslationUtils.translateToLocal((String)"openblocks.gui.autoextract"));
            }
            case output: {
                return new GuiComponentLabel(22, 82, TranslationUtils.translateToLocal((String)"openblocks.gui.autoeject"));
            }
            case xp: {
                return new GuiComponentLabel(22, 82, TranslationUtils.translateToLocal((String)"openblocks.gui.autodrink"));
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }
}

