/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.common.entity.EntityGoldenEye;
import openmods.utils.ItemUtils;
import openmods.utils.TranslationUtils;
import openmods.world.StructureRegistry;

public class ItemGoldenEye
extends Item {
    public static final int MAX_DAMAGE = 100;
    private static final String TAG_STRUCTURE = "Structure";
    private static final String TAG_X = "X";
    private static final String TAG_Y = "Y";
    private static final String TAG_Z = "Z";

    public ItemGoldenEye() {
        this.func_77656_e(100);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && world instanceof WorldServer && player instanceof EntityPlayerMP) {
            EntityPlayerMP betterPlayer = (EntityPlayerMP)player;
            WorldServer betterWorld = (WorldServer)world;
            if (player.func_70093_af()) {
                ItemGoldenEye.tryLearnStructure(stack, betterWorld, betterPlayer);
            } else if (ItemGoldenEye.trySpawnEntity(stack, betterWorld, betterPlayer)) {
                stack.func_190920_e(0);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    private static void tryLearnStructure(@Nonnull ItemStack stack, WorldServer world, EntityPlayerMP player) {
        Map nearbyStructures = StructureRegistry.instance.getNearestStructures(world, player.func_180425_c());
        String newStructureName = "";
        BlockPos newStructurePos = null;
        double max = Double.MAX_VALUE;
        for (Map.Entry e : nearbyStructures.entrySet()) {
            double distSq;
            BlockPos pos = (BlockPos)e.getValue();
            if (Config.eyeDebug) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.structure_pos", new Object[]{e.getKey(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            }
            if (!((distSq = player.func_174831_c(pos)) < max)) continue;
            max = distSq;
            newStructureName = (String)e.getKey();
            newStructurePos = pos;
        }
        if (!Strings.isNullOrEmpty((String)newStructureName) && newStructurePos != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.locked_on_nearest_structure", new Object[]{new TextComponentTranslation(StructureRegistry.structureNameLocalizationKey((String)newStructureName), new Object[0])}));
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74778_a(TAG_STRUCTURE, newStructureName);
            tag.func_74768_a(TAG_X, newStructurePos.func_177958_n());
            tag.func_74768_a(TAG_Y, newStructurePos.func_177956_o());
            tag.func_74768_a(TAG_Z, newStructurePos.func_177952_p());
            if (Config.eyeDebug) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.structure_pos", new Object[]{newStructureName, newStructurePos.func_177958_n(), newStructurePos.func_177956_o(), newStructurePos.func_177952_p()}));
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.no_nearby_structures", new Object[0]));
        }
    }

    private static boolean trySpawnEntity(@Nonnull ItemStack stack, WorldServer world, EntityPlayerMP player) {
        int damage = stack.func_77952_i();
        if (damage >= stack.func_77958_k()) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (!(tag.func_150297_b(TAG_X, 99) && tag.func_150297_b(TAG_Y, 99) && tag.func_150297_b(TAG_Z, 99))) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.structure_not_locked", new Object[0]));
            return false;
        }
        int x = tag.func_74762_e(TAG_X);
        int y = tag.func_74762_e(TAG_Y);
        int z = tag.func_74762_e(TAG_Z);
        BlockPos structurePos = new BlockPos(x, y, z);
        stack.func_77964_b(damage + 1);
        EntityGoldenEye eye = new EntityGoldenEye((World)world, stack, (Entity)player, structurePos);
        world.func_72838_d((Entity)eye);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187528_aR, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            result.add((Object)new ItemStack((Item)this, 1, 0));
            result.add((Object)new ItemStack((Item)this, 1, 100));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> result, ITooltipFlag flag) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (tag.func_150297_b(TAG_STRUCTURE, 8)) {
            String structure = tag.func_74779_i(TAG_STRUCTURE);
            String localizedStructure = TranslationUtils.translateToLocal((String)StructureRegistry.structureNameLocalizationKey((String)structure));
            result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.locked_on_structure", (Object[])new Object[]{localizedStructure}));
        }
    }
}

