/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiAutoEnchantmentTable;
import openblocks.common.LiquidXpUtils;
import openblocks.common.container.ContainerAutoEnchantmentTable;
import openblocks.rpc.ILevelChanger;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.gui.misc.IConfigurableGuiSlots;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.ItemMover;
import openmods.inventory.TileEntityInventory;
import openmods.liquids.SidedFluidCapabilityWrapper;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableEnum;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableSides;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.MiscUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.SidedItemHandlerAdapter;
import openmods.utils.VanillaEnchantLogic;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityAutoEnchantmentTable
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IConfigurableGuiSlots<AutoSlots>,
ILevelChanger,
INeighbourAwareTile,
ITickable {
    private static final String TAG_SEED = "Seed";
    public static final int MAX_STORED_LEVELS = 30;
    public static final int TANK_CAPACITY = LiquidXpUtils.getLiquidForLevel(30);
    private SyncableTank tank;
    private SyncableSides inputSides;
    private SyncableSides lapisSides;
    private SyncableSides outputSides;
    private SyncableSides xpSides;
    private SyncableFlags automaticSlots;
    private SyncableInt powerLimit;
    private SyncableInt availablePower;
    private SyncableEnum<VanillaEnchantLogic.Level> selectedLevel;
    private long seed;
    private static final int POWER_CHECK_PERIOD = 20;
    private int powerCheckCountdown = 0;
    private boolean needsTankUpdate;
    private final GenericInventory inventory = new TileEntityInventory((TileEntity)this, "autoenchant", true, 3){
        final List<ItemStack> lapis;
        {
            this.lapis = OreDictionary.getOres((String)"gemLapis");
        }

        public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
            if (slot == Slots.tool.ordinal()) {
                return itemstack.func_77956_u();
            }
            if (slot == Slots.lapis.ordinal()) {
                for (ItemStack ore : this.lapis) {
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)itemstack, (boolean)false)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    };
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter slotSides = new SidedInventoryAdapter((IInventory)this.inventory);
    private final SidedFluidCapabilityWrapper tankCapability = SidedFluidCapabilityWrapper.wrap((IFluidHandler)this.tank, (IReadableBitMap)this.xpSides, (boolean)false, (boolean)true);
    private final SidedItemHandlerAdapter itemHandlerCapability = new SidedItemHandlerAdapter(this.inventory.getHandler());
    private static final Random bookRand = new Random();
    private static final Random seedGenerator = new Random();
    public final BookState bookState = new BookState();

    public TileEntityAutoEnchantmentTable() {
        this.slotSides.registerSlot((Enum)Slots.tool, (IReadableBitMap)this.inputSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.lapis, (IReadableBitMap)this.lapisSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.output, (IReadableBitMap)this.outputSides, false, true);
        this.itemHandlerCapability.registerSlot((Enum)Slots.tool, (IReadableBitMap)this.inputSides, true, false);
        this.itemHandlerCapability.registerSlot((Enum)Slots.lapis, (IReadableBitMap)this.lapisSides, true, false);
        this.itemHandlerCapability.registerSlot((Enum)Slots.output, (IReadableBitMap)this.outputSides, false, true);
        this.seed = seedGenerator.nextLong();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankCapability.hasHandler(facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.hasHandler(facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tankCapability.getHandler(facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerCapability.getHandler(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TANK_CAPACITY, new Fluid[]{OpenBlocks.Fluids.xpJuice});
        this.inputSides = new SyncableSides();
        this.outputSides = new SyncableSides();
        this.xpSides = new SyncableSides();
        this.lapisSides = new SyncableSides();
        this.powerLimit = new SyncableInt(1);
        this.availablePower = new SyncableInt();
        this.selectedLevel = new SyncableEnum((Enum)VanillaEnchantLogic.Level.L1);
        this.automaticSlots = SyncableFlags.create((int)AutoSlots.values().length);
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addSyncListener(this.itemHandlerCapability.createSyncListener());
    }

    public void func_73660_a() {
        this.bookState.handleBookRotation();
        if (!this.field_145850_b.field_72995_K) {
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                if (this.needsTankUpdate) {
                    this.tank.updateNeighbours(this.field_145850_b, this.field_174879_c);
                    this.needsTankUpdate = false;
                }
                this.tank.fillFromSides(80, this.field_145850_b, this.field_174879_c, this.xpSides.getValue());
            }
            if (this.powerCheckCountdown-- <= 0) {
                this.powerCheckCountdown = 20;
                int power = (int)EnchantmentUtils.getPower((World)this.field_145850_b, (BlockPos)this.func_174877_v());
                this.availablePower.set(power);
            }
            ItemMover mover = new ItemMover(this.field_145850_b, this.field_174879_c).breakAfterFirstTry().randomizeSides().setMaxSize(1);
            if (this.shouldAutoOutput() && this.hasStack(Slots.output)) {
                mover.setSides(this.outputSides.getValue()).pushFromSlot((IItemHandler)this.inventory.getHandler(), Slots.output.ordinal());
            }
            if (this.shouldAutoInputTool() && this.hasSpace(Slots.tool)) {
                mover.setSides(this.inputSides.getValue()).pullToSlot((IItemHandler)this.inventory.getHandler(), Slots.tool.ordinal());
            }
            if (this.shouldAutoInputLapis() && this.hasSpace(Slots.lapis)) {
                mover.setSides(this.lapisSides.getValue()).pullToSlot((IItemHandler)this.inventory.getHandler(), Slots.lapis.ordinal());
            }
            this.tryEnchantItem();
            this.sync();
        }
    }

    private void tryEnchantItem() {
        ItemStack tool = this.getStack(Slots.tool);
        if (tool.func_190926_b() || !tool.func_77956_u()) {
            return;
        }
        ItemStack lapis = this.getStack(Slots.lapis);
        if (lapis.func_190926_b()) {
            return;
        }
        if (this.hasStack(Slots.output)) {
            return;
        }
        int power = Math.min(this.availablePower.get(), this.powerLimit.get());
        if (power <= 0) {
            return;
        }
        VanillaEnchantLogic logic = new VanillaEnchantLogic(this.seed);
        if (!logic.setup(tool, (VanillaEnchantLogic.Level)this.selectedLevel.get(), power)) {
            return;
        }
        if (lapis.func_190916_E() < logic.getLapisCost()) {
            return;
        }
        int levelsRequirement = logic.getLevelRequirement();
        int availableXp = LiquidXpUtils.liquidToXpRatio(this.tank.getFluidAmount());
        int availableLevels = EnchantmentUtils.getLevelForExperience((int)availableXp);
        if (availableLevels < levelsRequirement) {
            return;
        }
        int xpCost = EnchantmentUtils.getExperienceForLevel((int)levelsRequirement) - EnchantmentUtils.getExperienceForLevel((int)(levelsRequirement - logic.getLevelCost()));
        int liquidXpCost = LiquidXpUtils.xpToLiquidRatio(xpCost);
        FluidStack drainedXp = this.tank.drain(liquidXpCost, false);
        if (drainedXp == null || drainedXp.amount < xpCost) {
            return;
        }
        this.setStack(Slots.output, logic.enchant());
        this.setStack(Slots.tool, ItemStack.field_190927_a);
        this.decrementStack(Slots.lapis, logic.getLapisCost());
        this.tank.drain(liquidXpCost, true);
        this.seed = seedGenerator.nextLong();
    }

    private boolean shouldAutoInputLapis() {
        return this.automaticSlots.get((Enum)AutoSlots.lapisInput);
    }

    private boolean shouldAutoInputTool() {
        return this.automaticSlots.get((Enum)AutoSlots.toolInput);
    }

    private boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    private boolean hasStack(Slots slot) {
        return !this.getStack(slot).func_190926_b();
    }

    private boolean hasSpace(Slots slot) {
        ItemStack stackInSlot = this.getStack(slot);
        return stackInSlot.func_190916_E() < stackInSlot.func_77976_d();
    }

    public void setStack(Slots slot, @Nonnull ItemStack stack) {
        this.inventory.func_70299_a(slot.ordinal(), stack);
    }

    private void decrementStack(Slots slot, int amount) {
        ItemStack stack = this.getStack(slot);
        stack.func_190918_g(amount);
        this.func_70296_d();
    }

    @Nonnull
    private ItemStack getStack(Slots slot) {
        return this.inventory.getStackInSlot((Enum)slot);
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerAutoEnchantmentTable((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiAutoEnchantmentTable(new ContainerAutoEnchantmentTable((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    public IInventory getInventory() {
        return this.slotSides;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        tag.func_74772_a(TAG_SEED, this.seed);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.seed = tag.func_74763_f(TAG_SEED);
        this.inventory.readFromNBT(tag, false);
    }

    private SyncableSides selectSlotMap(AutoSlots slot) {
        switch (slot) {
            case toolInput: {
                return this.inputSides;
            }
            case output: {
                return this.outputSides;
            }
            case xp: {
                return this.xpSides;
            }
            case lapisInput: {
                return this.lapisSides;
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    public IValueProvider<Set<EnumFacing>> createAllowedDirectionsProvider(AutoSlots slot) {
        return this.selectSlotMap(slot);
    }

    public IWriteableBitMap<EnumFacing> createAllowedDirectionsReceiver(AutoSlots slot) {
        SyncableSides dirs = this.selectSlotMap(slot);
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)dirs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<Boolean> createAutoFlagProvider(AutoSlots slot) {
        return BitMapUtils.singleBitProvider((IReadableBitMap)this.automaticSlots, (Object)slot.ordinal());
    }

    public IValueReceiver<Boolean> createAutoSlotReceiver(AutoSlots slot) {
        IRpcIntBitMap bits = (IRpcIntBitMap)this.createRpcProxy((ISyncableObject)this.automaticSlots, IRpcIntBitMap.class, new Class[0]);
        return BitMapUtils.singleBitReceiver((IRpcIntBitMap)bits, (int)slot.ordinal());
    }

    @Override
    public void changePowerLimit(int powerLimit) {
        this.powerLimit.set(powerLimit);
        this.sync();
    }

    @Override
    public void changeLevel(VanillaEnchantLogic.Level level) {
        this.selectedLevel.set((Enum)level);
        this.sync();
    }

    public IValueProvider<Integer> getLevelProvider() {
        return this.powerLimit;
    }

    public IValueProvider<Integer> getAvailablePowerProvider() {
        return this.availablePower;
    }

    public IValueProvider<VanillaEnchantLogic.Level> getSelectedLevelProvider() {
        return this.selectedLevel;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.needsTankUpdate = true;
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.needsTankUpdate = true;
    }

    public class BookState {
        public int tickCount;
        public float pageFlip;
        public float pageFlipPrev;
        public float flipT;
        public float flipA;
        public float bookSpread;
        public float bookSpreadPrev;
        public float bookRotation;
        public float bookRotationPrev;
        public float tRot;

        public void handleBookRotation() {
            float f2;
            this.bookSpreadPrev = this.bookSpread;
            this.bookRotationPrev = this.bookRotation;
            EntityPlayer entityplayer = TileEntityAutoEnchantmentTable.this.field_145850_b.func_184137_a((double)((float)TileEntityAutoEnchantmentTable.this.field_174879_c.func_177958_n() + 0.5f), (double)((float)TileEntityAutoEnchantmentTable.this.field_174879_c.func_177956_o() + 0.5f), (double)((float)TileEntityAutoEnchantmentTable.this.field_174879_c.func_177952_p() + 0.5f), 3.0, false);
            if (entityplayer != null) {
                double d0 = entityplayer.field_70165_t - (double)((float)TileEntityAutoEnchantmentTable.this.field_174879_c.func_177958_n() + 0.5f);
                double d1 = entityplayer.field_70161_v - (double)((float)TileEntityAutoEnchantmentTable.this.field_174879_c.func_177952_p() + 0.5f);
                this.tRot = (float)MathHelper.func_181159_b((double)d1, (double)d0);
                this.bookSpread += 0.1f;
                if (this.bookSpread < 0.5f || bookRand.nextInt(40) == 0) {
                    float f1 = this.flipT;
                    do {
                        this.flipT += (float)(bookRand.nextInt(4) - bookRand.nextInt(4));
                    } while (f1 == this.flipT);
                }
            } else {
                this.tRot += 0.02f;
                this.bookSpread -= 0.1f;
            }
            while (this.bookRotation >= (float)Math.PI) {
                this.bookRotation -= (float)Math.PI * 2;
            }
            while (this.bookRotation < (float)(-Math.PI)) {
                this.bookRotation += (float)Math.PI * 2;
            }
            while (this.tRot >= (float)Math.PI) {
                this.tRot -= (float)Math.PI * 2;
            }
            while (this.tRot < (float)(-Math.PI)) {
                this.tRot += (float)Math.PI * 2;
            }
            for (f2 = this.tRot - this.bookRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
            }
            while (f2 < (float)(-Math.PI)) {
                f2 += (float)Math.PI * 2;
            }
            this.bookRotation += f2 * 0.4f;
            this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
            ++this.tickCount;
            this.pageFlipPrev = this.pageFlip;
            float f = (this.flipT - this.pageFlip) * 0.4f;
            f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
            this.flipA += (f - this.flipA) * 0.9f;
            this.pageFlip += this.flipA;
        }
    }

    public static enum AutoSlots {
        toolInput,
        lapisInput,
        output,
        xp;

    }

    public static enum Slots {
        tool,
        output,
        lapis;

    }
}

