/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Random;
import lex.config.Config;
import lex.util.NumberHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class Feature
extends WorldGenerator {
    protected int genAttempts;
    protected float genProbability;
    protected boolean randomizeGenAttempts;
    protected int minGenHeight;
    protected int maxGenHeight;

    public Feature(Config config) {
        this.genAttempts = config.getInt("genAttempts", 4);
        this.genProbability = config.getFloat("genProbability", 1.0f);
        this.randomizeGenAttempts = config.getBoolean("randomizeGenAttempts", false);
        if (config.hasData("minHeight")) {
            this.minGenHeight = config.getInt("minHeight");
            config.removeData("minHeight");
            config.addData("minGenHeight", (JsonElement)new JsonPrimitive((Number)this.minGenHeight));
        } else {
            this.minGenHeight = config.getInt("minGenHeight", 0);
        }
        if (config.hasData("maxHeight")) {
            this.maxGenHeight = config.getInt("maxHeight");
            config.removeData("maxHeight");
            config.addData("maxGenHeight", (JsonElement)new JsonPrimitive((Number)this.maxGenHeight));
        } else {
            this.maxGenHeight = config.getInt("maxGenHeight", 255);
        }
    }

    public Feature(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight) {
        this.genAttempts = genAttempts;
        this.genProbability = genProbability;
        this.randomizeGenAttempts = randomizeGenAttempts;
        this.minGenHeight = minGenHeight;
        this.maxGenHeight = maxGenHeight;
    }

    public abstract boolean func_180709_b(World var1, Random var2, BlockPos var3);

    public int getGenAttempts() {
        return this.genAttempts;
    }

    public int getGenAttempts(Random rand) {
        int attempts = this.genAttempts;
        if (this.genProbability > 0.0f && this.genProbability < 1.0f && rand.nextFloat() > this.genProbability) {
            attempts = 0;
        }
        if (this.randomizeGenAttempts) {
            attempts = NumberHelper.getNumberInRange(1, attempts, rand);
        }
        return attempts;
    }

    public float getGenProbability() {
        return this.genProbability;
    }

    public boolean randomizeGenAttempts() {
        return this.randomizeGenAttempts;
    }

    public int getMinHeight() {
        return this.minGenHeight;
    }

    public int getMaxHeight() {
        return this.maxGenHeight;
    }
}

