/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.util.Random;
import lex.config.Config;
import lex.util.BlockHelper;
import lex.util.NumberHelper;
import lex.world.gen.feature.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FeatureOakTree
extends Feature {
    private IBlockState logBlock;
    private IBlockState leafBlock;
    private int minGrowthHeight;
    private int maxGrowthHeight;

    public FeatureOakTree(Config config) {
        super(config);
        this.logBlock = config.getBlock("logBlock", Blocks.field_180401_cv.func_176223_P());
        this.leafBlock = config.getBlock("leafBlock", Blocks.field_180401_cv.func_176223_P());
        this.minGrowthHeight = config.getInt("minGrowthHeight", 2);
        this.maxGrowthHeight = config.getInt("maxGrowthHeight", 32);
    }

    public FeatureOakTree(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, IBlockState logBlock, IBlockState leafBlock, int minGrowthHeight, int maxGrowthHeight) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.logBlock = logBlock;
        this.leafBlock = leafBlock;
        this.minGrowthHeight = minGrowthHeight;
        this.maxGrowthHeight = maxGrowthHeight;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = NumberHelper.getNumberInRange(this.minGrowthHeight, this.maxGrowthHeight, rand);
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.func_72800_K()) {
            for (int posY = pos.func_177956_o(); posY <= pos.func_177956_o() + 1 + height; ++posY) {
                int k = 1;
                if (posY == pos.func_177956_o()) {
                    k = 0;
                }
                if (posY >= pos.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int posX = pos.func_177958_n() - k; posX <= pos.func_177958_n() + k && flag; ++posX) {
                    for (int posZ = pos.func_177952_p() - k; posZ <= pos.func_177952_p() + k && flag; ++posZ) {
                        if (posY >= 0 && posY < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)mutablePos.func_181079_c(posX, posY, posZ))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState checkState = world.func_180495_p(pos.func_177977_b());
            if (BlockHelper.isOreDict("endstone", checkState.func_177230_c()) && pos.func_177956_o() < world.func_72800_K() - height - 1) {
                checkState.func_177230_c().onPlantGrow(checkState, world, pos.func_177977_b(), pos);
                for (int checkPosY = pos.func_177956_o() - 3 + height; checkPosY <= pos.func_177956_o() + height; ++checkPosY) {
                    int i4 = checkPosY - (pos.func_177956_o() + height);
                    int j1 = 1 - i4 / 2;
                    for (int checkPosX = pos.func_177958_n() - j1; checkPosX <= pos.func_177958_n() + j1; ++checkPosX) {
                        int l1 = checkPosX - pos.func_177958_n();
                        for (int checkPosZ = pos.func_177952_p() - j1; checkPosZ <= pos.func_177952_p() + j1; ++checkPosZ) {
                            BlockPos checkPos;
                            int j2 = checkPosZ - pos.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(checkState = world.func_180495_p(checkPos = new BlockPos(checkPosX, checkPosY, checkPosZ))).func_177230_c().isAir(checkState, (IBlockAccess)world, checkPos) && !checkState.func_177230_c().isLeaves(checkState, (IBlockAccess)world, checkPos) && checkState.func_185904_a() != Material.field_151582_l) continue;
                            this.func_175903_a(world, checkPos, this.leafBlock);
                        }
                    }
                }
                for (int heightOffset = 0; heightOffset < height; ++heightOffset) {
                    BlockPos offsetPos = pos.func_177981_b(heightOffset);
                    checkState = world.func_180495_p(offsetPos);
                    if (!checkState.func_177230_c().isAir(checkState, (IBlockAccess)world, offsetPos) && !checkState.func_177230_c().isLeaves(checkState, (IBlockAccess)world, offsetPos) && checkState.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(world, pos.func_177981_b(heightOffset), this.logBlock);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.canGrowInto(state.func_177230_c());
    }
}

