/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.util.Random;
import lex.config.Config;
import lex.world.gen.feature.Feature;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FeatureScatter
extends Feature {
    private IBlockState blockToSpawn;
    private IBlockState blockToTarget;
    private Placement placement;

    public FeatureScatter(Config config) {
        super(config);
        this.blockToSpawn = config.getBlock("blockToSpawn", Blocks.field_180401_cv.func_176223_P());
        this.blockToTarget = config.getBlock("blockToTarget", Blocks.field_180401_cv.func_176223_P());
        this.placement = config.getEnum("placement", Placement.class, Placement.ON_GROUND);
    }

    public FeatureScatter(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, IBlockState blockToSpawn, IBlockState blockToTarget, Placement placement) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.blockToSpawn = blockToSpawn;
        this.blockToTarget = blockToTarget;
        this.placement = placement;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.blockToSpawn.func_177230_c() == Blocks.field_180401_cv || this.blockToTarget.func_177230_c() == Blocks.field_180401_cv) {
            return false;
        }
        for (int i = 0; i < 64; ++i) {
            BlockPos newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d(newPos) || world.func_180495_p(newPos.func_177977_b()) != this.blockToTarget) continue;
            if (this.blockToSpawn instanceof BlockBush) {
                if (!((BlockBush)this.blockToSpawn).func_180671_f(world, this.placement.offsetPos(pos), this.blockToSpawn)) continue;
                world.func_180501_a(this.placement.offsetPos(newPos), this.blockToSpawn, 2);
                continue;
            }
            world.func_180501_a(this.placement.offsetPos(newPos), this.blockToSpawn, 2);
        }
        return true;
    }

    public static enum Placement {
        ON_GROUND(null),
        IN_GROUND(EnumFacing.DOWN);

        EnumFacing offset;

        private Placement(EnumFacing offsetIn) {
            this.offset = offsetIn;
        }

        public BlockPos offsetPos(BlockPos pos) {
            if (this.offset != null) {
                return pos.func_177972_a(this.offset);
            }
            return pos;
        }
    }
}

