/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CTMTransformer
implements IClassTransformer {
    private static final String BLOCK_CLASS = "net.minecraft.block.Block";
    private static final String EXTENDED_STATE_METHOD_NAME = "getExtendedState";
    private static final String CAN_RENDER_IN_LAYER_METHOD_NAME = "canRenderInLayer";
    private static final String CAN_RENDER_IN_LAYER_METHOD_DESC = "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockRenderLayer;)Z";
    private static final String WRAPPER_CLASS_NAME = "team/chisel/ctm/client/state/CTMExtendedState";
    private static final String WRAPPER_CLASS_CONSTRUCTOR_NAME = "<init>";
    private static final String WRAPPER_CLASS_CONSTRUCTOR_DESC = "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)V";
    private static final String CHISEL_METHODS_CLASS_NAME = "team/chisel/ctm/client/asm/CTMCoreMethods";
    private static final String CHISEL_METHODS_LAYER_NAME = "canRenderInLayer";
    private static final String CHISEL_METHODS_LAYER_DESC = "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/BlockRenderLayer;)Ljava/lang/Boolean;";
    private static final String CHISEL_METHODS_DAMAGE_PRE_NAME = "preDamageModel";
    private static final String CHISEL_METHODS_DAMAGE_POST_NAME = "postDamageModel";
    private static final String CHISEL_METHODS_TRANFORM_PARENT_NAME = "transformParent";
    private static final String CHISEL_METHODS_TRANFORM_PARENT_DESC = "(Lnet/minecraftforge/client/model/IModel;)Lnet/minecraftforge/client/model/IModel;";
    private static final String FORGE_HOOKS_CLIENT_CLASS = "net.minecraftforge.client.ForgeHooksClient";
    private static final String DAMAGE_MODEL_METHOD_NAME = "getDamageModel";
    private static final String VANILLA_MODEL_WRAPPER_CLASS = "net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper";
    private static final String GET_TEXTURES_METHOD_NAME = "getTextures";
    private static final String TEXTURE_ATLAS_SPRITE_CLASS = "net.minecraft.client.renderer.texture.TextureAtlasSprite";
    private static final String UPDATE_ANIMATION_INTERPOLATED_METHOD_NAME = "updateAnimationInterpolated";
    private static final String INTERPOLATE_COLOR_CLASS = "net.minecraft.client.renderer.texture.TextureAtlasSprite".replace('.', '/');
    private static final String INTERPOLATE_COLOR_NAME = "interpolateColor";
    private static final String INTERPOLATE_COLOR_DESC = "(DII)I";
    private static final String TEXTURE_MAP_CLASS_NAME = "net.minecraft.client.renderer.texture.TextureMap";
    private static final String REGISTER_SPRITE_OBF_NAME = "func_174942_a";
    private static final String REGISTER_SPRITE_NAME = "registerSprite";
    private static final String CHISEL_METHODS_SPRITE_REGISTER_NAME = "onSpriteRegister";
    private static final String CHISEL_METHODS_SPRITE_REGISTER_DESC = "(Lnet/minecraft/client/renderer/texture/TextureMap;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(BLOCK_CLASS)) {
            ClassNode classNode = this.preTransform(transformedName, EXTENDED_STATE_METHOD_NAME, basicClass);
            block0: for (MethodNode m : classNode.methods) {
                if (m.name.equals(EXTENDED_STATE_METHOD_NAME)) {
                    for (int i = 0; i < m.instructions.size(); ++i) {
                        AbstractInsnNode next = m.instructions.get(i);
                        if (!(next instanceof InsnNode) || ((InsnNode)next).getOpcode() != 176) continue;
                        InsnList toAdd = new InsnList();
                        AbstractInsnNode load = m.instructions.get(i - 1);
                        int var = ((VarInsnNode)load).var;
                        toAdd.add((AbstractInsnNode)new InsnNode(87));
                        toAdd.add((AbstractInsnNode)new TypeInsnNode(187, WRAPPER_CLASS_NAME));
                        toAdd.add((AbstractInsnNode)new InsnNode(89));
                        toAdd.add((AbstractInsnNode)new VarInsnNode(25, var));
                        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        toAdd.add((AbstractInsnNode)new VarInsnNode(25, 3));
                        toAdd.add((AbstractInsnNode)new MethodInsnNode(183, WRAPPER_CLASS_NAME, WRAPPER_CLASS_CONSTRUCTOR_NAME, WRAPPER_CLASS_CONSTRUCTOR_DESC, false));
                        m.instructions.insertBefore(next, toAdd);
                        continue block0;
                    }
                    continue;
                }
                if (!m.name.equals("canRenderInLayer") || !m.desc.equals(CAN_RENDER_IN_LAYER_METHOD_DESC)) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CHISEL_METHODS_CLASS_NAME, "canRenderInLayer", CHISEL_METHODS_LAYER_DESC, false));
                toAdd.add((AbstractInsnNode)new InsnNode(89));
                toAdd.add((AbstractInsnNode)new JumpInsnNode(198, (LabelNode)m.instructions.getFirst()));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
                toAdd.add((AbstractInsnNode)new InsnNode(172));
                AbstractInsnNode first = m.instructions.getFirst();
                m.instructions.insertBefore(first, toAdd);
                m.instructions.insert(first, (AbstractInsnNode)new InsnNode(87));
            }
            return this.finishTransform(transformedName, classNode, 3);
        }
        if (transformedName.equals(FORGE_HOOKS_CLIENT_CLASS)) {
            ClassNode classNode = this.preTransform(transformedName, DAMAGE_MODEL_METHOD_NAME, basicClass);
            for (MethodNode m : classNode.methods) {
                if (!m.name.equals(DAMAGE_MODEL_METHOD_NAME)) continue;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode next = m.instructions.get(i);
                    String methodName = null;
                    if (next.getOpcode() == 187) {
                        methodName = CHISEL_METHODS_DAMAGE_PRE_NAME;
                    } else if (next.getOpcode() == 176) {
                        methodName = CHISEL_METHODS_DAMAGE_POST_NAME;
                    }
                    if (methodName == null) continue;
                    m.instructions.insertBefore(next, (AbstractInsnNode)new MethodInsnNode(184, CHISEL_METHODS_CLASS_NAME, methodName, "()V", false));
                    ++i;
                }
            }
            return this.finishTransform(transformedName, classNode, 1);
        }
        if (transformedName.equals(TEXTURE_MAP_CLASS_NAME)) {
            ClassNode classNode = this.preTransform(transformedName, REGISTER_SPRITE_NAME, basicClass);
            block4: for (MethodNode m : classNode.methods) {
                if (!m.name.equals(REGISTER_SPRITE_NAME) && !m.name.equals(REGISTER_SPRITE_OBF_NAME)) continue;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode next = m.instructions.get(i);
                    if (next.getOpcode() != 184 || (next = next.getNext()).getOpcode() != 58 || ((VarInsnNode)next).var != 2) continue;
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, CHISEL_METHODS_CLASS_NAME, CHISEL_METHODS_SPRITE_REGISTER_NAME, CHISEL_METHODS_SPRITE_REGISTER_DESC, false));
                    m.instructions.insert(next, toInsert);
                    continue block4;
                }
            }
            return this.finishTransform(transformedName, classNode, 1);
        }
        if (transformedName.equals(VANILLA_MODEL_WRAPPER_CLASS)) {
            ClassNode classNode = this.preTransform(transformedName, GET_TEXTURES_METHOD_NAME, basicClass);
            block6: for (MethodNode m : classNode.methods) {
                if (!m.name.equals(GET_TEXTURES_METHOD_NAME)) continue;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode next = m.instructions.get(i);
                    if (next.getOpcode() != 58 || ((VarInsnNode)next).var != 1) continue;
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, CHISEL_METHODS_CLASS_NAME, CHISEL_METHODS_TRANFORM_PARENT_NAME, CHISEL_METHODS_TRANFORM_PARENT_DESC, false));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(58, 1));
                    m.instructions.insert(next, toInsert);
                    continue block6;
                }
            }
            return this.finishTransform(transformedName, classNode, 1);
        }
        if (transformedName.equals(TEXTURE_ATLAS_SPRITE_CLASS)) {
            ClassNode classNode = this.preTransform(transformedName, UPDATE_ANIMATION_INTERPOLATED_METHOD_NAME, basicClass);
            block8: for (MethodNode m : classNode.methods) {
                if (!m.name.equals(UPDATE_ANIMATION_INTERPOLATED_METHOD_NAME)) continue;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode next = m.instructions.get(i);
                    if (next.getOpcode() != 18 || !((LdcInsnNode)next).cst.equals(-16777216)) continue;
                    m.instructions.remove(next.getPrevious());
                    m.instructions.remove(next.getNext());
                    next = next.getNext();
                    m.instructions.remove(next.getPrevious());
                    next = next.getPrevious();
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(24, 1));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(21, 10));
                    toInsert.add((AbstractInsnNode)new IntInsnNode(16, 24));
                    toInsert.add((AbstractInsnNode)new InsnNode(124));
                    toInsert.add((AbstractInsnNode)new VarInsnNode(21, 11));
                    toInsert.add((AbstractInsnNode)new IntInsnNode(16, 24));
                    toInsert.add((AbstractInsnNode)new InsnNode(124));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(183, INTERPOLATE_COLOR_CLASS, INTERPOLATE_COLOR_NAME, INTERPOLATE_COLOR_DESC, false));
                    toInsert.add((AbstractInsnNode)new IntInsnNode(16, 24));
                    toInsert.add((AbstractInsnNode)new InsnNode(120));
                    m.instructions.insert(next, toInsert);
                    continue block8;
                }
            }
            return this.finishTransform(transformedName, classNode, 1);
        }
        return basicClass;
    }

    private ClassNode preTransform(String transformedName, String methodName, byte[] basicClass) {
        System.out.println("Transforming Class [" + transformedName + "], Method [" + methodName + "]");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] finishTransform(String transformedName, ClassNode classNode, int flags) {
        ClassWriter cw = new ClassWriter(flags);
        classNode.accept((ClassVisitor)cw);
        System.out.println("Transforming " + transformedName + " Finished.");
        return cw.toByteArray();
    }
}

