/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.gui;

import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IWindowElement;
import forestry.api.gui.events.GuiElementEvent;
import forestry.api.gui.events.GuiEventDestination;
import forestry.api.gui.events.GuiEventHandler;
import forestry.api.gui.events.GuiEventOrigin;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public interface IGuiElement {
    public int getX();

    public int getY();

    public IGuiElement setAlign(GuiElementAlignment var1);

    public GuiElementAlignment getAlign();

    public IWindowElement getWindow();

    public int getAbsoluteX();

    public int getAbsoluteY();

    public int getWidth();

    public void setWidth(int var1);

    public int getHeight();

    public void setHeight(int var1);

    public IGuiElement setSize(int var1, int var2);

    public IGuiElement setLocation(int var1, int var2);

    public IGuiElement setOffset(int var1, int var2);

    public IGuiElement setBounds(int var1, int var2, int var3, int var4);

    public void setXPosition(int var1);

    public void setYPosition(int var1);

    public void setCroppedZone(@Nullable IGuiElement var1, int var2, int var3, int var4, int var5);

    @Nullable
    public IGuiElement getCropElement();

    public int getCropX();

    public int getCropY();

    public int getCropWidth();

    public int getCropHeight();

    public boolean isCropped();

    @Nullable
    public IGuiElement getParent();

    public IGuiElement setParent(@Nullable IGuiElement var1);

    public void onCreation();

    public void onDeletion();

    public void draw(int var1, int var2);

    public void drawElement(int var1, int var2);

    public boolean isMouseOver(int var1, int var2);

    public boolean isMouseOver();

    default public boolean canMouseOver() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient();

    default public boolean canFocus() {
        return false;
    }

    public boolean isVisible();

    public void show();

    public void hide();

    public boolean isEnabled();

    public IGuiElement addTooltip(String var1);

    public IGuiElement addTooltip(Collection<String> var1);

    public boolean hasTooltip();

    public void clearTooltip();

    public List<String> getTooltip(int var1, int var2);

    public List<String> getTooltip();

    public <E extends GuiElementEvent> void addEventHandler(Consumer<E> var1);

    default public <E extends GuiElementEvent> void addEventHandler(Class<? super E> eventClass, Consumer<E> eventHandler) {
        this.addEventHandler(new GuiEventHandler<E>(eventClass, eventHandler));
    }

    default public <E extends GuiElementEvent> void addEventHandler(Class<? super E> eventClass, GuiEventOrigin origin, IGuiElement relative, Consumer<E> eventHandler) {
        this.addEventHandler(new GuiEventHandler<E>(eventClass, origin, relative, eventHandler));
    }

    default public <E extends GuiElementEvent> void addSelfEventHandler(Class<? super E> eventClass, Consumer<E> eventHandler) {
        this.addEventHandler(new GuiEventHandler<E>(eventClass, GuiEventOrigin.SELF, this, eventHandler));
    }

    default public void postEvent(GuiElementEvent event, GuiEventDestination destination) {
        destination.sendEvent(this, event);
    }

    default public void postEvent(GuiElementEvent event) {
        this.postEvent(event, GuiEventDestination.SINGLE);
    }

    public void receiveEvent(GuiElementEvent var1);
}

