/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.gui.events;

import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiElementEvent;

public enum GuiEventDestination {
    SINGLE{

        @Override
        public void sendEvent(IGuiElement element, GuiElementEvent event) {
            element.receiveEvent(event);
        }
    }
    ,
    ORIGIN{

        @Override
        public void sendEvent(IGuiElement element, GuiElementEvent event) {
            event.getOrigin().receiveEvent(event);
        }
    }
    ,
    CHILDREN{

        @Override
        public void sendEvent(IGuiElement element, GuiElementEvent event) {
            if (!(element instanceof IElementGroup)) {
                return;
            }
            for (IGuiElement child : ((IElementGroup)element).getElements()) {
                child.receiveEvent(event);
            }
        }
    }
    ,
    PARENT{

        @Override
        public void sendEvent(IGuiElement element, GuiElementEvent event) {
            IGuiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            parent.receiveEvent(event);
        }
    }
    ,
    SIBLINGS{

        @Override
        public void sendEvent(IGuiElement element, GuiElementEvent event) {
            IGuiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            parent.postEvent(event, CHILDREN);
        }
    }
    ,
    ALL{

        @Override
        public void sendEvent(IGuiElement element, GuiElementEvent event) {
            element.receiveEvent(event);
            if (!(element instanceof IElementGroup)) {
                return;
            }
            for (IGuiElement child : ((IElementGroup)element).getElements()) {
                child.postEvent(event, ALL);
            }
        }
    };


    public abstract void sendEvent(IGuiElement var1, GuiElementEvent var2);
}

