/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.gui.events;

import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import java.util.List;
import javax.annotation.Nullable;

public enum GuiEventOrigin {
    ANY{

        @Override
        public boolean isOrigin(IGuiElement origin, @Nullable IGuiElement element) {
            return true;
        }
    }
    ,
    SELF{

        @Override
        public boolean isOrigin(IGuiElement origin, @Nullable IGuiElement element) {
            return element == origin;
        }
    }
    ,
    PARENT{

        @Override
        public boolean isOrigin(IGuiElement origin, @Nullable IGuiElement element) {
            return element != null && element.getParent() == origin;
        }
    }
    ,
    DIRECT_CHILD{

        @Override
        public boolean isOrigin(IGuiElement origin, @Nullable IGuiElement element) {
            if (element == null || !(element instanceof IElementGroup)) {
                return false;
            }
            List<IGuiElement> elements = ((IElementGroup)element).getElements();
            return elements.contains(origin);
        }
    };


    public abstract boolean isOrigin(IGuiElement var1, @Nullable IGuiElement var2);
}

