/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.genetics.IGeneticAnalyzer;
import forestry.api.genetics.IGeneticAnalyzerProvider;
import forestry.api.gui.IGuiElement;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.IContainerAnalyzerProvider;
import forestry.core.gui.buttons.GuiToggleButton;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.inventory.watchers.ISlotChangeWatcher;
import forestry.core.tiles.ITitled;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public abstract class GuiAnalyzerProvider<C extends Container>
extends GuiForestryTitled<C>
implements IGeneticAnalyzerProvider,
ISlotChangeWatcher {
    protected static final Drawable SELECTED_COMB_SLOT = new Drawable(GeneticAnalyzer.TEXTURE, 163, 0, 22, 22);
    protected static final Drawable TOGGLE_BUTTON = new Drawable(GeneticAnalyzer.TEXTURE, 35, 166, 18, 20);
    private static boolean analyzerVisible = false;
    public final IGeneticAnalyzer analyzer;
    @Nullable
    private final SlotAnalyzer slotAnalyzer;
    private final int buttonX;
    private final int buttonY;
    private final int screenDistance;
    private final int slots;
    private final int firstSlot;
    protected boolean deactivated;
    private boolean dirtyAnalyzer = false;
    private boolean dirty = true;

    public GuiAnalyzerProvider(String texture, C container, ITitled titled, int buttonX, int buttonY, int slots, int firstSlot) {
        this(texture, container, titled, buttonX, buttonY, 0, false, slots, firstSlot);
    }

    public GuiAnalyzerProvider(String texture, C container, ITitled titled, int buttonX, int buttonY, int screenDistance, boolean hasBoarder, int slots, int firstSlot) {
        super(texture, container, titled);
        IContainerAnalyzerProvider containerAnalyzer;
        Slot slot;
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        this.screenDistance = screenDistance;
        this.slots = slots;
        this.firstSlot = firstSlot;
        this.analyzer = GuiElementFactory.INSTANCE.createAnalyzer(this.window, -189 - screenDistance, 0, hasBoarder, this);
        this.updateVisibility();
        SlotAnalyzer analyzerSlot = null;
        if (container instanceof IContainerAnalyzerProvider && (slot = (containerAnalyzer = (IContainerAnalyzerProvider)container).getAnalyzerSlot()) instanceof SlotAnalyzer) {
            ((SlotAnalyzer)slot).setGui(this);
            analyzerSlot = (SlotAnalyzer)slot;
        }
        this.slotAnalyzer = analyzerSlot;
    }

    protected boolean hasErrors() {
        return false;
    }

    private void updateVisibility() {
        this.analyzer.setVisible(!this.deactivated && analyzerVisible);
    }

    protected abstract void drawSelectedSlot(int var1);

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.analyzer.isVisible()) {
            this.field_147003_i = (this.field_146294_l - this.field_146999_f + this.analyzer.getWidth() + this.screenDistance) / 2;
        }
        this.window.init(this.field_147003_i, this.field_147009_r + (this.field_147000_g - 166) / 2);
        ((GuiToggleButton)this.func_189646_b((GuiButton)new GuiToggleButton((int)0, (int)(this.field_147003_i + this.buttonX), (int)(this.field_147009_r + this.buttonY), (int)18, (int)20, (Drawable)GuiAnalyzerProvider.TOGGLE_BUTTON))).field_146124_l = ((IContainerAnalyzerProvider)this.field_147002_h).getAnalyzerSlot() != null;
        this.dirty = true;
        if (this.slotAnalyzer != null) {
            IGuiElement element = this.analyzer.getItemElement();
            this.slotAnalyzer.setPosition(element.getAbsoluteX() - this.field_147003_i + 6, element.getAbsoluteY() - this.field_147009_r + 9);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean ledger = this.hasErrors();
        if (!this.deactivated && ledger || !ledger && this.deactivated) {
            this.deactivated = ledger;
            this.updateVisibility();
            this.dirtyAnalyzer = true;
        }
        if (this.dirtyAnalyzer) {
            this.field_146292_n.clear();
            this.func_73866_w_();
            this.dirtyAnalyzer = false;
        }
        if (this.dirty) {
            this.analyzer.update();
            this.dirty = false;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiToggleButton) {
            GuiAnalyzerProvider.setAnalyzerVisible(!GuiAnalyzerProvider.isAnalyzerVisible());
            this.updateVisibility();
            this.dirtyAnalyzer = true;
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int selectedSlot;
        super.func_146976_a(f, mouseX, mouseY);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.analyzer.isVisible() && (selectedSlot = this.analyzer.getSelected()) >= 0) {
            this.drawSelectedSlot(selectedSlot);
        }
    }

    protected boolean func_193983_c(int mouseX, int mouseY, int guiLeft, int guiTop) {
        return !this.analyzer.isMouseOver(mouseX, mouseY) && super.func_193983_c(mouseX, mouseY, guiLeft, guiTop);
    }

    @Override
    public void onSlotChanged(IInventory inventory, int slot) {
        if (slot == this.analyzer.getSelected()) {
            this.dirty = true;
        }
    }

    @Override
    public int getSelectedSlot(int index) {
        return 1 + index;
    }

    @Override
    public int getSlotCount() {
        return this.slots;
    }

    @Override
    public int getFirstSlot() {
        return this.firstSlot;
    }

    private static void setAnalyzerVisible(boolean analyzerVisible) {
        GuiAnalyzerProvider.analyzerVisible = analyzerVisible;
    }

    private static boolean isAnalyzerVisible() {
        return analyzerVisible;
    }
}

