/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.core.gui.Drawable;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.widgets.IScrollable;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class ScrollBarElement
extends ElementGroup {
    private final GuiElement slider;
    private boolean visible;
    private boolean isScrolling;
    private boolean wasClicked;
    private int currentValue;
    private int initialMouseClickY;
    @Nullable
    private IScrollable listener;
    private int minValue;
    private int maxValue;
    private int step;

    public ScrollBarElement(int xPos, int yPos, int width, int height, Drawable sliderTexture) {
        super(xPos, yPos, width, height);
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.slider = this.drawable(sliderTexture);
    }

    public ScrollBarElement(int xPos, int yPos, Drawable backgroundTexture, boolean hasBorder, Drawable sliderTexture) {
        super(xPos, yPos, backgroundTexture.uWidth, backgroundTexture.vHeight);
        int offset = hasBorder ? 1 : 0;
        this.isScrolling = false;
        this.wasClicked = false;
        this.visible = true;
        this.drawable(backgroundTexture);
        this.slider = this.drawable(offset, offset, sliderTexture);
    }

    public void setParameters(IScrollable listener, int minValue, int maxValue, int step) {
        this.listener = listener;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
        this.setValue(this.currentValue);
    }

    @Override
    public boolean canMouseOver() {
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public int getValue() {
        return MathHelper.func_76125_a((int)this.currentValue, (int)this.minValue, (int)this.maxValue);
    }

    public int setValue(int value) {
        this.currentValue = MathHelper.func_76125_a((int)value, (int)this.minValue, (int)this.maxValue);
        if (this.listener != null) {
            this.listener.onScroll(this.currentValue);
        }
        int offset = value >= this.maxValue ? this.height - this.slider.height : (value <= this.minValue ? 0 : (int)((float)(this.currentValue - this.minValue) / (float)(this.maxValue - this.minValue) * (float)(this.height - this.slider.height)));
        this.slider.setYPosition(offset);
        return this.currentValue;
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        this.updateSlider(mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawElement(mouseX, mouseY);
    }

    private void updateSlider(int mouseX, int mouseY) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (this.listener == null || this.listener.isFocused(mouseX, mouseY)) {
            int wheel = Mouse.getDWheel();
            if (wheel > 0) {
                this.setValue(this.currentValue - this.step);
                return;
            }
            if (wheel < 0) {
                this.setValue(this.currentValue + this.step);
                return;
            }
        }
        int y = mouseY - this.yPos;
        if (!mouseDown && this.wasClicked) {
            this.wasClicked = false;
        }
        if (!mouseDown && this.isScrolling) {
            this.isScrolling = false;
        }
        if (this.isScrolling) {
            int range = this.maxValue - this.minValue;
            float value = (float)(y - this.initialMouseClickY) / (float)(this.height - this.slider.height);
            if ((value *= (float)range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
        } else if (this.slider.isMouseOver()) {
            if (mouseDown) {
                this.isScrolling = true;
                this.initialMouseClickY = y - this.slider.getY();
            }
        } else if (mouseDown && !this.wasClicked && this.isMouseOver()) {
            int range = this.maxValue - this.minValue;
            float value = ((float)y - (float)this.slider.height / 2.0f) / (float)(this.height - this.slider.height);
            if ((value *= (float)range) < (float)this.step / 2.0f) {
                this.setValue(this.minValue);
            } else if (value > (float)this.maxValue - (float)this.step / 2.0f) {
                this.setValue(this.maxValue);
            } else {
                this.setValue((int)((float)this.minValue + (float)this.step * (float)Math.round(value)));
            }
            this.wasClicked = true;
        }
    }
}

