/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IWindowElement;
import forestry.api.gui.events.ElementEvent;
import forestry.api.gui.events.GuiEvent;
import forestry.api.gui.events.GuiEventDestination;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.elements.layouts.ElementGroup;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class Window<G extends GuiScreen>
extends ElementGroup
implements IWindowElement {
    protected final G gui;
    @Nullable
    private Minecraft mc = null;
    protected int mouseX = -1;
    protected int mouseY = -1;
    @Nullable
    private IGuiElement mousedOverElement;
    @Nullable
    private IGuiElement draggedElement;
    @Nullable
    private IGuiElement focusedElement;

    public Window(int width, int height, G gui) {
        super(0, 0, width, height);
        this.gui = gui;
        this.addEventHandler(ElementEvent.Deletion.class, deletion -> {
            IGuiElement element = deletion.getOrigin();
            if (this.isMouseOver(element)) {
                this.setMousedOverElement(null);
            }
            if (this.isDragged(element)) {
                this.setDraggedElement(null);
            }
            if (this.isFocused(element)) {
                this.setFocusedElement(null);
            }
        });
    }

    @Override
    public IWindowElement getWindow() {
        return this;
    }

    @Override
    public IGuiElement setParent(@Nullable IGuiElement parent) {
        return this;
    }

    public void init(int guiLeft, int guiTop) {
        this.setLocation(guiLeft, guiTop);
    }

    @Override
    @Nullable
    public IGuiElement getDraggedElement() {
        return this.draggedElement;
    }

    public void setDraggedElement(@Nullable IGuiElement widget) {
        this.setDraggedElement(widget, -1);
    }

    public void setDraggedElement(@Nullable IGuiElement widget, int button) {
        if (this.draggedElement == widget) {
            return;
        }
        if (this.draggedElement != null) {
            this.postEvent(new ElementEvent.EndDrag(this.draggedElement), GuiEventDestination.ALL);
        }
        this.draggedElement = widget;
        if (this.draggedElement != null) {
            this.postEvent(new ElementEvent.StartDrag(this.draggedElement, button), GuiEventDestination.ALL);
        }
    }

    @Override
    @Nullable
    public IGuiElement getMousedOverElement() {
        return this.mousedOverElement;
    }

    public void setMousedOverElement(@Nullable IGuiElement widget) {
        if (this.mousedOverElement == widget) {
            return;
        }
        if (this.mousedOverElement != null) {
            this.postEvent(new ElementEvent.EndMouseOver(this.mousedOverElement), GuiEventDestination.ALL);
        }
        this.mousedOverElement = widget;
        if (this.mousedOverElement != null) {
            this.postEvent(new ElementEvent.StartMouseOver(this.mousedOverElement), GuiEventDestination.ALL);
        }
    }

    @Override
    @Nullable
    public IGuiElement getFocusedElement() {
        return this.focusedElement;
    }

    public void setFocusedElement(@Nullable IGuiElement widget) {
        IGuiElement newElement = widget;
        if (this.focusedElement == newElement) {
            return;
        }
        if (newElement != null && !newElement.canFocus()) {
            newElement = null;
        }
        if (this.focusedElement != null) {
            this.postEvent(new ElementEvent.LoseFocus(this.focusedElement), GuiEventDestination.ALL);
        }
        this.focusedElement = newElement;
        if (this.focusedElement != null) {
            this.postEvent(new ElementEvent.GainFocus(this.focusedElement), GuiEventDestination.ALL);
        }
    }

    @Override
    public boolean isMouseOver(IGuiElement element) {
        return this.getMousedOverElement() == element;
    }

    @Override
    public boolean isDragged(IGuiElement element) {
        return this.getDraggedElement() == element;
    }

    @Override
    public boolean isFocused(IGuiElement element) {
        return this.getFocusedElement() == element;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        this.updateWindow();
        this.onUpdateClient();
        for (IGuiElement widget : this.getElements()) {
            widget.updateClient();
        }
    }

    protected void updateWindow() {
        this.setMousedOverElement(this.calculateMousedOverElement());
        if (!(this.getFocusedElement() == null || this.getFocusedElement().isVisible() && this.getFocusedElement().isEnabled())) {
            this.setFocusedElement(null);
        }
        if (!Mouse.isButtonDown((int)0) && this.draggedElement != null) {
            this.setDraggedElement(null);
        }
    }

    @Nullable
    private IGuiElement calculateMousedOverElement() {
        Deque<IGuiElement> queue = this.calculateMousedOverElements();
        while (!queue.isEmpty()) {
            IGuiElement element = queue.removeFirst();
            if (!element.isEnabled() || !element.isVisible() || !element.canMouseOver()) continue;
            return element;
        }
        return null;
    }

    private Deque<IGuiElement> calculateMousedOverElements() {
        ArrayDeque<IGuiElement> list = new ArrayDeque<IGuiElement>();
        for (IGuiElement element : this.getQueuedElements(this)) {
            if (!element.isMouseOver()) continue;
            list.addLast(element);
        }
        return list;
    }

    private Collection<IGuiElement> getQueuedElements(IGuiElement element) {
        ArrayList<IGuiElement> widgets = new ArrayList<IGuiElement>();
        if (element instanceof IElementGroup) {
            IElementGroup group = (IElementGroup)element;
            boolean addChildren = true;
            if (element.isCropped()) {
                int mouseX = this.getRelativeMouseX(element);
                int mouseY = this.getRelativeMouseY(element);
                IGuiElement cropRelative = element.getCropElement() != null ? element.getCropElement() : this;
                int posX = cropRelative.getAbsoluteX() - element.getAbsoluteX();
                int posY = cropRelative.getAbsoluteY() - element.getAbsoluteY();
                boolean bl = addChildren = mouseX >= posX && mouseY >= posY && mouseX <= posX + element.getCropWidth() && mouseY <= posY + element.getCropWidth();
            }
            if (addChildren) {
                ListIterator<IGuiElement> iterator = group.getElements().listIterator(group.getElements().size());
                while (iterator.hasPrevious()) {
                    IGuiElement child = iterator.previous();
                    widgets.addAll(this.getQueuedElements(child));
                }
            }
        }
        widgets.add(element);
        return widgets;
    }

    public void drawTooltip(int mouseX, int mouseY) {
        List<String> lines = this.getTooltip(mouseX, mouseY);
        if (!lines.isEmpty()) {
            GlStateManager.func_179094_E();
            ScaledResolution scaledresolution = new ScaledResolution(this.getMinecraft());
            GuiUtils.drawHoveringText(lines, (int)(mouseX - this.getX()), (int)(mouseY - this.getY()), (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)-1, (FontRenderer)this.getFontRenderer());
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>(this.getTooltip());
        Deque<IGuiElement> queue = this.calculateMousedOverElements();
        while (!queue.isEmpty()) {
            IGuiElement element = queue.removeFirst();
            if (!element.isEnabled() || !element.isVisible() || !element.hasTooltip()) continue;
            tooltip.addAll(element.getTooltip(this.getRelativeMouseX(element), this.getRelativeMouseY(element)));
        }
        return tooltip;
    }

    public void setMousePosition(int mouseX, int mouseY) {
        float dx = (float)mouseX - (float)this.mouseX;
        float dy = (float)mouseY - (float)this.mouseY;
        if (dx != 0.0f || dy != 0.0f) {
            if (this.draggedElement != null) {
                this.postEvent(new GuiEvent.DragEvent(this.draggedElement, dx, dy), GuiEventDestination.ALL);
            } else {
                this.postEvent(new GuiEvent.MoveEvent(this, dx, dy), GuiEventDestination.ALL);
            }
        }
        if (mouseX != this.mouseX || mouseY != this.mouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.setMousedOverElement(this.calculateMousedOverElement());
        }
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public int getRelativeMouseX(@Nullable IGuiElement element) {
        if (element == null) {
            return this.mouseX;
        }
        return this.mouseX - element.getAbsoluteX();
    }

    @Override
    public int getRelativeMouseY(@Nullable IGuiElement element) {
        if (element == null) {
            return this.mouseY;
        }
        return this.mouseY - element.getAbsoluteY();
    }

    @Override
    public int getScreenWidth() {
        return ((GuiScreen)this.gui).field_146294_l;
    }

    @Override
    public int getScreenHeight() {
        return ((GuiScreen)this.gui).field_146295_m;
    }

    @Override
    public int getGuiLeft() {
        return ((IGuiSizable)this.gui).getGuiLeft();
    }

    @Override
    public int getGuiTop() {
        return ((IGuiSizable)this.gui).getGuiTop();
    }

    @Override
    public int getGuiHeight() {
        return ((IGuiSizable)this.gui).getSizeX();
    }

    @Override
    public int getGuiWidth() {
        return ((IGuiSizable)this.gui).getSizeY();
    }

    protected Minecraft getMinecraft() {
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        return this.mc;
    }

    @Override
    public TextureManager getTextureManager() {
        return this.getMinecraft().func_110434_K();
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.getMinecraft().field_71466_p;
    }
}

