/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.greenhouse.IClimateHousing;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.climate.ClimateContainer;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketUpdateClimate
extends ForestryPacket
implements IForestryPacketClient {
    BlockPos pos;
    ClimateContainer container;

    public PacketUpdateClimate(BlockPos pos, ClimateContainer container) {
        this.pos = pos;
        this.container = container;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.UPDATE_CLIMATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        this.container.writeData(data);
    }

    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayer player) throws IOException {
            BlockPos position = data.func_179259_c();
            IGreenhouseControllerInternal controller = (IGreenhouseControllerInternal)MultiblockUtil.getController((IBlockAccess)player.field_70170_p, position, IGreenhouseComponent.class);
            if (controller == null) {
                return;
            }
            IClimateContainer container = controller.getClimateContainer();
            if (container != null && container instanceof IStreamable) {
                IStreamable streamable = (IStreamable)((Object)container);
                streamable.readData(data);
                IClimateHousing parent = container.getParent();
                parent.onUpdateClimate();
            }
        }
    }
}

