/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui.widgets;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Floats;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateState;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import forestry.greenhouse.api.climate.IClimateModifier;
import forestry.greenhouse.api.greenhouse.GreenhouseManager;
import forestry.greenhouse.gui.GuiGreenhouse;
import forestry.greenhouse.gui.widgets.WidgetClimateModifier;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;

public class WidgetClimatePanel
extends Widget {
    protected static final int TEXT_FIELD_LENGTH = 50;
    protected static final Predicate<String> NUMBER_FILTER = text -> {
        if (text == null) {
            return false;
        }
        if (text.isEmpty()) {
            return true;
        }
        if (text.length() > 1 && !text.contains(".")) {
            return false;
        }
        if (text.length() > 7) {
            return false;
        }
        Float value = Floats.tryParse((String)text);
        return value != null && Floats.isFinite((float)value.floatValue()) && value.floatValue() >= 0.0f;
    };
    public final GuiGreenhouse gui;
    private final ClimateType type;
    private final GuiTextField textField;
    private List<WidgetClimateModifier> modifiers;

    public WidgetClimatePanel(WidgetManager manager, GuiGreenhouse gui, int xPos, int yPos, ClimateType type) {
        super(manager, xPos, yPos);
        this.width = 85;
        this.height = 98;
        this.type = type;
        this.gui = gui;
        this.textField = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, xPos + this.width / 2 - 25, yPos + 14, 50, 10);
        this.textField.func_175205_a(NUMBER_FILTER);
        this.textField.func_146185_a(false);
        IClimateState climateState = gui.container.getTargetedState();
        if (climateState.isPresent()) {
            this.textField.func_146180_a(Float.toString(climateState.get(type)));
        } else {
            this.textField.func_146189_e(false);
            this.textField.func_146184_c(false);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int i = 0;
        List modifiers = GreenhouseManager.climateManager.getModifiers().stream().filter(v -> v.canModify(type)).collect(Collectors.toList());
        for (IClimateModifier modifier : modifiers) {
            int xOffset = i % 4 * 18;
            int yOffset = i / 4 * 18;
            int rowStart = i / 4 * 4;
            int rowCount = modifiers.size() - rowStart;
            if (rowCount > 4) {
                rowCount = 4;
            }
            builder.add((Object)new WidgetClimateModifier(this, xPos + xOffset + this.width / 2 - rowCount / 2 * 18, yPos + yOffset + (this.height - 54 - 5), modifier));
            ++i;
        }
        this.modifiers = builder.build();
    }

    @Override
    public void draw(int startX, int startY) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.gui.textureFile);
        this.gui.func_73729_b(startX + this.textField.field_146209_f - 2, startY + this.textField.field_146210_g - 2, 196, 50, 52, 12);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String title = Translator.translateToLocal("for.gui." + this.type.getName());
        fontRenderer.func_78276_b(title, this.xPos + startX + this.width / 2 - fontRenderer.func_78256_a(title) / 2, startY + this.yPos + 2, ColourProperties.INSTANCE.get("gui.greenhouse." + this.type.getName() + ".header"));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.textField.func_146194_f();
        String modifiersTitle = Translator.translateToLocal("for.gui.modifier.title");
        fontRenderer.func_175063_a(TextFormatting.UNDERLINE + modifiersTitle, (float)(this.xPos + startX + this.width / 2 - fontRenderer.func_78256_a(modifiersTitle) / 2), (float)(this.yPos + startY + (this.height - 72)), ColourProperties.INSTANCE.get("gui.greenhouse.modifiers.subheader"));
        for (WidgetClimateModifier modifier : this.modifiers) {
            modifier.draw(startX, startY);
        }
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        for (WidgetClimateModifier modifier : this.modifiers) {
            ToolTip toolTip = modifier.getToolTip(mouseX, mouseY);
            if (toolTip == null) continue;
            return toolTip;
        }
        return null;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        boolean wasFocused = this.textField.func_146206_l();
        this.textField.func_146192_a(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop(), mouseButton);
        if (wasFocused && !this.textField.func_146206_l()) {
            this.gui.sendNetworkUpdate();
        }
    }

    public void setValue(float value) {
        this.textField.func_146180_a(Float.toString(value));
    }

    public float parseValue() {
        String text = this.textField.func_146179_b();
        if (text.isEmpty()) {
            return 2.0f;
        }
        try {
            float value = Float.parseFloat(text);
            return Math.max(0.0f, Math.min(value, 2.0f));
        }
        catch (NumberFormatException e) {
            return 2.0f;
        }
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (keyCode == 28 && this.textField.func_146206_l()) {
            this.textField.func_146195_b(false);
            this.gui.sendNetworkUpdate();
            return true;
        }
        return this.textField.func_146201_a(typedChar, keyCode);
    }

    public ClimateType getType() {
        return this.type;
    }
}

