/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock;

import forestry.core.network.PacketBufferForestry;
import forestry.greenhouse.api.greenhouse.IGreenhouseLimits;
import forestry.greenhouse.api.greenhouse.Position2D;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GreenhouseLimits
implements IGreenhouseLimits {
    private final Position2D maximumCoordinates;
    private final Position2D minimumCoordinates;
    private final int height;
    private final int depth;

    public GreenhouseLimits(Position2D maximumCoordinates, Position2D minimumCoordinates, int height, int depth) {
        this.maximumCoordinates = maximumCoordinates;
        this.minimumCoordinates = minimumCoordinates;
        this.height = height;
        this.depth = depth;
    }

    public GreenhouseLimits(NBTTagCompound compound) {
        this.minimumCoordinates = new Position2D(compound.func_74775_l("minimumCoordinates"));
        this.maximumCoordinates = new Position2D(compound.func_74775_l("maximumCoordinates"));
        this.depth = compound.func_74762_e("depth");
        this.height = compound.func_74762_e("height");
    }

    public GreenhouseLimits(PacketBufferForestry data) {
        this.minimumCoordinates = data.readPosition();
        this.maximumCoordinates = data.readPosition();
        this.depth = data.readInt();
        this.height = data.readInt();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("minimumCoordinates", (NBTBase)this.minimumCoordinates.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("maximumCoordinates", (NBTBase)this.maximumCoordinates.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("depth", this.depth);
        nbt.func_74768_a("height", this.height);
        return nbt;
    }

    public void writeData(PacketBufferForestry data) {
        data.writePosition(this.minimumCoordinates);
        data.writePosition(this.maximumCoordinates);
        data.writeInt(this.depth);
        data.writeInt(this.height);
    }

    @Override
    public Position2D getMaximumCoordinates() {
        return this.maximumCoordinates;
    }

    @Override
    public Position2D getMinimumCoordinates() {
        return this.minimumCoordinates;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }
}

