/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.storage;

import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.greenhouse.api.greenhouse.IBlankBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockStorage;
import forestry.greenhouse.api.greenhouse.IGreenhouseChunk;
import forestry.greenhouse.api.greenhouse.IGreenhouseProvider;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.multiblock.blocks.GreenhouseBlockCache;
import forestry.greenhouse.multiblock.blocks.client.ClientBlock;
import forestry.greenhouse.multiblock.blocks.client.ClientBlockHandler;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GreenhouseBlockStorage
implements IGreenhouseBlockStorage,
IStreamable {
    protected final HashMap<Long, HashMap<Position2D, IGreenhouseBlock>> blocks = new HashMap();
    protected final IGreenhouseProvider provider;
    protected final World world;
    protected final GreenhouseBlockCache cache;
    protected int blockCount;

    public GreenhouseBlockStorage(IGreenhouseProvider provider, World world) {
        this.world = world;
        this.provider = provider;
        this.cache = new GreenhouseBlockCache();
    }

    public void addProviderToChunks() {
        for (long chunkPos : this.blocks.keySet()) {
            IGreenhouseChunk chunk = this.getChunk(chunkPos);
            chunk.add(this.provider);
        }
    }

    public void removeProviderFromChunks() {
        for (long chunkPos : this.blocks.keySet()) {
            IGreenhouseChunk chunk = this.getChunk(chunkPos);
            chunk.remove(this.provider);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createBlocksFromCache() {
        ClientBlockHandler blockHandler = ClientBlockHandler.getInstance();
        for (Set<BlockPos> positions : this.cache.getPositions().values()) {
            for (BlockPos position : positions) {
                ClientBlock block = blockHandler.createBlock((IGreenhouseBlockStorage)this, (ClientBlock)null, EnumFacing.DOWN, position);
                this.setBlock(position, block);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createChunksFromCache() {
        this.removeProviderFromChunks();
        for (long chunkPos : this.cache.getPositions().keySet()) {
            IGreenhouseChunk chunk = this.getChunk(chunkPos);
            chunk.add(this.provider);
        }
    }

    public void clearBlocks(boolean chunkUnloading) {
        for (HashMap<Position2D, IGreenhouseBlock> blocks : this.blocks.values()) {
            Iterator<IGreenhouseBlock> blockIterator = blocks.values().iterator();
            while (blockIterator.hasNext()) {
                IGreenhouseBlock block = blockIterator.next();
                if (block == null) continue;
                this.removeBlock(block);
                blockIterator.remove();
            }
        }
        this.blockCount = 0;
    }

    protected IGreenhouseChunk getChunk(BlockPos pos) {
        int xChunk = pos.func_177958_n() >> 4;
        int zChunk = pos.func_177952_p() >> 4;
        return this.getChunk(ChunkPos.func_77272_a((int)xChunk, (int)zChunk));
    }

    protected IGreenhouseChunk getChunk(long chunkPos) {
        GreenhouseBlockManager manager = GreenhouseBlockManager.getInstance();
        return manager.getOrCreateChunk(this.world, chunkPos);
    }

    @Override
    @Nullable
    public IGreenhouseBlock getBlock(BlockPos pos) {
        long chunkPos = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        HashMap<Position2D, IGreenhouseBlock> chunkBlocks = this.getChunkBlocks(chunkPos);
        return chunkBlocks.get(new Position2D((Vec3i)pos));
    }

    @Override
    public boolean setBlock(BlockPos pos, @Nullable IGreenhouseBlock newBlock) {
        IGreenhouseChunk chunk = this.getChunk(pos);
        if (chunk != null) {
            Long chunkPos = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
            HashMap<Position2D, IGreenhouseBlock> chunkBlocks = this.getChunkBlocks(chunkPos);
            IGreenhouseBlock oldBlock = newBlock == null ? chunkBlocks.remove(new Position2D((Vec3i)pos)) : chunkBlocks.put(new Position2D((Vec3i)pos), newBlock);
            if (!this.world.field_72995_K) {
                if (newBlock == null) {
                    if (oldBlock instanceof IBlankBlock) {
                        --this.blockCount;
                    }
                } else if (newBlock != null) {
                    this.cache.add(chunkPos, pos);
                    if (newBlock instanceof IBlankBlock) {
                        ++this.blockCount;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public <B extends IGreenhouseBlock> void removeBlock(IGreenhouseBlock blockToRemove) {
        blockToRemove.getHandler().onRemoveBlock(this, blockToRemove);
    }

    @Override
    public IGreenhouseProvider getProvider() {
        return this.provider;
    }

    protected HashMap<Position2D, IGreenhouseBlock> getChunkBlocks(long chunkPos) {
        return this.blocks.computeIfAbsent(chunkPos, k -> new HashMap());
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        this.cache.writeData(data);
        this.cache.clear();
        data.writeInt(this.blockCount);
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.cache.readData(data);
        this.blockCount = data.readInt();
    }
}

