/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock.blocks.storage;

import forestry.api.core.IErrorState;
import forestry.api.greenhouse.IClimateHousing;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.network.PacketBufferForestry;
import forestry.greenhouse.api.climate.GreenhouseState;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlockHandler;
import forestry.greenhouse.api.greenhouse.Position2D;
import forestry.greenhouse.multiblock.GreenhouseLimits;
import forestry.greenhouse.multiblock.blocks.client.ClientBlockHandler;
import forestry.greenhouse.multiblock.blocks.storage.GreenhouseProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class GreenhouseProviderClient
extends GreenhouseProvider {
    boolean reloadChunks;

    public GreenhouseProviderClient(World world, IClimateContainer container) {
        super(world, container);
    }

    @Override
    public void create() {
    }

    @Override
    public void writeData(PacketBufferForestry data) {
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        this.storage.readData(data);
        this.storage.createChunksFromCache();
        this.state = GreenhouseState.values()[data.readByte()];
        this.reloadChunks = data.readBoolean();
        this.size = data.readInt();
        this.centerPos = data.func_179259_c();
        if (data.readBoolean()) {
            this.limits = new GreenhouseLimits(data);
        }
        if (data.readBoolean()) {
            this.usedLimits = new GreenhouseLimits(data);
        }
        this.getErrorLogic().readData(data);
    }

    @Override
    public synchronized void recreate() {
        this.storage.clearBlocks(false);
        this.storage.createBlocksFromCache();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_152344_a(this::markBlockForRenderUpdate);
    }

    @Override
    public void onUnloadChunk(long chunkPos) {
    }

    @Override
    public void onLoadChunk(long chunkPos) {
    }

    @Override
    public IErrorState checkPosition(BlockPos position) {
        return null;
    }

    @Override
    public Collection<IGreenhouseBlockHandler> getHandlers() {
        return Collections.singleton(ClientBlockHandler.getInstance());
    }

    @Override
    public void onBlockChange() {
    }

    @Override
    public void scheduledUpdate() {
    }

    public void markBlockForRenderUpdate() {
        IClimateHousing housing = this.container.getParent();
        if (housing instanceof IGreenhouseController) {
            IGreenhouseController controller = (IGreenhouseController)housing;
            if (!controller.isAssembled()) {
                return;
            }
            BlockPos position = controller.getCenterCoordinates();
            Position2D minEdge = this.limits.getMinimumCoordinates();
            Position2D maxEdge = this.limits.getMaximumCoordinates();
            BlockPos minPos = new BlockPos(minEdge.getX(), -this.limits.getDepth(), minEdge.getZ());
            BlockPos maxPos = new BlockPos(maxEdge.getX() + 1, this.limits.getHeight(), maxEdge.getZ() + 1);
            minPos = minPos.func_177971_a((Vec3i)position);
            maxPos = maxPos.func_177971_a((Vec3i)position);
            this.world.func_175704_b(minPos, maxPos);
        }
    }
}

