/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.proxy;

import com.google.common.base.Preconditions;
import forestry.api.climate.IClimateState;
import forestry.core.models.BlockModelEntry;
import forestry.core.models.ModelEntry;
import forestry.core.models.ModelManager;
import forestry.greenhouse.GreenhouseEventHandler;
import forestry.greenhouse.ModuleGreenhouse;
import forestry.greenhouse.api.climate.IClimateContainer;
import forestry.greenhouse.api.greenhouse.IGreenhouseBlock;
import forestry.greenhouse.blocks.BlockClimatiser;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockRegistryGreenhouse;
import forestry.greenhouse.models.ModelCamouflageSprayCan;
import forestry.greenhouse.models.ModelCamouflaged;
import forestry.greenhouse.models.ModelGreenhouseWindow;
import forestry.greenhouse.multiblock.blocks.world.GreenhouseBlockManager;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProxyGreenhouseClient
extends ProxyGreenhouse {
    private static BlockPos COLOR_BLOCK_POSITION;
    private static BiomeColorHelper.ColorResolver ORIGINAL_GRASS_COLOR;
    private static BiomeColorHelper.ColorResolver ORIGINAL_FOLIAGE_COLOR;

    @Override
    public void initializeModels() {
        BlockModelEntry blockModelIndex;
        ModelResourceLocation itemModelLocation;
        ModelResourceLocation blockModelLocation;
        BlockClimatiser climatiserBlock;
        BlockRegistryGreenhouse blocks = ModuleGreenhouse.getBlocks();
        Preconditions.checkNotNull((Object)blocks);
        ModelManager modelManager = ModelManager.getInstance();
        BlockGreenhouse greenhouseBlock = blocks.greenhouseBlock;
        if (greenhouseBlock != null) {
            ModelResourceLocation blockModelLocation2 = new ModelResourceLocation("forestry:greenhouse");
            ModelResourceLocation itemModelLocation2 = new ModelResourceLocation("forestry:greenhouse", "inventory");
            BlockModelEntry blockModelIndex2 = new BlockModelEntry(blockModelLocation2, itemModelLocation2, new ModelCamouflaged<BlockGreenhouse>(BlockGreenhouse.class), greenhouseBlock);
            modelManager.registerCustomBlockModel(blockModelIndex2);
        }
        if ((climatiserBlock = blocks.climatiserBlock) != null) {
            blockModelLocation = new ModelResourceLocation("forestry:climatiser");
            itemModelLocation = new ModelResourceLocation("forestry:climatiser", "inventory");
            blockModelIndex = new BlockModelEntry(blockModelLocation, itemModelLocation, new ModelCamouflaged<BlockClimatiser>(BlockClimatiser.class), climatiserBlock);
            modelManager.registerCustomBlockModel(blockModelIndex);
        }
        blockModelLocation = new ModelResourceLocation("forestry:greenhouse.window");
        itemModelLocation = new ModelResourceLocation("forestry:greenhouse_window", "inventory");
        blockModelIndex = new BlockModelEntry(blockModelLocation, itemModelLocation, new ModelGreenhouseWindow(), ModuleGreenhouse.getBlocks().window);
        modelManager.registerCustomBlockModel(blockModelIndex);
        blockModelLocation = new ModelResourceLocation("forestry:greenhouse.window_up");
        itemModelLocation = new ModelResourceLocation("forestry:greenhouse_window_up", "inventory");
        blockModelIndex = new BlockModelEntry(blockModelLocation, itemModelLocation, new ModelGreenhouseWindow(), ModuleGreenhouse.getBlocks().roofWindow);
        modelManager.registerCustomBlockModel(blockModelIndex);
        ModelResourceLocation modelLocation = new ModelResourceLocation("forestry:camouflage_spray_can", "inventory");
        ModelEntry itemModelIndex = new ModelEntry(modelLocation, new ModelCamouflageSprayCan());
        modelManager.registerCustomModel(itemModelIndex);
    }

    @Override
    public void preInti() {
        MinecraftForge.EVENT_BUS.register((Object)new GreenhouseEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ORIGINAL_GRASS_COLOR = BiomeColorHelper.field_180291_a;
        BiomeColorHelper.field_180291_a = (biome, blockPosition) -> {
            COLOR_BLOCK_POSITION = blockPosition;
            return ORIGINAL_GRASS_COLOR.func_180283_a(biome, blockPosition);
        };
        ORIGINAL_FOLIAGE_COLOR = BiomeColorHelper.field_180289_b;
        BiomeColorHelper.field_180289_b = (biome, blockPosition) -> {
            COLOR_BLOCK_POSITION = blockPosition;
            return ORIGINAL_FOLIAGE_COLOR.func_180283_a(biome, blockPosition);
        };
    }

    @Override
    public void inti() {
    }

    @SubscribeEvent
    public void getFoliageColor(BiomeEvent.GetFoliageColor event) {
        IGreenhouseBlock logicBlock;
        if (COLOR_BLOCK_POSITION != null && (logicBlock = GreenhouseBlockManager.getInstance().getBlock((World)Minecraft.func_71410_x().field_71441_e, COLOR_BLOCK_POSITION)) != null && logicBlock.getProvider().isClosed()) {
            IClimateContainer container = logicBlock.getProvider().getClimateContainer();
            IClimateState climateState = container.getState();
            double temperature = MathHelper.func_76131_a((float)climateState.getTemperature(), (float)0.0f, (float)1.0f);
            double humidity = MathHelper.func_76131_a((float)climateState.getHumidity(), (float)0.0f, (float)1.0f);
            event.setNewColor(ColorizerGrass.func_77480_a((double)temperature, (double)humidity));
        }
    }

    @SubscribeEvent
    public void getGrassColor(BiomeEvent.GetGrassColor event) {
        IGreenhouseBlock logicBlock;
        if (COLOR_BLOCK_POSITION != null && (logicBlock = GreenhouseBlockManager.getInstance().getBlock((World)Minecraft.func_71410_x().field_71441_e, COLOR_BLOCK_POSITION)) != null && logicBlock.getProvider().isClosed()) {
            IClimateContainer container = logicBlock.getProvider().getClimateContainer();
            IClimateState climateState = container.getState();
            double temperature = MathHelper.func_76131_a((float)climateState.getTemperature(), (float)0.0f, (float)1.0f);
            double humidity = MathHelper.func_76131_a((float)climateState.getHumidity(), (float)0.0f, (float)1.0f);
            event.setNewColor(ColorizerGrass.func_77480_a((double)temperature, (double)humidity));
        }
    }
}

