/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.blocks.BlockGreenhouseWindow;
import forestry.greenhouse.climate.ClimateSourceWindow;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileGreenhouseWindow
extends TileEntity
implements IActivatable,
IClimateSourceOwner {
    private final ClimateSourceWindow source = new ClimateSourceWindow(0.05f, 5.0f);
    @Nullable
    private WindowMode mode;
    private String glass;
    private boolean active;

    public TileGreenhouseWindow() {
        this.source.setOwner(this);
        this.glass = "glass";
    }

    @Override
    public IClimateSource getClimateSource() {
        return this.source;
    }

    @Override
    public boolean isCircuitable() {
        return false;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.field_174879_c;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.getCoordinates(), this.getCoordinates());
            } else {
                NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.getCoordinates(), this.field_145850_b);
            }
        }
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    public void onNeighborBlockChange() {
        WindowMode otherMode = this.isBlocked();
        if (this.getMode() != WindowMode.PLAYER && this.getMode() != WindowMode.CONTROL && otherMode != this.getMode()) {
            this.setMode(otherMode);
        }
    }

    public WindowMode isBlocked() {
        if (this.field_145850_b == null) {
            return WindowMode.BLOCK;
        }
        if (!this.field_145850_b.func_175667_e(this.field_174879_c)) {
            return WindowMode.BLOCK;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockPos blockedPos = ((BlockGreenhouseWindow)state.func_177230_c()).isRoofWindow() ? this.getCoordinates().func_177972_a(EnumFacing.UP) : this.getCoordinates().func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockGreenhouseWindow.FACING));
        return this.field_145850_b.func_175623_d(blockedPos) ? WindowMode.OPEN : WindowMode.BLOCK;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("mode")) {
            this.setMode(WindowMode.values()[data.func_74765_d("mode")]);
        }
        if (data.func_74764_b("Glass")) {
            this.glass = data.func_74779_i("Glass");
        }
        this.source.readFromNBT(data);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        if (this.mode != null) {
            data.func_74777_a("mode", (short)this.mode.ordinal());
        }
        if (this.glass != null) {
            data.func_74778_a("Glass", this.glass);
        }
        this.source.writeToNBT(data);
        return super.func_189515_b(data);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public String getGlass() {
        return this.glass;
    }

    public void setGlass(String glass) {
        this.glass = glass;
    }

    @Nullable
    public WindowMode getMode() {
        return this.mode;
    }

    public void setMode(WindowMode mode) {
        this.mode = mode;
        this.setActive(mode == WindowMode.OPEN);
    }

    public static enum WindowMode {
        PLAYER,
        BLOCK,
        CONTROL,
        OPEN;

    }
}

