/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    @CapabilityInject(value=IEnergyStorage.class)
    public static final Capability<IEnergyStorage> ENERGY_HANDLER = null;

    private EnergyHelper() {
    }

    public static void addEnergyInformation(ItemStack stack, List<String> list) {
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            list.add(StringHelper.localize("info.cofh.charge") + ": " + StringHelper.getScaledNumber(stack.func_77978_p().func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber(((IEnergyContainerItem)stack.func_77973_b()).getMaxEnergyStored(stack)) + " RF");
        }
    }

    public static int extractEnergyFromContainer(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyHelper.isEnergyContainerItem(container) ? ((IEnergyContainerItem)container.func_77973_b()).extractEnergy(container, maxExtract, simulate) : 0;
    }

    public static int insertEnergyIntoContainer(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyHelper.isEnergyContainerItem(container) ? ((IEnergyContainerItem)container.func_77973_b()).receiveEnergy(container, maxReceive, simulate) : 0;
    }

    public static int extractEnergyFromHeldContainer(EntityPlayer player, int maxExtract, boolean simulate) {
        ItemStack container = player.func_184614_ca();
        return EnergyHelper.isEnergyContainerItem(container) ? ((IEnergyContainerItem)container.func_77973_b()).extractEnergy(container, maxExtract, simulate) : 0;
    }

    public static int insertEnergyIntoHeldContainer(EntityPlayer player, int maxReceive, boolean simulate) {
        ItemStack container = player.func_184614_ca();
        return EnergyHelper.isEnergyContainerItem(container) ? ((IEnergyContainerItem)container.func_77973_b()).receiveEnergy(container, maxReceive, simulate) : 0;
    }

    public static boolean isPlayerHoldingEnergyContainerItem(EntityPlayer player) {
        return EnergyHelper.isEnergyContainerItem(player.func_184614_ca());
    }

    public static boolean isEnergyContainerItem(ItemStack container) {
        return !container.func_190926_b() && container.func_77973_b() instanceof IEnergyContainerItem;
    }

    public static boolean isEnergyHandler(ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(ENERGY_HANDLER, null);
    }

    public static IEnergyStorage getEnergyHandler(ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(ENERGY_HANDLER, null);
    }

    public static ItemStack setDefaultEnergyTag(ItemStack container, int energy) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74768_a("Energy", energy);
        return container;
    }

    public static int extractEnergyFromAdjacentEnergyProvider(TileEntity tile, EnumFacing side, int energy, boolean simulate) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        if (handler instanceof IEnergyProvider) {
            return ((IEnergyProvider)handler).extractEnergy(side.func_176734_d(), energy, simulate);
        }
        if (handler != null && handler.hasCapability(ENERGY_HANDLER, side.func_176734_d())) {
            return ((IEnergyStorage)handler.getCapability(ENERGY_HANDLER, side.func_176734_d())).extractEnergy(energy, simulate);
        }
        return 0;
    }

    public static int insertEnergyIntoAdjacentEnergyReceiver(TileEntity tile, EnumFacing side, int energy, boolean simulate) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        if (handler instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)handler).receiveEnergy(side.func_176734_d(), energy, simulate);
        }
        if (handler != null && handler.hasCapability(ENERGY_HANDLER, side.func_176734_d())) {
            return ((IEnergyStorage)handler.getCapability(ENERGY_HANDLER, side.func_176734_d())).receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static boolean isAdjacentEnergyConnectableFromSide(TileEntity tile, EnumFacing side) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return EnergyHelper.isEnergyConnectableFromSide(handler, side.func_176734_d());
    }

    public static boolean isEnergyConnectableFromSide(TileEntity tile, EnumFacing from) {
        return tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(from);
    }

    public static boolean isAdjacentEnergyReceiverFromSide(TileEntity tile, EnumFacing side) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return EnergyHelper.isEnergyReceiverFromSide(handler, side.func_176734_d());
    }

    public static boolean isEnergyReceiverFromSide(TileEntity tile, EnumFacing from) {
        return tile instanceof IEnergyReceiver && ((IEnergyReceiver)tile).canConnectEnergy(from);
    }

    public static boolean isAdjacentEnergyProviderFromSide(TileEntity tile, EnumFacing side) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return EnergyHelper.isEnergyProviderFromSide(handler, side.func_176734_d());
    }

    public static boolean isEnergyProviderFromSide(TileEntity tile, EnumFacing from) {
        return tile instanceof IEnergyProvider && ((IEnergyProvider)tile).canConnectEnergy(from);
    }

    public static boolean isAdjacentEnergyHandler(TileEntity tile, EnumFacing side) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return handler != null && handler.hasCapability(ENERGY_HANDLER, side.func_176734_d());
    }

    public static boolean canAdjacentEnergyHandlerExtract(TileEntity tile, EnumFacing side) {
        IEnergyStorage storage;
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        if (handler != null && handler.hasCapability(ENERGY_HANDLER, side.func_176734_d()) && (storage = (IEnergyStorage)handler.getCapability(ENERGY_HANDLER, side.func_176734_d())) != null) {
            return storage.canExtract();
        }
        return false;
    }

    public static boolean canAdjacentEnergyHandlerReceive(TileEntity tile, EnumFacing side) {
        IEnergyStorage storage;
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        if (handler != null && handler.hasCapability(ENERGY_HANDLER, side.func_176734_d()) && (storage = (IEnergyStorage)handler.getCapability(ENERGY_HANDLER, side.func_176734_d())) != null) {
            return storage.canReceive();
        }
        return false;
    }

    public static boolean isEnergyHandler(TileEntity tile, EnumFacing face) {
        return tile != null && tile.hasCapability(ENERGY_HANDLER, face);
    }
}

