/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.nbt;

import cofh.core.util.nbt.NBTCache;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;

public class NBTCopyHelper {
    public static ResultNBT copyAndHashNBT(NBTTagCompound tag) {
        int hash = 10;
        NBTTagCompound copy = new NBTTagCompound();
        for (String s : tag.func_150296_c()) {
            Result result = NBTCopyHelper.copyAndHash(tag.func_74781_a(s));
            hash += s.hashCode() ^ result.hash;
            copy.func_74782_a(s, result.base);
        }
        return new ResultNBT(copy, hash);
    }

    private static Result copyAndHash(NBTBase base) {
        byte id = base.func_74732_a();
        switch (id) {
            case 1: {
                NBTTagByte cache = NBTCache.toCachedByte((NBTTagByte)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 2: {
                NBTTagShort cache = NBTCache.toCachedShort((NBTTagShort)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 3: {
                NBTTagInt cache = NBTCache.toCachedInt((NBTTagInt)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 4: {
                NBTTagLong cache = NBTCache.toCachedLong((NBTTagLong)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 10: {
                int hash = 10;
                NBTTagCompound copy = new NBTTagCompound();
                NBTTagCompound tag = (NBTTagCompound)base;
                for (String s : tag.func_150296_c()) {
                    Result result = NBTCopyHelper.copyAndHash(tag.func_74781_a(s));
                    hash += s.hashCode() ^ result.hash;
                    copy.func_74782_a(s, result.base);
                }
                return new Result((NBTBase)copy, hash);
            }
            case 9: {
                NBTTagList list = (NBTTagList)base;
                int tagType = list.func_150303_d();
                if (tagType == 0) {
                    return new Result((NBTBase)list.func_74737_b(), list.hashCode());
                }
                NBTTagList copy = new NBTTagList();
                int hash = 9;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Result result = NBTCopyHelper.copyAndHash(list.func_179238_g(i));
                    hash = hash * 31 + result.hash;
                    copy.func_74742_a(result.base);
                }
                return new Result((NBTBase)copy, hash);
            }
            case 5: {
                NBTTagFloat cache = NBTCache.toCachedFloat((NBTTagFloat)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
            case 6: {
                NBTTagDouble cache = NBTCache.toCachedDouble((NBTTagDouble)base);
                return new Result((NBTBase)cache, cache.hashCode());
            }
        }
        return new Result(base.func_74737_b(), base.hashCode());
    }

    private static class Result {
        public final NBTBase base;
        public final int hash;

        public Result(NBTBase base, int hash) {
            this.base = base;
            this.hash = hash;
        }
    }

    public static class ResultNBT {
        public final NBTTagCompound copy;
        public final int hash;

        public ResultNBT(NBTTagCompound copy, int hash) {
            this.copy = copy;
            this.hash = hash;
        }
    }
}

