/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry;

import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import pl.asie.computronics.util.StringUtil;

public class FlowerProviderSea
implements IFlowerProvider,
IFlowerAcceptableRule {
    private static List<String> waterTypes = Arrays.asList("water");
    private static final List<String> saltwaterTypes = Arrays.asList("saltwater", "saltWater", "Saltwater", "SaltWater");
    private static boolean hasCheckedSaltwater = false;

    private static void checkSaltwater() {
        if (hasCheckedSaltwater) {
            return;
        }
        for (String saltwaterType : saltwaterTypes) {
            if (!FluidRegistry.isFluidRegistered((String)saltwaterType)) continue;
            waterTypes = saltwaterTypes;
            break;
        }
        hasCheckedSaltwater = true;
    }

    public boolean isAcceptableFlower(IBlockState state, World world, BlockPos pos, String flowerType) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            if (!hasCheckedSaltwater) {
                FlowerProviderSea.checkSaltwater();
            }
            if (waterTypes.contains(fluid.getName())) {
                if (state.func_177230_c() instanceof IFluidBlock) {
                    return ((IFluidBlock)state).canDrain(world, pos);
                }
                if (state.func_177230_c() instanceof BlockLiquid) {
                    return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
                }
            }
        }
        return false;
    }

    public boolean isAcceptedPollinatable(World world, ICheckPollinatable iPollinatable) {
        return false;
    }

    public String getFlowerType() {
        return "computronics.flowers.sea";
    }

    public String getDescription() {
        return StringUtil.localize(this.getFlowerType());
    }

    public NonNullList<ItemStack> affectProducts(World world, IIndividual individual, BlockPos pos, NonNullList<ItemStack> products) {
        return products;
    }
}

