/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry.nanomachines;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.Collections;
import javax.annotation.Nullable;
import li.cil.oc.api.Nanomachines;
import li.cil.oc.api.nanomachines.Behavior;
import li.cil.oc.api.nanomachines.Controller;
import li.cil.oc.api.prefab.AbstractProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.computronics.integration.forestry.IntegrationForestry;
import pl.asie.computronics.integration.forestry.nanomachines.SwarmBehavior;
import pl.asie.lib.util.RayTracer;

public class SwarmProvider
extends AbstractProvider {
    public SwarmProvider() {
        super("computronics:forestry-swarmprovider");
    }

    protected Behavior readBehaviorFromNBT(EntityPlayer player, NBTTagCompound nbt) {
        return new SwarmBehavior(player);
    }

    protected void writeBehaviorToNBT(Behavior behavior, NBTTagCompound nbt) {
    }

    public Iterable<Behavior> createBehaviors(EntityPlayer player) {
        return Collections.singletonList(new SwarmBehavior(player));
    }

    private void findTarget(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack, Event e) {
        if (stack != null && player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        SwarmBehavior behavior = this.getSwarmBehavior(player);
        if (behavior != null) {
            if (behavior.entity != null) {
                RayTracer.instance().fire((EntityLivingBase)player, 30.0);
                RayTraceResult target = RayTracer.instance().getTarget();
                if (target != null && target.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity entity = target.field_72308_g;
                    if (entity != null && entity instanceof EntityLivingBase && entity != behavior.entity) {
                        behavior.entity.func_70624_b((EntityLivingBase)entity);
                        SwarmProvider.swingItem(player, hand, stack, e);
                    }
                } else if (behavior.entity.func_70638_az() != null) {
                    behavior.entity.func_70624_b(null);
                    SwarmProvider.swingItem(player, hand, stack, e);
                }
            } else if (player.field_71075_bZ != null && player.field_71075_bZ.field_75098_d) {
                Vec3d pos = player.func_174791_d().func_178787_e(player.func_70040_Z());
                behavior.spawnNewEntity(pos.field_72450_a, pos.field_72448_b + 2.0, pos.field_72449_c, BeeManager.beeRoot.getMemberStack((IIndividual)BeeManager.beeRoot.templateAsIndividual(BeeManager.beeRoot.getDefaultTemplate()), (ISpeciesType)EnumBeeType.QUEEN));
                SwarmProvider.swingItem(player, hand, stack, e);
            }
        }
    }

    private void makeSwarm(double x, double y, double z, EntityPlayer player, EnumHand hand, @Nullable ItemStack stack, IBeeHousing tile, Event e) {
        SwarmBehavior behavior;
        ItemStack queenStack;
        IBee member;
        if (stack != null && player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        if (tile.getBeekeepingLogic() != null && tile.getBeekeepingLogic().canWork() && (member = BeeManager.beeRoot.getMember(queenStack = tile.getBeeInventory().getQueen())) != null && (behavior = this.getSwarmBehavior(player)) != null) {
            Controller controller;
            if (behavior.entity != null) {
                behavior.entity.func_70106_y();
            }
            if ((controller = Nanomachines.getController((EntityPlayer)player)) != null) {
                controller.changeBuffer(-10.0);
            }
            behavior.spawnNewEntity(x, y, z, member.getGenome().getPrimary().getSpriteColour(0), member.getGenome().getToleratesRain(), queenStack.func_77946_l());
            SwarmProvider.swingItem(player, hand, e);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        if (player != null && !player.field_70170_p.field_72995_K) {
            TileEntity te;
            ItemStack heldItem = e.getItemStack();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == IntegrationForestry.itemStickImpregnated) {
                if (e instanceof PlayerInteractEvent.RightClickItem) {
                    this.findTarget(player, e.getHand(), heldItem, (Event)e);
                } else if (e instanceof PlayerInteractEvent.RightClickBlock) {
                    if (player.func_70093_af() && e.getWorld().func_175667_e(e.getPos())) {
                        TileEntity te2 = e.getWorld().func_175625_s(e.getPos());
                        if (te2 instanceof IBeeHousing) {
                            BlockPos pos = e.getPos();
                            this.makeSwarm((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, player, e.getHand(), heldItem, (IBeeHousing)te2, (Event)e);
                        } else {
                            this.findTarget(player, e.getHand(), heldItem, (Event)e);
                        }
                    } else {
                        this.findTarget(player, e.getHand(), heldItem, (Event)e);
                    }
                }
            } else if (heldItem.func_190926_b() && e.getHand() == EnumHand.MAIN_HAND && e instanceof PlayerInteractEvent.RightClickBlock && player.func_70093_af() && e.getWorld().func_175667_e(e.getPos()) && (te = e.getWorld().func_175625_s(e.getPos())) instanceof IBeeHousing) {
                BlockPos pos = e.getPos();
                this.makeSwarm((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, player, e.getHand(), null, (IBeeHousing)te, (Event)e);
            }
        }
    }

    @SubscribeEvent
    public void onMinecartInteract(MinecartInteractEvent e) {
        EntityPlayer player = e.getPlayer();
        if (player != null && !player.field_70170_p.field_72995_K) {
            ItemStack heldItem = e.getItem();
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == IntegrationForestry.itemStickImpregnated) {
                if (player.func_70093_af() && e.getMinecart() instanceof IBeeHousing) {
                    this.makeSwarm(e.getMinecart().field_70165_t, e.getMinecart().field_70163_u + 0.25, e.getMinecart().field_70161_v, player, e.getHand(), heldItem, (IBeeHousing)e.getMinecart(), (Event)e);
                } else {
                    this.findTarget(player, e.getHand(), heldItem, (Event)e);
                }
            } else if (heldItem.func_190926_b() && e.getHand() == EnumHand.MAIN_HAND && player.func_70093_af() && e.getMinecart() instanceof IBeeHousing) {
                this.makeSwarm(e.getMinecart().field_70165_t, e.getMinecart().field_70163_u + 0.25, e.getMinecart().field_70161_v, player, e.getHand(), null, (IBeeHousing)e.getMinecart(), (Event)e);
            }
        }
    }

    public static void swingItem(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack, @Nullable Event e) {
        if (stack != null) {
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
        }
        SwarmProvider.swingItem(player, hand, e);
    }

    public static void swingItem(EntityPlayer player, EnumHand hand, @Nullable Event e) {
        player.func_184609_a(hand);
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketAnimation((Entity)player, hand == EnumHand.MAIN_HAND ? 0 : 3));
        }
        if (e != null && e.isCancelable()) {
            e.setCanceled(true);
        }
    }

    @Nullable
    private SwarmBehavior getSwarmBehavior(EntityPlayer player) {
        Controller controller = Nanomachines.getController((EntityPlayer)player);
        if (controller != null) {
            Iterable behaviors = controller.getActiveBehaviors();
            for (Behavior behavior : behaviors) {
                if (!(behavior instanceof SwarmBehavior)) continue;
                return (SwarmBehavior)behavior;
            }
            controller.setInput(0, true);
        }
        return null;
    }
}

