/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.info.providers;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.integration.info.ConfigValues;
import pl.asie.computronics.integration.info.providers.ComputronicsInfoProvider;
import pl.asie.computronics.tile.TileColorfulLamp;
import pl.asie.computronics.util.StringUtil;

public class InfoColorfulLamp
extends ComputronicsInfoProvider {
    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!ConfigValues.LampColor.getValue(config)) {
            return currenttip;
        }
        NBTTagCompound nbt = accessor.getNBTData();
        short color = nbt.func_74765_d("clc");
        int r = (color & 0x7C00) >>> 10;
        int g = (color & 0x3E0) >>> 5;
        int b = color & 0x1F;
        currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.waila.lamp.red", r));
        currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.waila.lamp.green", g));
        currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.waila.lamp.blue", b));
        return currenttip;
    }

    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, @Nullable TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && te instanceof TileColorfulLamp) {
            tag.func_74777_a("clc", (short)(((TileColorfulLamp)te).getLampColor() & Short.MAX_VALUE));
        }
        return tag;
    }

    @Override
    public String getUID() {
        return "lamp";
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (!(tileEntity instanceof TileColorfulLamp)) {
            return;
        }
        int color = ((TileColorfulLamp)tileEntity).getLampColor();
        int r = (color & 0x7C00) >>> 10;
        int g = (color & 0x3E0) >>> 5;
        int b = color & 0x1F;
        probeInfo.text(StringUtil.localizeAndFormat("tooltip.computronics.waila.lamp.red", r));
        probeInfo.text(StringUtil.localizeAndFormat("tooltip.computronics.waila.lamp.green", g));
        probeInfo.text(StringUtil.localizeAndFormat("tooltip.computronics.waila.lamp.blue", b));
    }
}

