/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.info.providers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.integration.info.ConfigValues;
import pl.asie.computronics.integration.info.providers.ComputronicsInfoProvider;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.StringUtil;
import pl.asie.computronics.util.internal.IComputronicsPeripheral;

public class InfoPeripheral
extends ComputronicsInfoProvider {
    @Override
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (Mods.isLoaded("opencomputers") && ConfigValues.OCAddress.getValue(config)) {
            NBTTagCompound nbt = accessor.getNBTData();
            currenttip = this.getInfo_OC(nbt, currenttip);
        }
        return currenttip;
    }

    @Optional.Method(modid="opencomputers")
    private List<String> getInfo_OC(NBTTagCompound nbt, List<String> currenttip) {
        NBTTagCompound node = nbt.func_74775_l("oc:node");
        if (node.func_74764_b("address")) {
            currenttip.add(StringUtil.localizeAndFormat("oc:gui.Analyzer.Address", node.func_74779_i("address")));
        }
        return currenttip;
    }

    @Optional.Method(modid="waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, @Nullable TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && te instanceof IComputronicsPeripheral && Mods.isLoaded("opencomputers")) {
            tag = this.getNBTData_OC(te, tag);
        }
        return tag;
    }

    @Optional.Method(modid="opencomputers")
    public NBTTagCompound getNBTData_OC(@Nullable TileEntity te, NBTTagCompound tag) {
        if (!(te instanceof Environment)) {
            return tag;
        }
        Environment tile = (Environment)te;
        Node node = tile.node();
        if (node != null && node.host() == tile) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            node.save(nodeNbt);
            tag.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        return tag;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public String getUID() {
        return "component";
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (Mods.isLoaded("opencomputers") && mode == ProbeMode.EXTENDED) {
            for (String s : this.getInfo_OC(this.getNBTData_OC(tile, new NBTTagCompound()), new ArrayList<String>(1))) {
                probeInfo.text(s);
            }
        }
    }
}

