/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.tis3d.module;

import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.util.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.integration.tis3d.module.ComputronicsModule;

public class ModuleColorful
extends ComputronicsModule {
    private short color = (short)25368;
    private static final ResourceLocation LAMP_ICON = new ResourceLocation("computronics:textures/blocks/lamp_layer_0.png");

    public ModuleColorful(Casing casing, Face face) {
        super(casing, face);
    }

    public void step() {
        super.step();
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.color = (short)(receivingPipe.read() & Short.MAX_VALUE);
            receivingPipe.beginRead();
            this.sendDataToClient();
        }
    }

    public void onDisabled() {
        super.onDisabled();
        this.color = (short)25368;
        this.sendDataToClient();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("c")) {
            this.color = nbt.func_74765_d("c");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74777_a("c", this.color);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(boolean enabled, float partialTicks) {
        if (!enabled) {
            return;
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        RenderUtil.bindTexture((ResourceLocation)LAMP_ICON);
        GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.875f, (float)0.875f, (float)0.875f);
        GlStateManager.func_179124_c((float)((float)((this.color >> 10 & 0x1F) * 8) / 255.0f), (float)((float)((this.color >> 5 & 0x1F) * 8) / 255.0f), (float)((float)((this.color & 0x1F) * 8) / 255.0f));
        RenderUtil.drawQuad();
    }
}

