/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.tis3d.serial;

import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileInterfaceProvider<T>
implements SerialInterfaceProvider {
    protected final Class<T> tileClass;
    protected final String name;
    protected final String link;

    public TileInterfaceProvider(Class<T> tileClass, String name, String link) {
        this.tileClass = tileClass;
        this.name = name;
        this.link = link;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && this.tileClass.isInstance(tile);
    }

    public SerialProtocolDocumentationReference getDocumentationReference() {
        return new SerialProtocolDocumentationReference("tooltip.computronics.manual.tis3d.port." + this.name, "protocols/computronics/" + this.link);
    }

    protected abstract boolean isStillValid(World var1, BlockPos var2, EnumFacing var3, SerialInterface var4, TileEntity var5);

    public boolean isValid(World world, BlockPos pos, EnumFacing side, SerialInterface serialInterface) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && this.isStillValid(world, pos, side, serialInterface, tile);
    }

    public final SerialInterface interfaceFor(World world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && this.tileClass.isInstance(tile) ? this.interfaceFor(world, pos, side, this.tileClass.cast(tile)) : null;
    }

    protected abstract SerialInterface interfaceFor(World var1, BlockPos var2, EnumFacing var3, T var4);
}

