/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tape.PortableTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.util.StringUtil;

public class ItemPortableTapeDrive
extends Item
implements IItemWithDocumentation {
    public ItemPortableTapeDrive() {
        this.func_77637_a(Computronics.tab);
        this.func_77627_a(false);
        this.func_77655_b("computronics.portable_tape_drive");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> info, ITooltipFlag flag) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("state") && tag.func_74764_b("tid") && PortableDriveManager.INSTANCE.exists(tag.func_74779_i("tid"), true)) {
            ItemStack tape;
            ItemStack itemStack = tape = tag.func_74764_b("inv") ? new ItemStack(tag.func_74775_l("inv")) : ItemStack.field_190927_a;
            if (!tape.func_190926_b()) {
                String label = Computronics.itemTape.getLabel(tape);
                if (label.length() > 0) {
                    info.add(StringUtil.localizeAndFormat("tooltip.computronics.tape.labeltapeinserted", label + TextFormatting.RESET + TextFormatting.GRAY));
                } else {
                    info.add(StringUtil.localize("tooltip.computronics.tape.tapeinserted"));
                }
                byte state = tag.func_74771_c("state");
                if (state >= 0 && state < TapeDriveState.State.VALUES.length) {
                    info.add(StringUtil.localizeAndFormat("tooltip.computronics.tape.state", StringUtil.localize("tooltip.computronics.tape.state." + TapeDriveState.State.VALUES[state].name().toLowerCase(Locale.ENGLISH))));
                }
            } else {
                info.add(StringUtil.localize("tooltip.computronics.tape.notapeinserted"));
            }
        }
        super.func_77624_a(stack, world, info, flag);
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        PortableTapeDrive drive = PortableDriveManager.INSTANCE.getOrCreate(entity.func_92059_d(), entity.field_70170_p.field_72995_K);
        drive.resetTime();
        drive.updateCarrier((Entity)entity, entity.func_92059_d());
        drive.update();
        return super.onEntityItemUpdate(entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity carrier, int slot, boolean isSelected) {
        super.func_77663_a(stack, world, carrier, slot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        PortableTapeDrive drive = PortableDriveManager.INSTANCE.getOrCreate(stack, world.field_72995_K);
        drive.updateCarrier((Entity)player, stack);
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        if (player.func_70093_af()) {
            player.openGui((Object)Computronics.instance, Computronics.guiPortableTapeDrive.getGuiID(), world, 0, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        drive.switchState(drive.getEnumState() != TapeDriveState.State.STOPPED ? TapeDriveState.State.STOPPED : TapeDriveState.State.PLAYING);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "portable_tape_drive";
    }

    @SideOnly(value=Side.CLIENT)
    public static class MeshDefinition
    implements ItemMeshDefinition {
        private static final ModelResourceLocation[] MODEL_LOCATIONS;
        private static final ModelResourceLocation BASE_MODEL;

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            byte state;
            NBTTagCompound tag;
            if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("state") && tag.func_74764_b("inv") && tag.func_74764_b("tid") && !new ItemStack(tag.func_74775_l("inv")).func_190926_b() && PortableDriveManager.INSTANCE.exists(tag.func_74779_i("tid"), true) && (state = tag.func_74771_c("state")) >= 0 && state < MODEL_LOCATIONS.length) {
                return MODEL_LOCATIONS[state];
            }
            return BASE_MODEL;
        }

        public static void registerRenderers() {
            if (Computronics.portableTapeDrive == null) {
                return;
            }
            ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
            models.add(new ResourceLocation("computronics", "portable_tape_drive/base"));
            for (int i = 0; i < TapeDriveState.State.VALUES.length; ++i) {
                models.add(new ResourceLocation("computronics", "portable_tape_drive/" + TapeDriveState.State.VALUES[i].name().toLowerCase(Locale.ENGLISH)));
            }
            ModelBakery.registerItemVariants((Item)Computronics.portableTapeDrive, (ResourceLocation[])models.toArray(new ResourceLocation[models.size()]));
            ModelLoader.setCustomMeshDefinition((Item)Computronics.portableTapeDrive, (ItemMeshDefinition)new MeshDefinition());
        }

        static {
            BASE_MODEL = new ModelResourceLocation("computronics:portable_tape_drive/base", "inventory");
            MODEL_LOCATIONS = new ModelResourceLocation[TapeDriveState.State.VALUES.length];
            for (int i = 0; i < TapeDriveState.State.VALUES.length; ++i) {
                MeshDefinition.MODEL_LOCATIONS[i] = new ModelResourceLocation("computronics:portable_tape_drive/" + TapeDriveState.State.VALUES[i].name().toLowerCase(Locale.ENGLISH), "inventory");
            }
        }
    }
}

