/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.network;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketClientHandler;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.oc.driver.DriverCardNoise;
import pl.asie.computronics.oc.driver.DriverCardSoundBase;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tape.PortableTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.Packet;

public class NetworkHandlerClient
extends MessageHandlerBase {
    private static final AudioFormat DFPWM_DECODED_FORMAT = new AudioFormat(48000.0f, 8, 1, false, false);

    @Override
    public void onMessage(Packet packet, INetHandler handler, EntityPlayer player, int command) throws IOException {
        PacketType type = PacketType.of(command);
        if (type == null) {
            return;
        }
        switch (type) {
            case TAPE_GUI_STATE: {
                TileEntity entity = packet.readTileEntity();
                TapeDriveState.State state = TapeDriveState.State.VALUES[packet.readUnsignedByte()];
                if (!(entity instanceof TileTapeDrive)) break;
                TileTapeDrive tile = (TileTapeDrive)entity;
                tile.switchState(state);
                break;
            }
            case AUDIO_DATA: {
                short handlerId = packet.readShort();
                AudioPacketClientHandler packetHandler = AudioPacketRegistry.INSTANCE.getClientHandler(handlerId);
                if (packetHandler == null) break;
                packetHandler.receivePacket(packet);
                break;
            }
            case AUDIO_STOP: {
                int managerId = packet.readInt();
                int codecId = packet.readInt();
                AudioPacketRegistry.INSTANCE.getManager(managerId).removePlayer(codecId);
                break;
            }
            case PARTICLE_SPAWN: {
                double x = packet.readFloat();
                double y = packet.readFloat();
                double z = packet.readFloat();
                double vx = packet.readFloat();
                double vy = packet.readFloat();
                double vz = packet.readFloat();
                int particle = packet.readInt();
                Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_175688_a(EnumParticleTypes.func_179342_a((int)particle), x, y, z, vx, vy, vz, new int[0]);
                break;
            }
            case COMPUTER_BEEP: {
                if (!Mods.isLoaded("opencomputers")) break;
                DriverCardSoundBase.onSound(packet, player);
                break;
            }
            case COMPUTER_NOISE: {
                if (!Mods.isLoaded("opencomputers")) break;
                DriverCardNoise.onSound(packet, player);
                break;
            }
            case COMPUTER_BOOM: {
                if (!Mods.isLoaded("opencomputers")) break;
                Computronics.proxy.goBoom(packet);
                break;
            }
            case TICKET_SYNC: {
                break;
            }
            case PORTABLE_TAPE_STATE: {
                PortableTapeDrive tapeDrive = PortableDriveManager.INSTANCE.getTapeDrive(packet.readString(), true);
                TapeDriveState.State state = TapeDriveState.State.VALUES[packet.readUnsignedByte()];
                if (tapeDrive == null) break;
                tapeDrive.switchState(state);
                tapeDrive.setSourceIdClient(packet.readInt());
            }
        }
    }
}

