/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import com.elytradev.mirage.lighting.IColoredLight;
import com.elytradev.mirage.lighting.Light;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import elucent.albedo.lighting.ILightProvider;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.block.BlockColorfulLamp;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.LampUtil;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.api.tile.IBundledRedstoneProvider;

@Optional.InterfaceList(value={@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo"), @Optional.Interface(iface="com.elytradev.mirage.lighting.IColoredLight", modid="mirage")})
public class TileColorfulLamp
extends TileEntityPeripheralBase
implements IBundledRedstoneProvider,
ILightProvider,
IColoredLight {
    private int color = 25368;

    public TileColorfulLamp() {
        super("colorful_lamp");
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Computronics.serverTickHandler.schedule(new Runnable(){

            @Override
            public void run() {
                IBlockState state = TileColorfulLamp.this.field_145850_b.func_180495_p(TileColorfulLamp.this.func_174877_v());
                if (state.func_177230_c() instanceof BlockColorfulLamp) {
                    if (LampUtil.shouldColorLight()) {
                        TileColorfulLamp.this.setLightValue(state, TileColorfulLamp.this.color);
                    } else {
                        TileColorfulLamp.this.setLightValue(state, LampUtil.toBrightness(TileColorfulLamp.this.color));
                    }
                }
            }
        });
    }

    public int getLampColor() {
        return this.color;
    }

    public void setLightValue(IBlockState state, int value) {
        if (LampUtil.shouldColorLight()) {
            int r = ((value & 0x7C00) >>> 10) / 2;
            int g = ((value & 0x3E0) >>> 5) / 2;
            int b = (value & 0x1F) / 2;
            int n = value > Short.MAX_VALUE ? 15 : (r < 0 ? 0 : (r = r > 15 ? 15 : r));
            int n2 = value > Short.MAX_VALUE ? 15 : (g < 0 ? 0 : (g = g > 15 ? 15 : g));
            b = value > Short.MAX_VALUE ? 15 : (b < 0 ? 0 : (b > 15 ? 15 : b));
            int brightness = Math.max(Math.max(r, g), b);
            this.field_145850_b.func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockColorfulLamp.BRIGHTNESS, (Comparable)Integer.valueOf(brightness | (b << 15) + (g << 10) + (r << 5))));
        } else {
            this.field_145850_b.func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockColorfulLamp.BRIGHTNESS, (Comparable)Integer.valueOf(value)));
        }
    }

    public void setLampColor(int color) {
        this.color = color & Short.MAX_VALUE;
        if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof BlockColorfulLamp) {
            if (LampUtil.shouldColorLight()) {
                this.setLightValue(this.field_145850_b.func_180495_p(this.func_174877_v()), this.color);
            } else {
                this.setLightValue(this.field_145850_b.func_180495_p(this.func_174877_v()), LampUtil.toBrightness(color));
            }
        }
        this.func_70296_d();
        this.notifyBlockUpdate();
    }

    @Callback(doc="function():number; Returns the current lamp color", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getLampColor(Context context, Arguments args) throws Exception {
        return new Object[]{this.getLampColor()};
    }

    @Callback(doc="function(color:number):boolean; Sets the lamp color; Set to 0 to turn the off the lamp; Returns true on success")
    @Optional.Method(modid="opencomputers")
    public Object[] setLampColor(Context context, Arguments args) throws Exception {
        if (args.checkInteger(0) >= 0 && args.checkInteger(0) <= 65535) {
            this.setLampColor(args.checkInteger(0));
            return new Object[]{true};
        }
        return new Object[]{false, "number must be between 0 and 32767"};
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="albedo")
    public elucent.albedo.lighting.Light provideLight() {
        return elucent.albedo.lighting.Light.builder().pos(this.func_174877_v()).color((this.color & 0x7C00) << 9 | (this.color & 0x3E0) << 6 | (this.color & 0x1F) << 3, false).radius(LampUtil.brightness(this.color) * 15.0f).build();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="mirage")
    public Light getColoredLight() {
        return Light.builder().pos(this.func_174877_v()).color((this.color & 0x7C00) << 9 | (this.color & 0x3E0) << 6 | (this.color & 0x1F) << 3, false).radius(LampUtil.brightness(this.color) * 15.0f).build();
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("display", "Colored Lamp", "Lumiose Lighting", "LED-4", new String[0]);
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"getLampColor", "setLampColor"};
    }

    @Nullable
    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            default: {
                return new Object[]{this.color};
            }
            case 1: 
        }
        if (arguments.length > 0 && arguments[0] instanceof Double) {
            this.setLampColor(((Double)arguments[0]).intValue());
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("clc")) {
            this.color = tag.func_74765_d("clc");
        }
        if (this.color < 0) {
            this.color = 0;
        }
    }

    @Override
    public boolean canBeColored() {
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74777_a("clc", (short)(this.color & Short.MAX_VALUE));
        return tag;
    }

    @Override
    public NBTTagCompound writeToRemoteNBT(NBTTagCompound tag) {
        super.writeToRemoteNBT(tag);
        tag.func_74777_a("clc", (short)(this.color & Short.MAX_VALUE));
        return tag;
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound tag) {
        super.readFromRemoteNBT(tag);
        int oldColor = this.color;
        if (tag.func_74764_b("clc")) {
            this.color = tag.func_74765_d("clc");
        }
        if (this.color < 0) {
            this.color = 0;
        }
        if (oldColor != this.color) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    private boolean parseBundledInput(@Nullable byte[] data) {
        if (data != null) {
            int c = 0;
            for (int i = 0; i < 15; ++i) {
                if (data[i] == 0) continue;
                c |= 1 << i;
            }
            this.setLampColor(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBundledConnectToInput(@Nullable EnumFacing side) {
        return true;
    }

    @Override
    public boolean canBundledConnectToOutput(@Nullable EnumFacing side) {
        return false;
    }

    @Override
    public byte[] getBundledOutput(@Nullable EnumFacing side) {
        return new byte[16];
    }

    @Override
    public void onBundledInputChange(@Nullable EnumFacing side, @Nullable byte[] data) {
        this.parseBundledInput(data);
    }
}

