/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import pl.asie.computronics.Computronics;

public class RecipeUtils {
    private static int recipeCounter = 0;

    public static void addShapedRecipe(ItemStack result, Object ... recipe) {
        if (result.func_190926_b()) {
            RecipeUtils.warnCrafting(result, recipe);
            return;
        }
        for (Object o : recipe) {
            if (o == null) {
                RecipeUtils.warnCrafting(result, recipe);
                return;
            }
            if (o instanceof Block && Block.func_149682_b((Block)((Block)o)) < 0) {
                RecipeUtils.warnCrafting(result, recipe);
                return;
            }
            if (o instanceof Item && Item.func_150891_b((Item)((Item)o)) < 0) {
                RecipeUtils.warnCrafting(result, recipe);
                return;
            }
            if (!(o instanceof ItemStack) || !((ItemStack)o).func_190926_b()) continue;
            RecipeUtils.warnCrafting(result, recipe);
            return;
        }
        GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, result, recipe).setRegistryName(result.func_77973_b().getRegistryName().func_110623_a() + recipeCounter));
        ++recipeCounter;
    }

    public static void addShapelessRecipe(ItemStack result, Object ... recipe) {
        for (Object o : recipe) {
            if (o == null) {
                RecipeUtils.warnCrafting(result, recipe);
                return;
            }
            if (o instanceof Block && Block.func_149682_b((Block)((Block)o)) < 0) {
                RecipeUtils.warnCrafting(result, recipe);
                return;
            }
            if (o instanceof Item && Item.func_150891_b((Item)((Item)o)) < 0) {
                RecipeUtils.warnCrafting(result, recipe);
                return;
            }
            if (!(o instanceof ItemStack) || !((ItemStack)o).func_190926_b()) continue;
            RecipeUtils.warnCrafting(result, recipe);
            return;
        }
        GameRegistry.findRegistry(IRecipe.class).register(new ShapelessOreRecipe(null, result, recipe).setRegistryName(result.func_77973_b().getRegistryName().func_110623_a() + recipeCounter));
        ++recipeCounter;
    }

    private static void warnCrafting(ItemStack result, Object[] recipe) {
        recipe = (Object[])recipe.clone();
        for (int i = 0; i < recipe.length; ++i) {
            if (recipe[i] != null) continue;
            recipe[i] = "null";
        }
        Computronics.log.warn(String.format("Invalid recipe: %s -> %s", Arrays.toString(recipe), result));
    }
}

