/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.sound;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.sound.AudioType;

@SideOnly(value=Side.CLIENT)
public class Audio {
    private final int sampleRate;
    private final int amplitude;
    private final float maxDistance;
    private final Set<Source> sources = new HashSet<Source>();
    private boolean disableAudio = false;
    private final Set<Source> toRemove = new HashSet<Source>();
    private static Audio INSTANCE;

    private float volume() {
        return Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.BLOCKS);
    }

    public void play(float x, float y, float z, AudioType type, float frequencyInHz, int durationInMilliseconds) {
        this.play(x, y, z, ".", type, frequencyInHz, durationInMilliseconds);
    }

    public void play(float x, float y, float z, String pattern, AudioType type) {
        this.play(x, y, z, pattern, type, 1000.0f, 200);
    }

    public void play(float x, float y, float z, String pattern, AudioType type, float frequencyInHz) {
        this.play(x, y, z, pattern, type, frequencyInHz, 200);
    }

    public void play(float x, float y, float z, String pattern, AudioType type, float frequencyInHz, int durationInMilliseconds) {
        this.play(x, y, z, pattern, type, frequencyInHz, durationInMilliseconds, 0);
    }

    public void play(float x, float y, float z, AudioType type, float frequencyInHz, int durationInMilliseconds, int initialDelayInMilliseconds) {
        this.play(x, y, z, ".", type, frequencyInHz, durationInMilliseconds, initialDelayInMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(float x, float y, float z, String pattern, AudioType type, float frequencyInHz, int durationInMilliseconds, int initialDelayInMilliseconds) {
        Minecraft mc = Minecraft.func_71410_x();
        float distanceBasedGain = (float)Math.max(0.0, 1.0 - mc.field_71439_g.func_70011_f((double)x, (double)y, (double)z) / (double)this.maxDistance);
        float gain = this.volume();
        if (gain <= 0.0f || this.amplitude <= 0) {
            return;
        }
        if (this.disableAudio) {
            float clampedFrequency = Math.min(Math.max(frequencyInHz - 20.0f, 0.0f), 1980.0f) / 1980.0f + 0.5f;
            int delay = 0;
            for (char ch : pattern.toCharArray()) {
                PositionedSoundRecord record = new PositionedSoundRecord(SoundEvents.field_187682_dG, SoundCategory.BLOCKS, distanceBasedGain * gain, clampedFrequency, x, y, z);
                if (delay == 0) {
                    mc.func_147118_V().func_147682_a((ISound)record);
                } else {
                    mc.func_147118_V().func_147681_a((ISound)record, delay);
                }
                delay += Math.max((ch == '.' ? durationInMilliseconds : 2 * durationInMilliseconds) * 20 / 1000, 1);
            }
        } else if (AL.isCreated()) {
            char[] chars = pattern.toCharArray();
            int[] sampleCounts = new int[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                sampleCounts[i] = (chars[i] == '.' ? durationInMilliseconds : 2 * durationInMilliseconds) * this.sampleRate / 1000;
            }
            int pauseSampleCount = 50 * this.sampleRate / 1000;
            int sampleSum = 0;
            for (int i : sampleCounts) {
                sampleSum += i;
            }
            int initialDelay = initialDelayInMilliseconds * this.sampleRate / 1000;
            ByteBuffer data = BufferUtils.createByteBuffer((int)(initialDelay + sampleSum + (sampleCounts.length - 1) * pauseSampleCount));
            for (int sample = 0; sample < initialDelay; ++sample) {
                data.put((byte)127);
            }
            float step = frequencyInHz / (float)this.sampleRate;
            float offset = 0.0f;
            double noiseOutput = Math.random();
            for (int sampleCount : sampleCounts) {
                int sample;
                for (sample = 0; sample < sampleCount; ++sample) {
                    int value = (byte)(type.generate(offset) * (double)this.amplitude) ^ 0x80;
                    if ((offset += step) > 1.0f) {
                        offset %= 1.0f;
                    }
                    data.put((byte)value);
                }
                if (!data.hasRemaining()) continue;
                for (sample = 0; sample < pauseSampleCount; ++sample) {
                    data.put((byte)127);
                }
            }
            data.rewind();
            try {
                Set<Source> set = this.sources;
                synchronized (set) {
                    this.sources.add(new Source(x, y, z, data, gain));
                }
            }
            catch (LessUselessOpenALException lessUselessOpenALException) {
                if (lessUselessOpenALException.errorCode == 40965) {
                    Computronics.log.info("Couldn't play computer speaker sound because your sound card ran out of memory. Either your sound card is just really low-end, or there are just too many sounds in use already by other mods. Disabling computer speakers to avoid spamming your log file now.");
                    this.disableAudio = true;
                }
                Computronics.log.warn("Error playing computer speaker sound.", (Throwable)((Object)lessUselessOpenALException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (!this.disableAudio) {
            Set<Source> set = this.sources;
            synchronized (set) {
                for (Source source : this.sources) {
                    if (!source.checkFinished()) continue;
                    this.toRemove.add(source);
                }
                this.sources.removeAll(this.toRemove);
                this.toRemove.clear();
            }
            if (AL.isCreated()) {
                try {
                    AL10.alGetError();
                }
                catch (UnsatisfiedLinkError e) {
                    Computronics.log.warn("Negotiations with OpenAL broke down, disabling sounds.");
                    this.disableAudio = true;
                }
            }
        }
    }

    void checkALError() {
        int errorCode = AL10.alGetError();
        if (errorCode != 0) {
            throw new LessUselessOpenALException(errorCode);
        }
    }

    private Audio() {
        this.sampleRate = Config.SOUND_SAMPLE_RATE;
        this.amplitude = Config.SOUND_VOLUME;
        this.maxDistance = Config.SOUND_RADIUS;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        this.update();
    }

    public static void init() {
        if (INSTANCE == null) {
            INSTANCE = new Audio();
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static Audio instance() {
        if (INSTANCE == null) {
            Audio.init();
        }
        return INSTANCE;
    }

    class LessUselessOpenALException
    extends OpenALException {
        final int errorCode;

        LessUselessOpenALException(int errorCode) {
            super(errorCode);
            this.errorCode = errorCode;
        }
    }

    private class Source {
        private int source;
        private IntBuffer[] buffers;
        private final Queue<ByteBuffer> bufferData;
        private int index = 0;

        Source(float x, float y, float z, ByteBuffer data, float gain) {
            AL10.alGetError();
            this.buffers = new IntBuffer[2];
            this.buffers[0] = BufferUtils.createIntBuffer((int)1);
            this.buffers[1] = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)this.buffers[0]);
            Audio.this.checkALError();
            this.bufferData = new ArrayDeque<ByteBuffer>(data.capacity() / Audio.this.sampleRate);
            int i = 0;
            while (i * Audio.this.sampleRate < data.capacity()) {
                data.limit(i * Audio.this.sampleRate + Math.min(Audio.this.sampleRate, data.capacity() - i * Audio.this.sampleRate)).position(i * Audio.this.sampleRate);
                this.bufferData.add(data.slice());
                ++i;
            }
            try {
                AL10.alBufferData((int)this.buffers[0].get(0), (int)4352, (ByteBuffer)this.bufferData.poll(), (int)Audio.this.sampleRate);
                Audio.this.checkALError();
                if (!this.bufferData.isEmpty()) {
                    AL10.alGenBuffers((IntBuffer)this.buffers[1]);
                    Audio.this.checkALError();
                    AL10.alBufferData((int)this.buffers[1].get(0), (int)4352, (ByteBuffer)this.bufferData.poll(), (int)Audio.this.sampleRate);
                    Audio.this.checkALError();
                }
                int source = AL10.alGenSources();
                Audio.this.checkALError();
                try {
                    AL10.alSourceQueueBuffers((int)source, (IntBuffer)this.buffers[0]);
                    Audio.this.checkALError();
                    if (AL10.alIsBuffer((int)this.buffers[1].get(0))) {
                        AL10.alSourceQueueBuffers((int)source, (IntBuffer)this.buffers[1]);
                        Audio.this.checkALError();
                    }
                    AL10.alSource3f((int)source, (int)4100, (float)x, (float)y, (float)z);
                    AL10.alSourcef((int)source, (int)4106, (float)(gain * 0.3f));
                    AL10.alSourcef((int)source, (int)4129, (float)(6.0f / Audio.this.maxDistance));
                    Audio.this.checkALError();
                    AL10.alSourcePlay((int)source);
                    Audio.this.checkALError();
                    this.source = source;
                }
                catch (Throwable t) {
                    AL10.alDeleteSources((int)source);
                    throw t;
                }
            }
            catch (Throwable t) {
                for (IntBuffer b : this.buffers) {
                    if (!AL10.alIsBuffer((int)b.get(0))) continue;
                    AL10.alDeleteBuffers((IntBuffer)b);
                }
                throw t;
            }
        }

        public boolean checkFinished() {
            if (AL10.alGetSourcei((int)this.source, (int)4118) > 0) {
                int oldIndex = this.index;
                AL10.alSourceUnqueueBuffers((int)this.source, (IntBuffer)this.buffers[oldIndex]);
                Audio.this.checkALError();
                ByteBuffer buf = this.bufferData.poll();
                if (buf != null) {
                    AL10.alBufferData((int)this.buffers[oldIndex].get(0), (int)4352, (ByteBuffer)buf, (int)Audio.this.sampleRate);
                    AL10.alSourceQueueBuffers((int)this.source, (IntBuffer)this.buffers[oldIndex]);
                    Audio.this.checkALError();
                    this.index = (this.index + 1) % 2;
                }
                return false;
            }
            if (AL10.alGetSourcei((int)this.source, (int)4112) != 4114) {
                AL10.alDeleteSources((int)this.source);
                for (IntBuffer buffer : this.buffers) {
                    if (!AL10.alIsBuffer((int)buffer.get(0))) continue;
                    AL10.alDeleteBuffers((IntBuffer)buffer);
                }
                return true;
            }
            return false;
        }
    }
}

