/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.sound;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.SoundCardPacket;
import pl.asie.computronics.audio.SoundCardPacketClientHandler;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.sound.AudioType;
import pl.asie.computronics.util.sound.AudioUtil;
import pl.asie.computronics.util.sound.Instruction;

public class SoundBoard {
    private ISoundHost host;
    public AudioUtil.AudioProcess process;
    private ArrayDeque<Instruction> buildBuffer;
    private ArrayDeque<Instruction> nextBuffer;
    private int buildDelay = 0;
    private int nextDelay = 0;
    private long timeout = System.currentTimeMillis();
    private int soundVolume = 127;
    public Integer codecId;
    private String clientAddress = null;
    private final int soundTimeoutMS = 250;
    private boolean bufferInit = false;
    private boolean dirty = false;
    private static HashMap<Object, Object> modes;

    public SoundBoard(ISoundHost host) {
        this.process = new AudioUtil.AudioProcess(Config.SOUND_CARD_CHANNEL_COUNT);
        this.host = host;
        this.initBuffers();
    }

    private void initBuffers() {
        if (this.bufferInit) {
            return;
        }
        World world = this.host.world();
        if (world == null) {
            return;
        }
        if (world.field_72995_K) {
            SyncHandler.envs.add(this);
            this.buildBuffer = null;
            this.nextBuffer = null;
            if (this.clientAddress != null) {
                SyncHandler.getHandler().setProcess(this.clientAddress, this.process);
            }
        } else {
            this.buildBuffer = new ArrayDeque();
            this.nextBuffer = new ArrayDeque();
        }
        this.bufferInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.initBuffers();
        if (!this.host.world().field_72995_K) {
            if (this.nextBuffer != null && !this.nextBuffer.isEmpty() && System.currentTimeMillis() >= this.timeout - 100L) {
                Object clone;
                ArrayDeque<Instruction> arrayDeque = this.nextBuffer;
                synchronized (arrayDeque) {
                    clone = this.nextBuffer.clone();
                    this.timeout += (long)this.nextDelay;
                    this.nextBuffer.clear();
                }
                this.sendSound((Queue<Instruction>)clone);
                this.dirty = true;
            } else if (this.codecId != null && System.currentTimeMillis() >= this.timeout + 250L) {
                AudioUtils.removePlayer(Computronics.instance.soundCardManagerId, this.codecId);
                this.codecId = null;
            }
            if (this.dirty) {
                this.host.setDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(NBTTagCompound nbt) {
        ArrayDeque<Instruction> arrayDeque;
        NBTTagCompound nodeNBT;
        if (nbt.func_74764_b("process")) {
            this.process.load(nbt.func_74775_l("process"));
        }
        if (nbt.func_74764_b("node") && (nodeNBT = nbt.func_74775_l("node")).func_74764_b("address")) {
            this.clientAddress = nodeNBT.func_74779_i("address");
        }
        if (nbt.func_74764_b("bbuffer") && this.buildBuffer != null) {
            arrayDeque = this.buildBuffer;
            synchronized (arrayDeque) {
                this.buildBuffer.clear();
                this.buildBuffer.addAll(Instruction.fromNBT(nbt.func_150295_c("bbuffer", 10)));
                this.buildDelay = 0;
                for (Instruction inst : this.buildBuffer) {
                    if (!(inst instanceof Instruction.Delay)) continue;
                    this.buildDelay += ((Instruction.Delay)inst).delay;
                }
            }
        }
        if (nbt.func_74764_b("nbuffer") && this.nextBuffer != null) {
            arrayDeque = this.nextBuffer;
            synchronized (arrayDeque) {
                this.nextBuffer.clear();
                this.nextBuffer.addAll(Instruction.fromNBT(nbt.func_150295_c("nbuffer", 10)));
                this.nextDelay = 0;
                for (Instruction inst : this.nextBuffer) {
                    if (!(inst instanceof Instruction.Delay)) continue;
                    this.nextDelay += ((Instruction.Delay)inst).delay;
                }
            }
        }
        if (nbt.func_74764_b("volume")) {
            this.soundVolume = nbt.func_74771_c("volume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(NBTTagCompound nbt) {
        ArrayDeque<Instruction> arrayDeque;
        NBTTagCompound processNBT = new NBTTagCompound();
        nbt.func_74782_a("process", (NBTBase)processNBT);
        this.process.save(processNBT);
        if (this.buildBuffer != null && !this.buildBuffer.isEmpty()) {
            NBTTagList buildNBT = new NBTTagList();
            arrayDeque = this.buildBuffer;
            synchronized (arrayDeque) {
                Instruction.toNBT(buildNBT, this.buildBuffer);
            }
            nbt.func_74782_a("bbuffer", (NBTBase)buildNBT);
        }
        if (this.nextBuffer != null && !this.nextBuffer.isEmpty()) {
            NBTTagList nextNBT = new NBTTagList();
            arrayDeque = this.nextBuffer;
            synchronized (arrayDeque) {
                Instruction.toNBT(nextNBT, this.nextBuffer);
            }
            nbt.func_74782_a("nbuffer", (NBTBase)nextNBT);
        }
        nbt.func_74774_a("volume", (byte)this.soundVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAndStop() {
        ArrayDeque<Instruction> arrayDeque;
        if (this.buildBuffer != null && !this.buildBuffer.isEmpty()) {
            arrayDeque = this.buildBuffer;
            synchronized (arrayDeque) {
                this.buildBuffer.clear();
            }
        }
        if (this.nextBuffer != null && !this.nextBuffer.isEmpty()) {
            arrayDeque = this.nextBuffer;
            synchronized (arrayDeque) {
                this.nextBuffer.clear();
            }
        }
        this.buildDelay = 0;
        if (this.codecId != null) {
            AudioUtils.removePlayer(Computronics.instance.soundCardManagerId, this.codecId);
            this.codecId = null;
        }
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] tryAdd(Instruction inst) {
        ArrayDeque<Instruction> arrayDeque = this.buildBuffer;
        synchronized (arrayDeque) {
            if (this.buildBuffer.size() >= Config.SOUND_CARD_QUEUE_SIZE) {
                return new Object[]{false, "too many instructions"};
            }
            this.buildBuffer.add(inst);
        }
        this.dirty = true;
        return new Object[]{true};
    }

    public static HashMap<Object, Object> compileModes() {
        if (modes == null) {
            HashMap<Object, Object> modes = new HashMap<Object, Object>(AudioType.VALUES.length * 2);
            for (AudioType value : AudioType.VALUES) {
                String name = value.name().toLowerCase(Locale.ENGLISH);
                modes.put(value.ordinal() + 1, name);
                modes.put(name, value.ordinal() + 1);
            }
            modes.put("noise", -1);
            modes.put(-1, "noise");
            SoundBoard.modes = modes;
        }
        return modes;
    }

    public int checkChannel(int channel) {
        if (--channel >= 0 && channel < this.process.states.size()) {
            return channel;
        }
        throw new IllegalArgumentException("invalid channel: " + (channel + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayDeque<Instruction> arrayDeque = this.buildBuffer;
        synchronized (arrayDeque) {
            this.buildBuffer.clear();
        }
        this.buildDelay = 0;
        this.dirty = true;
    }

    public Object[] delay(int duration) {
        if (duration < 0 || duration > Config.SOUND_CARD_MAX_DELAY) {
            throw new IllegalArgumentException("invalid duration. must be between 0 and " + Config.SOUND_CARD_MAX_DELAY);
        }
        if (this.buildDelay + duration > Config.SOUND_CARD_MAX_DELAY) {
            return new Object[]{false, "too many delays in queue"};
        }
        this.buildDelay += duration;
        return this.tryAdd(new Instruction.Delay(duration));
    }

    public void setTotalVolume(double volume) {
        if (volume < 0.0) {
            volume = 0.0;
        }
        if (volume > 1.0) {
            volume = 1.0;
        }
        this.soundVolume = MathHelper.func_76128_c((double)(volume * 127.0));
    }

    public Object[] setWave(int channel, int mode) {
        channel = this.checkChannel(channel);
        switch (--mode) {
            case -2: {
                return this.tryAdd(new Instruction.SetWhiteNoise(channel));
            }
        }
        if (mode >= 0 && mode < AudioType.VALUES.length) {
            return this.tryAdd(new Instruction.SetWave(channel, AudioType.fromIndex(mode)));
        }
        throw new IllegalArgumentException("invalid mode: " + (mode + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] process() {
        ArrayDeque<Instruction> arrayDeque = this.buildBuffer;
        synchronized (arrayDeque) {
            if (this.nextBuffer != null && this.nextBuffer.isEmpty()) {
                if (this.buildBuffer.size() == 0) {
                    return new Object[]{true};
                }
                if (!this.host.tryConsumeEnergy(Config.SOUND_CARD_ENERGY_COST * ((double)this.buildDelay / 1000.0))) {
                    return new Object[]{false, "not enough energy"};
                }
                ArrayDeque<Instruction> arrayDeque2 = this.nextBuffer;
                synchronized (arrayDeque2) {
                    this.nextBuffer.addAll(new ArrayDeque<Instruction>(this.buildBuffer));
                }
                this.nextDelay = this.buildDelay;
                this.buildBuffer.clear();
                this.buildDelay = 0;
                if (System.currentTimeMillis() > this.timeout) {
                    this.timeout = System.currentTimeMillis();
                }
                this.dirty = true;
                return new Object[]{true};
            }
            return new Object[]{false, System.currentTimeMillis() - this.timeout};
        }
    }

    private void sendMusicPacket(Queue<Instruction> instructions) {
        if (this.codecId == null) {
            this.codecId = Computronics.instance.soundCardAudio.newPlayer();
            Computronics.instance.soundCardAudio.getPlayer(this.codecId);
        }
        SoundCardPacket pkt = new SoundCardPacket(this.host, (byte)this.soundVolume, this.host.address(), instructions);
        this.host.sendMusicPacket(pkt);
    }

    protected void sendSound(Queue<Instruction> buffer) {
        ArrayDeque<Instruction> sendBuffer = new ArrayDeque<Instruction>();
        while (!buffer.isEmpty() || this.process.delay > 0) {
            if (this.process.delay > 0) {
                this.process.delay = 0;
                continue;
            }
            Instruction inst = buffer.poll();
            inst.encounter(this.process);
            sendBuffer.add(inst);
        }
        if (sendBuffer.size() > 0) {
            this.sendMusicPacket(sendBuffer);
        }
    }

    public static interface ISoundHost
    extends IAudioSource {
        public World world();

        public boolean tryConsumeEnergy(double var1);

        public String address();

        public BlockPos position();

        public void sendMusicPacket(SoundCardPacket var1);

        public void setDirty();
    }

    public static class SyncHandler {
        static Set<SoundBoard> envs = Collections.newSetFromMap(new WeakHashMap());

        @SideOnly(value=Side.CLIENT)
        private static SoundCardPacketClientHandler getHandler() {
            return (SoundCardPacketClientHandler)AudioPacketRegistry.INSTANCE.getClientHandler(AudioPacketRegistry.INSTANCE.getId(SoundCardPacket.class));
        }

        @SubscribeEvent
        public void onChunkUnload(ChunkEvent.Unload evt) {
            for (SoundBoard env : envs) {
                BlockPos pos = env.host.position();
                if (env.host.world() != evt.getWorld() || !evt.getChunk().func_76600_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
                SyncHandler.getHandler().setProcess(env.clientAddress, null);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload evt) {
            for (SoundBoard env : envs) {
                if (env.host.world() != evt.getWorld()) continue;
                SyncHandler.getHandler().setProcess(env.clientAddress, null);
            }
        }
    }
}

