/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.network;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.asie.lib.util.WorldUtils;

public class Packet
implements IMessage {
    private final ByteBuf write;
    private ByteBuf read;
    private final Gson gson = new Gson();

    public Packet() {
        this.write = Unpooled.buffer();
    }

    @Nullable
    public TileEntity readTileEntity() throws IOException {
        Object world = null;
        int dimensionId = this.readInt();
        int x = this.readInt();
        int y = this.readInt();
        int z = this.readInt();
        return WorldUtils.getTileEntity(dimensionId, x, y, z);
    }

    @Nullable
    public TileEntity readTileEntityServer() throws IOException {
        Object world = null;
        int dimensionId = this.readInt();
        int x = this.readInt();
        int y = this.readInt();
        int z = this.readInt();
        return WorldUtils.getTileEntityServer(dimensionId, x, y, z);
    }

    public byte[] readByteArray() throws IOException {
        return this.readByteArrayData(this.read.readUnsignedShort());
    }

    public byte[] readByteArrayData(int size) throws IOException {
        byte[] data = new byte[size];
        this.read.readBytes(data, 0, size);
        return data;
    }

    public Object readJSON(Type t) throws IOException {
        return this.gson.fromJson(ByteBufUtils.readUTF8String((ByteBuf)this.read), t);
    }

    public Object readJSON(Class<?> t) throws IOException {
        return this.gson.fromJson(ByteBufUtils.readUTF8String((ByteBuf)this.read), t);
    }

    public byte readByte() throws IOException {
        return this.read.readByte();
    }

    public short readShort() throws IOException {
        return this.read.readShort();
    }

    public byte readSignedByte() throws IOException {
        return this.read.readByte();
    }

    public short readSignedShort() throws IOException {
        return this.read.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.read.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.read.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.read.readInt();
    }

    public long readLong() throws IOException {
        return this.read.readLong();
    }

    public double readDouble() throws IOException {
        return this.read.readDouble();
    }

    public float readFloat() throws IOException {
        return this.read.readFloat();
    }

    public String readString() throws IOException {
        return ByteBufUtils.readUTF8String((ByteBuf)this.read);
    }

    public Packet writeTileLocation(TileEntity te) throws IOException, RuntimeException {
        if (te.func_145831_w() == null) {
            throw new RuntimeException("World does not exist!");
        }
        if (te.func_145837_r()) {
            throw new RuntimeException("TileEntity is invalid!");
        }
        this.write.writeInt(te.func_145831_w().field_73011_w.getDimension());
        BlockPos pos = te.func_174877_v();
        this.write.writeInt(pos.func_177958_n());
        this.write.writeInt(pos.func_177956_o());
        this.write.writeInt(pos.func_177952_p());
        return this;
    }

    public Packet writeByteArray(byte[] array) throws IOException, RuntimeException {
        if (array.length > 65535) {
            throw new RuntimeException("Invalid array size!");
        }
        this.write.writeShort(array.length);
        this.write.writeBytes(array);
        return this;
    }

    public Packet writeByteArrayData(byte[] array) throws IOException {
        this.write.writeBytes(array);
        return this;
    }

    public Packet writeByte(byte v) throws IOException {
        this.write.writeByte((int)v);
        return this;
    }

    public Packet writeBoolean(boolean v) throws IOException {
        this.write.writeBoolean(v);
        return this;
    }

    public Packet writeString(String s) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)this.write, (String)s);
        return this;
    }

    public Packet writeShort(short v) throws IOException {
        this.write.writeShort((int)v);
        return this;
    }

    public Packet writeInt(int v) throws IOException {
        this.write.writeInt(v);
        return this;
    }

    public Packet writeDouble(double v) throws IOException {
        this.write.writeDouble(v);
        return this;
    }

    public Packet writeFloat(float v) throws IOException {
        this.write.writeFloat(v);
        return this;
    }

    public Packet writeLong(long v) throws IOException {
        this.write.writeLong(v);
        return this;
    }

    public void fromBytes(ByteBuf buf) {
        this.read = buf;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBytes(this.write);
    }
}

