/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.tile;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import pl.asie.lib.api.tile.IBattery;
import pl.asie.lib.tile.TileEntityBase;

public class TileMachine
extends TileEntityBase
implements ISidedInventory {
    private IBattery battery;
    @Nullable
    private ItemStack[] items;
    private boolean didInitIC2 = false;

    public IBattery getBatteryProvider() {
        return this.battery;
    }

    protected void registerBattery(IBattery p) {
        this.battery = p;
    }

    protected void createInventory(int slots) {
        this.items = new ItemStack[slots];
        Arrays.fill(this.items, ItemStack.field_190927_a);
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void update() {
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    @Override
    public void closeInventory() {
    }

    @Override
    public void openInventory() {
    }

    public void onSlotUpdate(int slot) {
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.items != null && !this.items[slot].func_190926_b()) {
            if (this.items[slot].func_190916_E() <= amount) {
                ItemStack stack = this.items[slot];
                this.items[slot] = ItemStack.field_190927_a;
                this.onSlotUpdate(slot);
                return stack;
            }
            ItemStack stack = this.items[slot].func_77979_a(amount);
            if (this.items[slot].func_190916_E() == 0) {
                this.items[slot] = ItemStack.field_190927_a;
            }
            this.onSlotUpdate(slot);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public String func_70005_c_() {
        return this.field_145854_h != null ? this.field_145854_h.func_149739_a() + ".inventory" : "unknown.inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_70302_i_() {
        if (this.items != null) {
            return this.items.length;
        }
        return 0;
    }

    public boolean func_191420_l() {
        if (this.items == null) {
            return true;
        }
        for (ItemStack item : this.items) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.items != null && slot >= 0 && slot < this.items.length) {
            return this.items[slot];
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.items != null && slot >= 0 && slot < this.items.length;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.items != null && slot >= 0 && slot < this.items.length) {
            this.items[slot] = stack;
            this.onSlotUpdate(slot);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.items == null) {
            return new int[0];
        }
        int[] slots = new int[this.items.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        if (this.battery != null) {
            return this.battery.canInsert(from, "RF");
        }
        return false;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.battery != null && this.battery.canInsert(from, "RF")) {
            return (int)Math.floor(this.battery.insert(from, maxReceive, simulate));
        }
        return 0;
    }

    public int extractEnergy(@Nullable EnumFacing from, int maxExtract, boolean simulate) {
        if (this.battery != null && this.battery.canExtract(from, "RF")) {
            return (int)Math.floor(this.battery.extract(from, maxExtract, simulate));
        }
        return 0;
    }

    public int getEnergyStored(@Nullable EnumFacing from) {
        if (this.battery != null) {
            return (int)Math.floor(this.battery.getEnergyStored());
        }
        return 0;
    }

    public int getMaxEnergyStored(@Nullable EnumFacing from) {
        if (this.battery != null) {
            return (int)Math.floor(this.battery.getMaxEnergyStored());
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (this.battery != null) {
            this.battery.readFromNBT(tagCompound);
        }
        if (this.items != null) {
            int i;
            NBTTagList nbttaglist = tagCompound.func_150295_c("Inventory", 10);
            this.items = new ItemStack[this.func_70302_i_()];
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.items.length) continue;
                this.items[j] = new ItemStack(nbttagcompound1);
            }
            for (i = 0; i < this.items.length; ++i) {
                if (this.items[i] != null) continue;
                this.items[i] = ItemStack.field_190927_a;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.battery != null) {
            this.battery.writeToNBT(tagCompound);
        }
        if (this.items != null) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack stack = this.items[i];
                if (stack == null || stack.func_190926_b()) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }
        return tagCompound;
    }

    public void removeFromNBTForTransfer(NBTTagCompound data) {
        data.func_82580_o("Inventory");
        data.func_82580_o("bb_energy");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.battery != null && capability == CapabilityEnergy.ENERGY && this.battery.getStorage(facing) != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.battery != null && capability == CapabilityEnergy.ENERGY && this.battery.getStorage(facing) != null) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.battery.getStorage(facing));
        }
        return (T)super.getCapability(capability, facing);
    }
}

