/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;

public final class BoundTileRenderer {
    private BoundTileRenderer() {
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        BlockPos coords;
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)64);
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int color = Color.HSBtoRGB((float)(ClientTickHandler.ticksInGame % 200) / 200.0f, 0.6f, 1.0f);
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)player.func_184614_ca().func_77973_b()).getBinding(player.func_184614_ca())) != null) {
            BoundTileRenderer.renderBlockOutlineAt(coords, color);
        }
        if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)player.func_184592_cb().func_77973_b()).getBinding(player.func_184592_cb())) != null) {
            BoundTileRenderer.renderBlockOutlineAt(coords, color);
        }
        IItemHandlerModifiable mainInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        IItemHandlerModifiable baublesInv = BotaniaAPI.internalHandler.getBaublesInventoryWrapped((EntityPlayer)player);
        IItemHandlerModifiable joined = baublesInv != null ? new CombinedInvWrapper(new IItemHandlerModifiable[]{mainInv, baublesInv}) : mainInv;
        for (int i = 0; i < joined.getSlots(); ++i) {
            ItemStack stackInSlot = joined.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IWireframeCoordinateListProvider)) continue;
            IWireframeCoordinateListProvider provider = (IWireframeCoordinateListProvider)stackInSlot.func_77973_b();
            List<BlockPos> coordsList = provider.getWireframesToDraw((EntityPlayer)player, stackInSlot);
            for (BlockPos coords2 : coordsList) {
                BoundTileRenderer.renderBlockOutlineAt(coords2, color);
            }
            BlockPos coords3 = provider.getSourceWireframe((EntityPlayer)player, stackInSlot);
            if (coords3 == null || coords3.func_177956_o() <= -1) continue;
            BoundTileRenderer.renderBlockOutlineAt(coords3, color, 5.0f);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private static void renderBlockOutlineAt(BlockPos pos, int color) {
        BoundTileRenderer.renderBlockOutlineAt(pos, color, 1.0f);
    }

    private static void renderBlockOutlineAt(BlockPos pos, int color, float thickness) {
        AxisAlignedBB axis;
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - renderPosX), (double)((double)pos.func_177956_o() - renderPosY), (double)((double)pos.func_177952_p() - renderPosZ + 1.0));
        Color colorRGB = new Color(color);
        GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)-1);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != null && (axis = block instanceof IWireframeAABBProvider ? ((IWireframeAABBProvider)block).getWireframeAABB((World)world, pos) : state.func_185918_c((World)world, pos)) != null) {
            axis = axis.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-(pos.func_177952_p() + 1)));
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glLineWidth((float)thickness);
            BoundTileRenderer.renderBlockOutline(axis);
            GL11.glLineWidth((float)(thickness + 3.0f));
            GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)64);
            BoundTileRenderer.renderBlockOutline(axis);
        }
        GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        GlStateManager.func_179121_F();
    }

    private static void renderBlockOutline(AxisAlignedBB aabb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        double ix = aabb.field_72340_a;
        double iy = aabb.field_72338_b;
        double iz = aabb.field_72339_c;
        double ax = aabb.field_72336_d;
        double ay = aabb.field_72337_e;
        double az = aabb.field_72334_f;
        tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ix, ay, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, iy, az).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, iz).func_181675_d();
        tessellator.func_178180_c().func_181662_b(ax, ay, az).func_181675_d();
        tessellator.func_78381_a();
    }
}

